package org.apache.commons.jexl3.internal.introspection;

import java.util.Map;

public final class MapGetExecutor extends AbstractExecutor.Get {
   private static final java.lang.reflect.Method MAP_GET = initMarker(Map.class, "get", new Class[]{Object.class});
   private final Object property;

   public static MapGetExecutor discover(Introspector is, Class<?> clazz, Object identifier) {
      return Map.class.isAssignableFrom(clazz) ? new MapGetExecutor(clazz, MAP_GET, identifier) : null;
   }

   private MapGetExecutor(Class<?> clazz, java.lang.reflect.Method method, Object key) {
      super(clazz, method);
      this.property = key;
   }

   public Object getTargetProperty() {
      return this.property;
   }

   public Object invoke(Object obj) {
      Map<Object, ?> map = (Map)obj;
      return map.get(this.property);
   }

   public Object tryInvoke(Object obj, Object key) {
      if (obj == null || this.method == null || !this.objectClass.equals(obj.getClass()) || (this.property != null || key != null) && (this.property == null || key == null || !this.property.getClass().equals(key.getClass()))) {
         return TRY_FAILED;
      } else {
         Map<Object, ?> map = (Map)obj;
         return map.get(key);
      }
   }
}
