package org.apache.commons.jexl3.internal.introspection;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;

public final class MapSetExecutor extends AbstractExecutor.Set {
   private static final java.lang.reflect.Method MAP_SET = initMarker(Map.class, "put", new Class[]{Object.class, Object.class});
   private final Object property;

   public static MapSetExecutor discover(Introspector is, Class<?> clazz, Object identifier, Object value) {
      return Map.class.isAssignableFrom(clazz) ? new MapSetExecutor(clazz, MAP_SET, identifier) : null;
   }

   private MapSetExecutor(Class<?> clazz, java.lang.reflect.Method method, Object key) {
      super(clazz, method);
      this.property = key;
   }

   public Object getTargetProperty() {
      return this.property;
   }

   public Object invoke(Object obj, Object value) throws IllegalAccessException, InvocationTargetException {
      Map<Object, Object> map = (Map)obj;
      map.put(this.property, value);
      return value;
   }

   public Object tryInvoke(Object obj, Object key, Object value) {
      if (obj == null || this.method == null || !this.objectClass.equals(obj.getClass()) || (this.property != null || key != null) && (this.property == null || key == null || !this.property.getClass().equals(key.getClass()))) {
         return TRY_FAILED;
      } else {
         Map<Object, Object> map = (Map)obj;
         map.put(key, value);
         return value;
      }
   }
}
