package org.apache.commons.jexl3.internal.introspection;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.jexl3.JexlEngine;

public final class MethodExecutor extends AbstractExecutor.Method {
   private final int vaStart;
   private final Class<?> vaClass;

   public static MethodExecutor discover(Introspector is, Object obj, String method, Object[] args) {
      Class<?> clazz = obj.getClass();
      MethodKey key = new MethodKey(method, args);
      java.lang.reflect.Method m = is.getMethod(clazz, key);
      if (m == null && clazz.isArray()) {
         m = is.getMethod(ArrayListWrapper.class, key);
      }

      if (m == null && obj instanceof Class) {
         m = is.getMethod((Class)obj, key);
      }

      return m == null ? null : new MethodExecutor(clazz, m, key);
   }

   private MethodExecutor(Class<?> c, java.lang.reflect.Method m, MethodKey k) {
      super(c, m, k);
      int vastart = -1;
      Class<?> vaclass = null;
      if (this.method != null) {
         Class<?>[] formal = this.method.getParameterTypes();
         if (formal != null && MethodKey.isVarArgs(this.method)) {
            vastart = formal.length - 1;
            vaclass = formal[vastart].getComponentType();
         }
      }

      this.vaStart = vastart;
      this.vaClass = vaclass;
   }

   public Object invoke(Object o, Object... args) throws IllegalAccessException, InvocationTargetException {
      if (this.vaClass != null) {
         args = this.handleVarArg(args);
      }

      return this.method.getDeclaringClass() == ArrayListWrapper.class && o.getClass().isArray() ? this.method.invoke(new ArrayListWrapper(o), args) : this.method.invoke(o, args);
   }

   public Object tryInvoke(String name, Object obj, Object... args) {
      MethodKey tkey = new MethodKey(name, args);
      if (this.objectClass.equals(obj.getClass()) && tkey.equals(this.key)) {
         try {
            return this.invoke(obj, args);
         } catch (InvocationTargetException var6) {
            return TRY_FAILED;
         } catch (IllegalAccessException var7) {
            return TRY_FAILED;
         } catch (IllegalArgumentException var8) {
            return TRY_FAILED;
         }
      } else {
         return JexlEngine.TRY_FAILED;
      }
   }

   private Object[] handleVarArg(Object[] actual) {
      Class<?> vaclass = this.vaClass;
      int vastart = this.vaStart;
      int varargc = actual.length - vastart;
      if (varargc == 1) {
         if (actual[vastart] != null) {
            Class<?> aclazz = actual[vastart].getClass();
            if (!aclazz.isArray() || !vaclass.isAssignableFrom(aclazz.getComponentType())) {
               Object lastActual = Array.newInstance(vaclass, 1);
               Array.set(lastActual, 0, actual[vastart]);
               actual[vastart] = lastActual;
            }
         }
      } else {
         Object varargs = Array.newInstance(vaclass, varargc);
         System.arraycopy(actual, vastart, varargs, 0, varargc);
         Object[] newActual = new Object[vastart + 1];
         System.arraycopy(actual, 0, newActual, 0, vastart);
         newActual[vastart] = varargs;
         actual = newActual;
      }

      return actual;
   }
}
