package org.apache.commons.jexl3.internal.introspection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.jexl3.annotations.NoJexl;

public class Permissions {
   private Permissions() {
   }

   public static boolean allow(Class<?> clazz) {
      return allow(clazz, true);
   }

   public static boolean allow(Constructor<?> ctor) {
      if (ctor == null) {
         return false;
      } else {
         Class<?> clazz = ctor.getDeclaringClass();
         if (!allow(clazz, false)) {
            return false;
         } else {
            NoJexl nojexl = (NoJexl)ctor.getAnnotation(NoJexl.class);
            return nojexl == null;
         }
      }
   }

   public static boolean allow(Field field) {
      if (field == null) {
         return false;
      } else {
         Class<?> clazz = field.getDeclaringClass();
         if (!allow(clazz, false)) {
            return false;
         } else {
            NoJexl nojexl = (NoJexl)field.getAnnotation(NoJexl.class);
            return nojexl == null;
         }
      }
   }

   public static boolean allow(Method method) {
      if (method == null) {
         return false;
      } else {
         NoJexl nojexl = (NoJexl)method.getAnnotation(NoJexl.class);
         if (nojexl != null) {
            return false;
         } else {
            Class<?> clazz = method.getDeclaringClass();
            nojexl = (NoJexl)clazz.getAnnotation(NoJexl.class);
            if (nojexl != null) {
               return false;
            } else {
               for(Class<?> inter : clazz.getInterfaces()) {
                  if (!allow(inter, method)) {
                     return false;
                  }
               }

               for(Class<?> var8 = clazz.getSuperclass(); var8 != null; var8 = var8.getSuperclass()) {
                  if (!allow(var8, method)) {
                     return false;
                  }
               }

               return true;
            }
         }
      }
   }

   private static boolean allow(Class<?> clazz, boolean interf) {
      if (clazz == null) {
         return false;
      } else {
         Package pack = clazz.getPackage();
         if (pack != null && pack.getAnnotation(NoJexl.class) != null) {
            return false;
         } else {
            if (interf) {
               for(Class<?> inter : clazz.getInterfaces()) {
                  NoJexl nojexl = (NoJexl)inter.getAnnotation(NoJexl.class);
                  if (nojexl != null) {
                     return false;
                  }
               }
            }

            for(Class<?> var8 = clazz.getSuperclass(); var8 != null; var8 = var8.getSuperclass()) {
               NoJexl nojexl = (NoJexl)var8.getAnnotation(NoJexl.class);
               if (nojexl != null) {
                  return false;
               }
            }

            return true;
         }
      }
   }

   private static boolean allow(Class<?> clazz, Method method) {
      if (clazz != null) {
         try {
            Method wmethod = clazz.getMethod(method.getName(), method.getParameterTypes());
            if (wmethod != null) {
               NoJexl nojexl = (NoJexl)clazz.getAnnotation(NoJexl.class);
               if (nojexl != null) {
                  return false;
               }

               nojexl = (NoJexl)wmethod.getAnnotation(NoJexl.class);
               if (nojexl != null) {
                  return false;
               }
            }
         } catch (NoSuchMethodException var4) {
            return true;
         } catch (SecurityException var5) {
            return false;
         }
      }

      return true;
   }
}
