package org.apache.commons.jexl3.internal.introspection;

import java.lang.reflect.InvocationTargetException;

public final class PropertyGetExecutor extends AbstractExecutor.Get {
   private static final Object[] EMPTY_PARAMS = new Object[0];
   private final String property;

   public static PropertyGetExecutor discover(Introspector is, Class<?> clazz, String property) {
      java.lang.reflect.Method method = discoverGet(is, "get", clazz, property);
      return method == null ? null : new PropertyGetExecutor(clazz, method, property);
   }

   private PropertyGetExecutor(Class<?> clazz, java.lang.reflect.Method method, String identifier) {
      super(clazz, method);
      this.property = identifier;
   }

   public Object getTargetProperty() {
      return this.property;
   }

   public Object invoke(Object o) throws IllegalAccessException, InvocationTargetException {
      return this.method == null ? null : this.method.invoke(o, (Object[])null);
   }

   public Object tryInvoke(Object o, Object identifier) {
      if (o != null && this.method != null && this.property.equals(castString(identifier)) && this.objectClass.equals(o.getClass())) {
         try {
            return this.method.invoke(o, (Object[])null);
         } catch (InvocationTargetException var4) {
            return TRY_FAILED;
         } catch (IllegalAccessException var5) {
            return TRY_FAILED;
         } catch (IllegalArgumentException var6) {
            return TRY_FAILED;
         }
      } else {
         return TRY_FAILED;
      }
   }

   static java.lang.reflect.Method discoverGet(Introspector is, String which, Class<?> clazz, String property) {
      if (property != null && !property.isEmpty()) {
         int start = which.length();
         StringBuilder sb = new StringBuilder(which);
         sb.append(property);
         char c = sb.charAt(start);
         sb.setCharAt(start, Character.toUpperCase(c));
         java.lang.reflect.Method method = is.getMethod(clazz, sb.toString(), EMPTY_PARAMS);
         if (method == null) {
            sb.setCharAt(start, Character.toLowerCase(c));
            method = is.getMethod(clazz, sb.toString(), EMPTY_PARAMS);
         }

         return method;
      } else {
         return null;
      }
   }
}
