package org.apache.commons.jexl3.internal.introspection;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;

public class PropertySetExecutor extends AbstractExecutor.Set {
   private static final int SET_START_INDEX = 3;
   protected final String property;

   public static PropertySetExecutor discover(Introspector is, Class<?> clazz, String property, Object arg) {
      if (property != null && !property.isEmpty()) {
         java.lang.reflect.Method method = discoverSet(is, clazz, property, arg);
         return method != null ? new PropertySetExecutor(clazz, method, property) : null;
      } else {
         return null;
      }
   }

   protected PropertySetExecutor(Class<?> clazz, java.lang.reflect.Method method, String key) {
      super(clazz, method);
      this.property = key;
   }

   public Object getTargetProperty() {
      return this.property;
   }

   public Object invoke(Object o, Object arg) throws IllegalAccessException, InvocationTargetException {
      if (this.method != null) {
         if (isEmptyArray(arg)) {
            Class<?> componentType = this.method.getParameterTypes()[0].getComponentType();
            if (componentType != null && !componentType.equals(arg.getClass().getComponentType())) {
               arg = Array.newInstance(componentType, 0);
            }
         }

         this.method.invoke(o, arg);
      }

      return arg;
   }

   public Object tryInvoke(Object o, Object identifier, Object arg) {
      if (o != null && this.method != null && this.property.equals(castString(identifier)) && this.objectClass.equals(o.getClass())) {
         try {
            return this.invoke(o, arg);
         } catch (InvocationTargetException var5) {
            return TRY_FAILED;
         } catch (IllegalAccessException var6) {
            return TRY_FAILED;
         } catch (IllegalArgumentException var7) {
            return TRY_FAILED;
         }
      } else {
         return TRY_FAILED;
      }
   }

   private static boolean isEmptyArray(Object arg) {
      return arg != null && arg.getClass().isArray() && Array.getLength(arg) == 0;
   }

   private static java.lang.reflect.Method discoverSet(Introspector is, Class<?> clazz, String property, Object arg) {
      Object[] params = new Object[]{arg};
      StringBuilder sb = new StringBuilder("set");
      sb.append(property);
      char c = sb.charAt(3);
      sb.setCharAt(3, Character.toUpperCase(c));
      java.lang.reflect.Method method = is.getMethod(clazz, sb.toString(), params);
      if (method == null) {
         sb.setCharAt(3, Character.toLowerCase(c));
         method = is.getMethod(clazz, sb.toString(), params);
         if (method == null && isEmptyArray(arg)) {
            sb.setCharAt(3, Character.toUpperCase(c));
            method = lookupSetEmptyArray(is, clazz, sb.toString());
            if (method == null) {
               sb.setCharAt(3, Character.toLowerCase(c));
               method = lookupSetEmptyArray(is, clazz, sb.toString());
            }
         }
      }

      return method;
   }

   private static java.lang.reflect.Method lookupSetEmptyArray(Introspector is, Class<?> clazz, String mname) {
      java.lang.reflect.Method candidate = null;
      java.lang.reflect.Method[] methods = is.getMethods(clazz, mname);
      if (methods != null) {
         for(java.lang.reflect.Method method : methods) {
            Class<?>[] paramTypes = method.getParameterTypes();
            if (paramTypes.length == 1 && paramTypes[0].isArray()) {
               if (candidate != null) {
                  return null;
               }

               candidate = method;
            }
         }
      }

      return candidate;
   }
}
