package org.apache.commons.jexl3.internal.introspection;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlOperator;
import org.apache.commons.jexl3.introspection.JexlMethod;
import org.apache.commons.jexl3.introspection.JexlPropertyGet;
import org.apache.commons.jexl3.introspection.JexlPropertySet;
import org.apache.commons.jexl3.introspection.JexlSandbox;
import org.apache.commons.jexl3.introspection.JexlUberspect;

public final class SandboxUberspect implements JexlUberspect {
   private final JexlUberspect uberspect;
   private final JexlSandbox sandbox;

   public SandboxUberspect(JexlUberspect theUberspect, JexlSandbox theSandbox) {
      if (theSandbox == null) {
         throw new NullPointerException("sandbox can not be null");
      } else if (theUberspect == null) {
         throw new NullPointerException("uberspect can not be null");
      } else {
         this.uberspect = theUberspect;
         this.sandbox = theSandbox.copy();
      }
   }

   public void setClassLoader(ClassLoader loader) {
      this.uberspect.setClassLoader(loader);
   }

   public int getVersion() {
      return this.uberspect.getVersion();
   }

   public JexlMethod getConstructor(Object ctorHandle, Object... args) {
      String className;
      if (ctorHandle instanceof Class) {
         Class<?> clazz = (Class)ctorHandle;
         className = clazz.getName();
      } else {
         if (ctorHandle == null) {
            return null;
         }

         className = ctorHandle.toString();
      }

      return this.sandbox.execute(className, "") != null ? this.uberspect.getConstructor(className, args) : null;
   }

   public JexlMethod getMethod(Object obj, String method, Object... args) {
      if (obj != null && method != null) {
         String objClassName = obj instanceof Class ? ((Class)obj).getName() : obj.getClass().getName();
         String actual = this.sandbox.execute(objClassName, method);
         if (actual != null) {
            return this.uberspect.getMethod(obj, actual, args);
         }
      }

      return null;
   }

   public List<PropertyResolver> getResolvers(JexlOperator op, Object obj) {
      return this.uberspect.getResolvers(op, obj);
   }

   public JexlPropertyGet getPropertyGet(Object obj, Object identifier) {
      return this.getPropertyGet((List)null, obj, identifier);
   }

   public JexlPropertyGet getPropertyGet(List<PropertyResolver> resolvers, Object obj, Object identifier) {
      if (obj != null && identifier != null) {
         String actual = this.sandbox.read(obj.getClass().getName(), identifier.toString());
         if (actual != null) {
            return this.uberspect.getPropertyGet(resolvers, obj, actual);
         }
      }

      return null;
   }

   public JexlPropertySet getPropertySet(Object obj, Object identifier, Object arg) {
      return this.getPropertySet((List)null, obj, identifier, arg);
   }

   public JexlPropertySet getPropertySet(List<PropertyResolver> resolvers, Object obj, Object identifier, Object arg) {
      if (obj != null && identifier != null) {
         String actual = this.sandbox.write(obj.getClass().getName(), identifier.toString());
         if (actual != null) {
            return this.uberspect.getPropertySet(resolvers, obj, actual, arg);
         }
      }

      return null;
   }

   public Iterator<?> getIterator(Object obj) {
      return this.uberspect.getIterator(obj);
   }

   public JexlArithmetic.Uberspect getArithmetic(JexlArithmetic arithmetic) {
      return this.uberspect.getArithmetic(arithmetic);
   }
}
