package org.apache.commons.jexl3.introspection;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlOperator;

public interface JexlUberspect {
   List<PropertyResolver> POJO = Collections.unmodifiableList(Arrays.asList(JexlResolver.PROPERTY, JexlResolver.MAP, JexlResolver.LIST, JexlResolver.DUCK, JexlResolver.FIELD, JexlResolver.CONTAINER));
   List<PropertyResolver> MAP = Collections.unmodifiableList(Arrays.asList(JexlResolver.MAP, JexlResolver.LIST, JexlResolver.DUCK, JexlResolver.PROPERTY, JexlResolver.FIELD, JexlResolver.CONTAINER));
   ResolverStrategy JEXL_STRATEGY = new ResolverStrategy() {
      public List<PropertyResolver> apply(JexlOperator op, Object obj) {
         if (op == JexlOperator.ARRAY_GET) {
            return JexlUberspect.MAP;
         } else if (op == JexlOperator.ARRAY_SET) {
            return JexlUberspect.MAP;
         } else {
            return op == null && obj instanceof Map ? JexlUberspect.MAP : JexlUberspect.POJO;
         }
      }
   };
   ResolverStrategy MAP_STRATEGY = new ResolverStrategy() {
      public List<PropertyResolver> apply(JexlOperator op, Object obj) {
         if (op == JexlOperator.ARRAY_GET) {
            return JexlUberspect.MAP;
         } else if (op == JexlOperator.ARRAY_SET) {
            return JexlUberspect.MAP;
         } else {
            return obj instanceof Map ? JexlUberspect.MAP : JexlUberspect.POJO;
         }
      }
   };

   List<PropertyResolver> getResolvers(JexlOperator var1, Object var2);

   void setClassLoader(ClassLoader var1);

   int getVersion();

   JexlMethod getConstructor(Object var1, Object... var2);

   JexlMethod getMethod(Object var1, String var2, Object... var3);

   JexlPropertyGet getPropertyGet(Object var1, Object var2);

   JexlPropertyGet getPropertyGet(List<PropertyResolver> var1, Object var2, Object var3);

   JexlPropertySet getPropertySet(Object var1, Object var2, Object var3);

   JexlPropertySet getPropertySet(List<PropertyResolver> var1, Object var2, Object var3, Object var4);

   Iterator<?> getIterator(Object var1);

   JexlArithmetic.Uberspect getArithmetic(JexlArithmetic var1);

   public static enum JexlResolver implements PropertyResolver {
      PROPERTY,
      MAP,
      LIST,
      DUCK,
      FIELD,
      CONTAINER;

      public final JexlPropertyGet getPropertyGet(JexlUberspect uber, Object obj, Object identifier) {
         return uber.getPropertyGet(Collections.singletonList(this), obj, identifier);
      }

      public final JexlPropertySet getPropertySet(JexlUberspect uber, Object obj, Object identifier, Object arg) {
         return uber.getPropertySet(Collections.singletonList(this), obj, identifier, arg);
      }
   }

   public interface PropertyResolver {
      JexlPropertyGet getPropertyGet(JexlUberspect var1, Object var2, Object var3);

      JexlPropertySet getPropertySet(JexlUberspect var1, Object var2, Object var3, Object var4);
   }

   public interface ResolverStrategy {
      List<PropertyResolver> apply(JexlOperator var1, Object var2);
   }
}
