package org.apache.commons.jexl3.parser;

public class ASTAnnotation extends JexlNode {
   private String name = null;

   ASTAnnotation(int id) {
      super(id);
   }

   ASTAnnotation(Parser p, int id) {
      super(p, id);
   }

   public String toString() {
      return this.name;
   }

   void setName(String identifier) {
      if (identifier.charAt(0) == '@') {
         this.name = identifier.substring(1);
      } else {
         this.name = identifier;
      }

   }

   public String getName() {
      return this.name;
   }

   public Object jjtAccept(ParserVisitor visitor, Object data) {
      return visitor.visit(this, data);
   }
}
