package org.apache.commons.jexl3.parser;

import org.apache.commons.jexl3.internal.Debugger;

public final class ASTArrayLiteral extends JexlNode {
   private boolean constant = false;

   ASTArrayLiteral(int id) {
      super(id);
   }

   ASTArrayLiteral(Parser p, int id) {
      super(p, id);
   }

   public String toString() {
      Debugger dbg = new Debugger();
      return dbg.data(this);
   }

   protected boolean isConstant(boolean literal) {
      return this.constant;
   }

   public void jjtClose() {
      this.constant = true;

      for(int c = 0; c < this.jjtGetNumChildren() && this.constant; ++c) {
         JexlNode child = this.jjtGetChild(c);
         if (child instanceof ASTReference) {
            this.constant = child.isConstant(true);
         } else if (!child.isConstant()) {
            this.constant = false;
         }
      }

   }

   public Object jjtAccept(ParserVisitor visitor, Object data) {
      return visitor.visit(this, data);
   }
}
