package org.apache.commons.jexl3.parser;

public class ASTIdentifier extends JexlNode {
   private String name = null;
   private int symbol = -1;

   ASTIdentifier(int id) {
      super(id);
   }

   ASTIdentifier(Parser p, int id) {
      super(p, id);
   }

   public String toString() {
      return this.name;
   }

   void setSymbol(String identifier) {
      if (identifier.charAt(0) == '#') {
         this.symbol = Integer.parseInt(identifier.substring(1));
      }

      this.name = identifier;
   }

   void setSymbol(int r, String identifier) {
      this.symbol = r;
      this.name = identifier;
   }

   public int getSymbol() {
      return this.symbol;
   }

   public String getName() {
      return this.name;
   }

   public Object jjtAccept(ParserVisitor visitor, Object data) {
      return visitor.visit(this, data);
   }
}
