package org.apache.commons.jexl3.parser;

import org.apache.commons.jexl3.internal.Scope;

public final class ASTJexlLambda extends ASTJexlScript {
   ASTJexlLambda(int id) {
      super(id);
   }

   ASTJexlLambda(Parser p, int id) {
      super(p, id);
   }

   public boolean isTopLevel() {
      return this.jjtGetParent() == null;
   }

   public Scope.Frame createFrame(Scope.Frame frame, Object... values) {
      if (this.getScope() != null) {
         Scope.Frame cframe = this.getScope().createFrame(frame);
         if (cframe != null) {
            return cframe.assign(values);
         }
      }

      return null;
   }
}
