package org.apache.commons.jexl3.parser;

public final class ASTNumberLiteral extends JexlNode implements JexlNode.Constant<Number> {
   private final NumberParser nlp = new NumberParser();

   ASTNumberLiteral(int id) {
      super(id);
   }

   ASTNumberLiteral(Parser p, int id) {
      super(p, id);
   }

   public String toString() {
      return this.nlp.toString();
   }

   public Number getLiteral() {
      return this.nlp.getLiteralValue();
   }

   protected boolean isConstant(boolean literal) {
      return true;
   }

   public Class<?> getLiteralClass() {
      return this.nlp.getLiteralClass();
   }

   public boolean isInteger() {
      return this.nlp.isInteger();
   }

   void setNatural(String s) {
      this.nlp.setNatural(s);
   }

   void setReal(String s) {
      this.nlp.setReal(s);
   }

   public Object jjtAccept(ParserVisitor visitor, Object data) {
      return visitor.visit(this, data);
   }
}
