package org.apache.commons.jexl3.parser;

public final class ASTStringLiteral extends JexlNode implements JexlNode.Constant<String> {
   private String literal = null;

   ASTStringLiteral(int id) {
      super(id);
   }

   ASTStringLiteral(Parser p, int id) {
      super(p, id);
   }

   public String toString() {
      return this.literal;
   }

   public String getLiteral() {
      return this.literal;
   }

   protected boolean isConstant(boolean literal) {
      return true;
   }

   void setLiteral(String literal) {
      this.literal = literal;
   }

   public Object jjtAccept(ParserVisitor visitor, Object data) {
      return visitor.visit(this, data);
   }
}
