package org.apache.commons.jexl3.parser;

import org.apache.commons.jexl3.JexlInfo;
import org.apache.commons.jexl3.introspection.JexlMethod;
import org.apache.commons.jexl3.introspection.JexlPropertyGet;
import org.apache.commons.jexl3.introspection.JexlPropertySet;

public abstract class JexlNode extends SimpleNode {
   private int lc = -1;

   public JexlNode(int id) {
      super(id);
   }

   public JexlNode(Parser p, int id) {
      super(p, id);
   }

   public void jjtSetFirstToken(Token t) {
      this.lc = t.beginLine << 12 | 4095 & t.beginColumn;
   }

   public void jjtSetLastToken(Token t) {
   }

   public JexlInfo jexlInfo() {
      JexlInfo info = null;

      for(JexlNode node = this; node != null; node = node.jjtGetParent()) {
         if (node.jjtGetValue() instanceof JexlInfo) {
            info = (JexlInfo)node.jjtGetValue();
            break;
         }
      }

      if (this.lc >= 0) {
         int c = this.lc & 4095;
         int l = this.lc >> 12;
         return info != null ? info.at(l, c) : new JexlInfo(null, l, c);
      } else {
         return info;
      }
   }

   public void clearCache() {
      Object value = this.jjtGetValue();
      if (value instanceof JexlPropertyGet || value instanceof JexlPropertySet || value instanceof JexlMethod) {
         this.jjtSetValue(null);
      }

      for(int n = 0; n < this.jjtGetNumChildren(); ++n) {
         this.jjtGetChild(n).clearCache();
      }

   }

   public boolean isConstant() {
      return this.isConstant(this instanceof Constant);
   }

   protected boolean isConstant(boolean literal) {
      if (literal) {
         for(int n = 0; n < this.jjtGetNumChildren(); ++n) {
            JexlNode child = this.jjtGetChild(n);
            if (child instanceof ASTReference) {
               boolean is = child.isConstant(true);
               if (!is) {
                  return false;
               }
            } else if (child instanceof ASTMapEntry) {
               boolean is = child.isConstant(true);
               if (!is) {
                  return false;
               }
            } else if (!child.isConstant()) {
               return false;
            }
         }

         return true;
      } else {
         return false;
      }
   }

   public boolean isLeftValue() {
      if (!(this instanceof ASTIdentifier) && !(this instanceof ASTIdentifierAccess)) {
         int nc = this.jjtGetNumChildren() - 1;
         if (nc >= 0) {
            JexlNode last = this.jjtGetChild(this.jjtGetNumChildren() - 1);
            return last.isLeftValue();
         } else {
            return this.jjtGetParent() instanceof ASTReference || this.jjtGetParent() instanceof ASTArrayAccess;
         }
      } else {
         return true;
      }
   }

   public interface Constant<T> {
      T getLiteral();
   }
}
