package org.apache.commons.jexl3.parser;

public class ParseException extends Exception implements JavaccError {
   private static final long serialVersionUID = 1L;
   private String after = "";
   private int line = -1;
   private int column = -1;

   public ParseException(Token currentToken, int[][] expectedTokenSequences, String[] tokenImage) {
      super("parse error");
      Token tok = currentToken.next;
      this.after = tok.image;
      this.line = tok.beginLine;
      this.column = tok.beginColumn;
   }

   public ParseException() {
   }

   public ParseException(String message) {
      super(message);
   }

   public int getLine() {
      return this.line;
   }

   public int getColumn() {
      return this.column;
   }

   public String getAfter() {
      return this.after;
   }
}
