package org.apache.commons.jexl3.parser;

import java.io.IOException;
import java.io.PrintStream;

public class ParserTokenManager implements ParserConstants {
   int dotLexState;
   public PrintStream debugStream;
   static final long[] jjbitVec0 = new long[]{-4294967298L, -1L, -1L, -1L};
   static final long[] jjbitVec2 = new long[]{0L, 0L, -1L, -1L};
   static final long[] jjbitVec3 = new long[]{-3298534883329L, -1L, -1L, -1L};
   static final long[] jjbitVec4 = new long[]{-2L, -1L, -1L, -1L};
   static final int[] jjnextStates = new int[]{71, 72, 74, 53, 54, 60, 61, 62, 59, 79, 85, 70, 77, 43, 44, 46, 38, 39, 41, 66, 67, 36, 86, 87, 89, 48, 49, 51, 55, 56, 59, 60, 61, 62, 59, 81, 82, 84, 98, 99, 95, 96, 91, 93, 57, 58, 63, 64, 62, 63, 65, 55, 61, 45, 46, 48, 40, 41, 43, 1, 2, 4, 50, 51, 53, 57, 58, 60, 74, 75, 71, 72, 67, 69, 88, 89, 91, 73, 74, 76, 55, 56, 62, 63, 64, 61, 81, 87, 72, 79, 68, 69, 38, 57, 58, 61, 62, 63, 64, 61, 83, 84, 86, 100, 101, 97, 98, 93, 95, 59, 60, 65, 66};
   public static final String[] jjstrLiteralImages = new String[]{"", null, null, null, null, null, null, null, null, "if", "else", "for", "while", "new", "var", "empty", "size", "null", "true", "false", "return", "function", "->", "break", "continue", "#pragma", "(", ")", "{", "}", "[", "]", ";", ":", ",", ".", "...", "?", "?:", null, null, null, null, "=~", "!~", "=^", "=$", "!^", "!$", null, null, null, null, "+=", "-=", "*=", "/=", "%=", "&=", "|=", "^=", "=", "+", "-", "*", null, null, null, "&", "|", "^", "~", "..", "NaN", null, null, null, null, null, null, null, null, null, null};
   public static final String[] lexStateNames = new String[]{"REGISTERS", "DOT_ID", "DEFAULT"};
   public static final int[] jjnewLexState = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
   static final long[] jjtoToken = new long[]{-511L, 1023999L};
   static final long[] jjtoSkip = new long[]{510L, 0L};
   protected SimpleCharStream input_stream;
   private final int[] jjrounds;
   private final int[] jjstateSet;
   private final StringBuilder jjimage;
   private StringBuilder image;
   private int jjimageLen;
   private int lengthOfMatch;
   protected char curChar;
   int curLexState;
   int defaultLexState;
   int jjnewStateCnt;
   int jjround;
   int jjmatchedPos;
   int jjmatchedKind;

   public void pushDot() {
      this.dotLexState = this.curLexState;
      this.curLexState = 1;
   }

   public void popDot() {
      if (this.curLexState == 1) {
         this.curLexState = this.dotLexState;
         this.dotLexState = this.defaultLexState;
      }

   }

   public void setDebugStream(PrintStream ds) {
      this.debugStream = ds;
   }

   private final int jjStopStringLiteralDfa_2(int pos, long active0, long active1) {
      switch (pos) {
         case 0:
            if ((active0 & 72057594037927936L) != 0L) {
               this.jjmatchedKind = 65;
               return 79;
            } else if ((active0 & 439804651110400L) != 0L) {
               this.jjmatchedKind = 67;
               return 13;
            } else if ((active0 & 139264L) != 0L) {
               this.jjmatchedKind = 76;
               return 91;
            } else {
               if ((active0 & 288230376151711744L) == 0L && (active1 & 16L) == 0L) {
                  if ((active0 & 2305957358422982656L) != 0L) {
                     return 9;
                  }

                  if ((active0 & 29186560L) == 0L && (active1 & 512L) == 0L) {
                     if ((active0 & 33554432L) != 0L) {
                        return 70;
                     }

                     if ((active0 & 144115188075855872L) != 0L) {
                        this.jjmatchedKind = 66;
                        return -1;
                     }

                     if ((active0 & 33792L) != 0L) {
                        this.jjmatchedKind = 76;
                        return 11;
                     }

                     if ((active0 & 576460752303423488L) == 0L && (active1 & 32L) == 0L) {
                        return -1;
                     }

                     return 5;
                  }

                  this.jjmatchedKind = 76;
                  return 33;
               }

               return 0;
            }
         case 1:
            if ((active0 & 512L) != 0L) {
               return 33;
            } else if ((active0 & 144115188075855872L) != 0L) {
               if (this.jjmatchedPos == 0) {
                  this.jjmatchedKind = 66;
                  this.jjmatchedPos = 0;
               }

               return -1;
            } else {
               if ((active0 & 29350912L) == 0L && (active1 & 512L) == 0L) {
                  if ((active0 & 8192L) != 0L) {
                     if (this.jjmatchedPos != 1) {
                        this.jjmatchedKind = 42;
                        this.jjmatchedPos = 1;
                     }

                     return 33;
                  }

                  return -1;
               }

               if (this.jjmatchedPos != 1) {
                  this.jjmatchedKind = 76;
                  this.jjmatchedPos = 1;
               }

               return 33;
            }
         case 2:
            if ((active0 & 26624L) == 0L && (active1 & 512L) == 0L) {
               if ((active0 & 29332480L) != 0L) {
                  this.jjmatchedKind = 76;
                  this.jjmatchedPos = 2;
                  return 33;
               }

               return -1;
            }

            return 33;
         case 3:
            if ((active0 & 28872704L) != 0L) {
               this.jjmatchedKind = 76;
               this.jjmatchedPos = 3;
               return 33;
            } else {
               if ((active0 & 459776L) != 0L) {
                  return 33;
               }

               return -1;
            }
         case 4:
            if ((active0 & 8949760L) != 0L) {
               return 33;
            } else {
               if ((active0 & 19922944L) != 0L) {
                  this.jjmatchedKind = 76;
                  this.jjmatchedPos = 4;
                  return 33;
               }

               return -1;
            }
         case 5:
            if ((active0 & 1048576L) != 0L) {
               return 33;
            } else {
               if ((active0 & 18874368L) != 0L) {
                  this.jjmatchedKind = 76;
                  this.jjmatchedPos = 5;
                  return 33;
               }

               return -1;
            }
         case 6:
            if ((active0 & 18874368L) != 0L) {
               this.jjmatchedKind = 76;
               this.jjmatchedPos = 6;
               return 33;
            }

            return -1;
         default:
            return -1;
      }
   }

   private final int jjStartNfa_2(int pos, long active0, long active1) {
      return this.jjMoveNfa_2(this.jjStopStringLiteralDfa_2(pos, active0, active1), pos + 1);
   }

   private int jjStopAtPos(int pos, int kind) {
      this.jjmatchedKind = kind;
      this.jjmatchedPos = pos;
      return pos + 1;
   }

   private int jjMoveStringLiteralDfa0_2() {
      switch (this.curChar) {
         case '!':
            return this.jjMoveStringLiteralDfa1_2(439804651110400L, 0L);
         case '"':
         case '$':
         case '\'':
         case '0':
         case '1':
         case '2':
         case '3':
         case '4':
         case '5':
         case '6':
         case '7':
         case '8':
         case '9':
         case '<':
         case '>':
         case '@':
         case 'A':
         case 'B':
         case 'C':
         case 'D':
         case 'E':
         case 'F':
         case 'G':
         case 'H':
         case 'I':
         case 'J':
         case 'K':
         case 'L':
         case 'M':
         case 'O':
         case 'P':
         case 'Q':
         case 'R':
         case 'S':
         case 'T':
         case 'U':
         case 'V':
         case 'W':
         case 'X':
         case 'Y':
         case 'Z':
         case '\\':
         case '_':
         case '`':
         case 'a':
         case 'd':
         case 'g':
         case 'h':
         case 'j':
         case 'k':
         case 'l':
         case 'm':
         case 'o':
         case 'p':
         case 'q':
         case 'u':
         case 'x':
         case 'y':
         case 'z':
         default:
            return this.jjMoveNfa_2(1, 0);
         case '#':
            return this.jjMoveStringLiteralDfa1_2(33554432L, 0L);
         case '%':
            return this.jjMoveStringLiteralDfa1_2(144115188075855872L, 0L);
         case '&':
            this.jjmatchedKind = 68;
            return this.jjMoveStringLiteralDfa1_2(288230376151711744L, 0L);
         case '(':
            return this.jjStopAtPos(0, 26);
         case ')':
            return this.jjStopAtPos(0, 27);
         case '*':
            this.jjmatchedKind = 64;
            return this.jjMoveStringLiteralDfa1_2(36028797018963968L, 0L);
         case '+':
            this.jjmatchedKind = 62;
            return this.jjMoveStringLiteralDfa1_2(9007199254740992L, 0L);
         case ',':
            return this.jjStopAtPos(0, 34);
         case '-':
            this.jjmatchedKind = 63;
            return this.jjMoveStringLiteralDfa1_2(18014398513676288L, 0L);
         case '.':
            this.jjmatchedKind = 35;
            return this.jjMoveStringLiteralDfa1_2(68719476736L, 256L);
         case '/':
            return this.jjMoveStringLiteralDfa1_2(72057594037927936L, 0L);
         case ':':
            return this.jjStopAtPos(0, 33);
         case ';':
            return this.jjStopAtPos(0, 32);
         case '=':
            this.jjmatchedKind = 61;
            return this.jjMoveStringLiteralDfa1_2(114349209288704L, 0L);
         case '?':
            this.jjmatchedKind = 37;
            return this.jjMoveStringLiteralDfa1_2(274877906944L, 0L);
         case 'N':
            return this.jjMoveStringLiteralDfa1_2(0L, 512L);
         case '[':
            return this.jjStopAtPos(0, 30);
         case ']':
            return this.jjStopAtPos(0, 31);
         case '^':
            this.jjmatchedKind = 70;
            return this.jjMoveStringLiteralDfa1_2(1152921504606846976L, 0L);
         case 'b':
            return this.jjMoveStringLiteralDfa1_2(8388608L, 0L);
         case 'c':
            return this.jjMoveStringLiteralDfa1_2(16777216L, 0L);
         case 'e':
            return this.jjMoveStringLiteralDfa1_2(33792L, 0L);
         case 'f':
            return this.jjMoveStringLiteralDfa1_2(2623488L, 0L);
         case 'i':
            return this.jjMoveStringLiteralDfa1_2(512L, 0L);
         case 'n':
            return this.jjMoveStringLiteralDfa1_2(139264L, 0L);
         case 'r':
            return this.jjMoveStringLiteralDfa1_2(1048576L, 0L);
         case 's':
            return this.jjMoveStringLiteralDfa1_2(65536L, 0L);
         case 't':
            return this.jjMoveStringLiteralDfa1_2(262144L, 0L);
         case 'v':
            return this.jjMoveStringLiteralDfa1_2(16384L, 0L);
         case 'w':
            return this.jjMoveStringLiteralDfa1_2(4096L, 0L);
         case '{':
            return this.jjStopAtPos(0, 28);
         case '|':
            this.jjmatchedKind = 69;
            return this.jjMoveStringLiteralDfa1_2(576460752303423488L, 0L);
         case '}':
            return this.jjStopAtPos(0, 29);
         case '~':
            return this.jjStopAtPos(0, 71);
      }
   }

   private int jjMoveStringLiteralDfa1_2(long active0, long active1) {
      try {
         this.curChar = this.input_stream.readChar();
      } catch (IOException var6) {
         this.jjStopStringLiteralDfa_2(0, active0, active1);
         return 1;
      }

      switch (this.curChar) {
         case '$':
            if ((active0 & 70368744177664L) != 0L) {
               return this.jjStopAtPos(1, 46);
            }

            if ((active0 & 281474976710656L) != 0L) {
               return this.jjStopAtPos(1, 48);
            }
            break;
         case '.':
            if ((active1 & 256L) != 0L) {
               this.jjmatchedKind = 72;
               this.jjmatchedPos = 1;
            }

            return this.jjMoveStringLiteralDfa2_2(active0, 68719476736L, active1, 0L);
         case ':':
            if ((active0 & 274877906944L) != 0L) {
               return this.jjStopAtPos(1, 38);
            }
            break;
         case '=':
            if ((active0 & 9007199254740992L) != 0L) {
               return this.jjStopAtPos(1, 53);
            }

            if ((active0 & 18014398509481984L) != 0L) {
               return this.jjStopAtPos(1, 54);
            }

            if ((active0 & 36028797018963968L) != 0L) {
               return this.jjStopAtPos(1, 55);
            }

            if ((active0 & 72057594037927936L) != 0L) {
               return this.jjStopAtPos(1, 56);
            }

            if ((active0 & 144115188075855872L) != 0L) {
               return this.jjStopAtPos(1, 57);
            }

            if ((active0 & 288230376151711744L) != 0L) {
               return this.jjStopAtPos(1, 58);
            }

            if ((active0 & 576460752303423488L) != 0L) {
               return this.jjStopAtPos(1, 59);
            }

            if ((active0 & 1152921504606846976L) != 0L) {
               return this.jjStopAtPos(1, 60);
            }
            break;
         case '>':
            if ((active0 & 4194304L) != 0L) {
               return this.jjStopAtPos(1, 22);
            }
            break;
         case '^':
            if ((active0 & 35184372088832L) != 0L) {
               return this.jjStopAtPos(1, 45);
            }

            if ((active0 & 140737488355328L) != 0L) {
               return this.jjStopAtPos(1, 47);
            }
            break;
         case 'a':
            return this.jjMoveStringLiteralDfa2_2(active0, 540672L, active1, 512L);
         case 'e':
            return this.jjMoveStringLiteralDfa2_2(active0, 1056768L, active1, 0L);
         case 'f':
            if ((active0 & 512L) != 0L) {
               return this.jjStartNfaWithStates_2(1, 9, 33);
            }
            break;
         case 'h':
            return this.jjMoveStringLiteralDfa2_2(active0, 4096L, active1, 0L);
         case 'i':
            return this.jjMoveStringLiteralDfa2_2(active0, 65536L, active1, 0L);
         case 'l':
            return this.jjMoveStringLiteralDfa2_2(active0, 1024L, active1, 0L);
         case 'm':
            return this.jjMoveStringLiteralDfa2_2(active0, 32768L, active1, 0L);
         case 'o':
            return this.jjMoveStringLiteralDfa2_2(active0, 16779264L, active1, 0L);
         case 'p':
            return this.jjMoveStringLiteralDfa2_2(active0, 33554432L, active1, 0L);
         case 'r':
            return this.jjMoveStringLiteralDfa2_2(active0, 8650752L, active1, 0L);
         case 'u':
            return this.jjMoveStringLiteralDfa2_2(active0, 2228224L, active1, 0L);
         case '~':
            if ((active0 & 8796093022208L) != 0L) {
               return this.jjStopAtPos(1, 43);
            }

            if ((active0 & 17592186044416L) != 0L) {
               return this.jjStopAtPos(1, 44);
            }
      }

      return this.jjStartNfa_2(0, active0, active1);
   }

   private int jjMoveStringLiteralDfa2_2(long old0, long active0, long old1, long active1) {
      if (((active0 = active0 & old0) | (active1 = active1 & old1)) == 0L) {
         return this.jjStartNfa_2(0, old0, old1);
      } else {
         try {
            this.curChar = this.input_stream.readChar();
         } catch (IOException var10) {
            this.jjStopStringLiteralDfa_2(1, active0, active1);
            return 2;
         }

         switch (this.curChar) {
            case '.':
               if ((active0 & 68719476736L) != 0L) {
                  return this.jjStopAtPos(2, 36);
               }
               break;
            case 'N':
               if ((active1 & 512L) != 0L) {
                  return this.jjStartNfaWithStates_2(2, 73, 33);
               }
               break;
            case 'e':
               return this.jjMoveStringLiteralDfa3_2(active0, 8388608L, active1, 0L);
            case 'i':
               return this.jjMoveStringLiteralDfa3_2(active0, 4096L, active1, 0L);
            case 'l':
               return this.jjMoveStringLiteralDfa3_2(active0, 655360L, active1, 0L);
            case 'n':
               return this.jjMoveStringLiteralDfa3_2(active0, 18874368L, active1, 0L);
            case 'p':
               return this.jjMoveStringLiteralDfa3_2(active0, 32768L, active1, 0L);
            case 'r':
               if ((active0 & 2048L) != 0L) {
                  return this.jjStartNfaWithStates_2(2, 11, 33);
               }

               if ((active0 & 16384L) != 0L) {
                  return this.jjStartNfaWithStates_2(2, 14, 33);
               }

               return this.jjMoveStringLiteralDfa3_2(active0, 33554432L, active1, 0L);
            case 's':
               return this.jjMoveStringLiteralDfa3_2(active0, 1024L, active1, 0L);
            case 't':
               return this.jjMoveStringLiteralDfa3_2(active0, 1048576L, active1, 0L);
            case 'u':
               return this.jjMoveStringLiteralDfa3_2(active0, 262144L, active1, 0L);
            case 'w':
               if ((active0 & 8192L) != 0L) {
                  return this.jjStartNfaWithStates_2(2, 13, 33);
               }
               break;
            case 'z':
               return this.jjMoveStringLiteralDfa3_2(active0, 65536L, active1, 0L);
         }

         return this.jjStartNfa_2(1, active0, active1);
      }
   }

   private int jjMoveStringLiteralDfa3_2(long old0, long active0, long old1, long active1) {
      if (((active0 = active0 & old0) | active1 & old1) == 0L) {
         return this.jjStartNfa_2(1, old0, old1);
      } else {
         try {
            this.curChar = this.input_stream.readChar();
         } catch (IOException var10) {
            this.jjStopStringLiteralDfa_2(2, active0, 0L);
            return 3;
         }

         switch (this.curChar) {
            case 'a':
               return this.jjMoveStringLiteralDfa4_2(active0, 41943040L);
            case 'c':
               return this.jjMoveStringLiteralDfa4_2(active0, 2097152L);
            case 'e':
               if ((active0 & 1024L) != 0L) {
                  return this.jjStartNfaWithStates_2(3, 10, 33);
               } else if ((active0 & 65536L) != 0L) {
                  return this.jjStartNfaWithStates_2(3, 16, 33);
               } else if ((active0 & 262144L) != 0L) {
                  return this.jjStartNfaWithStates_2(3, 18, 33);
               }
            case 'b':
            case 'd':
            case 'f':
            case 'g':
            case 'h':
            case 'i':
            case 'j':
            case 'k':
            case 'm':
            case 'n':
            case 'o':
            case 'p':
            case 'q':
            case 'r':
            default:
               return this.jjStartNfa_2(2, active0, 0L);
            case 'l':
               if ((active0 & 131072L) != 0L) {
                  return this.jjStartNfaWithStates_2(3, 17, 33);
               }

               return this.jjMoveStringLiteralDfa4_2(active0, 4096L);
            case 's':
               return this.jjMoveStringLiteralDfa4_2(active0, 524288L);
            case 't':
               return this.jjMoveStringLiteralDfa4_2(active0, 16809984L);
            case 'u':
               return this.jjMoveStringLiteralDfa4_2(active0, 1048576L);
         }
      }
   }

   private int jjMoveStringLiteralDfa4_2(long old0, long active0) {
      if ((active0 = active0 & old0) == 0L) {
         return this.jjStartNfa_2(2, old0, 0L);
      } else {
         try {
            this.curChar = this.input_stream.readChar();
         } catch (IOException var6) {
            this.jjStopStringLiteralDfa_2(3, active0, 0L);
            return 4;
         }

         switch (this.curChar) {
            case 'e':
               if ((active0 & 4096L) != 0L) {
                  return this.jjStartNfaWithStates_2(4, 12, 33);
               }

               if ((active0 & 524288L) != 0L) {
                  return this.jjStartNfaWithStates_2(4, 19, 33);
               }
            case 'f':
            case 'h':
            case 'j':
            case 'l':
            case 'm':
            case 'n':
            case 'o':
            case 'p':
            case 'q':
            case 's':
            case 'u':
            case 'v':
            case 'w':
            case 'x':
            default:
               break;
            case 'g':
               return this.jjMoveStringLiteralDfa5_2(active0, 33554432L);
            case 'i':
               return this.jjMoveStringLiteralDfa5_2(active0, 16777216L);
            case 'k':
               if ((active0 & 8388608L) != 0L) {
                  return this.jjStartNfaWithStates_2(4, 23, 33);
               }
               break;
            case 'r':
               return this.jjMoveStringLiteralDfa5_2(active0, 1048576L);
            case 't':
               return this.jjMoveStringLiteralDfa5_2(active0, 2097152L);
            case 'y':
               if ((active0 & 32768L) != 0L) {
                  return this.jjStartNfaWithStates_2(4, 15, 33);
               }
         }

         return this.jjStartNfa_2(3, active0, 0L);
      }
   }

   private int jjMoveStringLiteralDfa5_2(long old0, long active0) {
      if ((active0 = active0 & old0) == 0L) {
         return this.jjStartNfa_2(3, old0, 0L);
      } else {
         try {
            this.curChar = this.input_stream.readChar();
         } catch (IOException var6) {
            this.jjStopStringLiteralDfa_2(4, active0, 0L);
            return 5;
         }

         switch (this.curChar) {
            case 'i':
               return this.jjMoveStringLiteralDfa6_2(active0, 2097152L);
            case 'm':
               return this.jjMoveStringLiteralDfa6_2(active0, 33554432L);
            case 'n':
               if ((active0 & 1048576L) != 0L) {
                  return this.jjStartNfaWithStates_2(5, 20, 33);
               }

               return this.jjMoveStringLiteralDfa6_2(active0, 16777216L);
            default:
               return this.jjStartNfa_2(4, active0, 0L);
         }
      }
   }

   private int jjMoveStringLiteralDfa6_2(long old0, long active0) {
      if ((active0 = active0 & old0) == 0L) {
         return this.jjStartNfa_2(4, old0, 0L);
      } else {
         try {
            this.curChar = this.input_stream.readChar();
         } catch (IOException var6) {
            this.jjStopStringLiteralDfa_2(5, active0, 0L);
            return 6;
         }

         switch (this.curChar) {
            case 'a':
               if ((active0 & 33554432L) != 0L) {
                  return this.jjStopAtPos(6, 25);
               }
            default:
               return this.jjStartNfa_2(5, active0, 0L);
            case 'o':
               return this.jjMoveStringLiteralDfa7_2(active0, 2097152L);
            case 'u':
               return this.jjMoveStringLiteralDfa7_2(active0, 16777216L);
         }
      }
   }

   private int jjMoveStringLiteralDfa7_2(long old0, long active0) {
      if ((active0 = active0 & old0) == 0L) {
         return this.jjStartNfa_2(5, old0, 0L);
      } else {
         try {
            this.curChar = this.input_stream.readChar();
         } catch (IOException var6) {
            this.jjStopStringLiteralDfa_2(6, active0, 0L);
            return 7;
         }

         switch (this.curChar) {
            case 'e':
               if ((active0 & 16777216L) != 0L) {
                  return this.jjStartNfaWithStates_2(7, 24, 33);
               }
               break;
            case 'n':
               if ((active0 & 2097152L) != 0L) {
                  return this.jjStartNfaWithStates_2(7, 21, 33);
               }
         }

         return this.jjStartNfa_2(6, active0, 0L);
      }
   }

   private int jjStartNfaWithStates_2(int pos, int kind, int state) {
      this.jjmatchedKind = kind;
      this.jjmatchedPos = pos;

      try {
         this.curChar = this.input_stream.readChar();
      } catch (IOException var5) {
         return pos + 1;
      }

      return this.jjMoveNfa_2(state, pos + 1);
   }

   private int jjMoveNfa_2(int startState, int curPos) {
      int startsAt = 0;
      this.jjnewStateCnt = 100;
      int i = 1;
      this.jjstateSet[0] = startState;
      int kind = Integer.MAX_VALUE;

      while(true) {
         if (++this.jjround == Integer.MAX_VALUE) {
            this.ReInitRounds();
         }

         if (this.curChar < '@') {
            long l = 1L << this.curChar;

            do {
               --i;
               switch (this.jjstateSet[i]) {
                  case 0:
                     if (this.curChar == '&' && kind > 39) {
                        kind = 39;
                     }
                     break;
                  case 1:
                     if ((287948901175001088L & l) != 0L) {
                        this.jjCheckNAddStates(3, 8);
                     } else if (this.curChar == '/') {
                        this.jjAddStates(9, 10);
                     } else if (this.curChar == '#') {
                        this.jjAddStates(11, 12);
                     } else if (this.curChar == '\'') {
                        this.jjCheckNAddStates(13, 15);
                     } else if (this.curChar == '"') {
                        this.jjCheckNAddStates(16, 18);
                     } else if (this.curChar == '$') {
                        if (kind > 76) {
                           kind = 76;
                        }

                        this.jjCheckNAdd(33);
                     } else if (this.curChar == '!') {
                        if (kind > 67) {
                           kind = 67;
                        }
                     } else if (this.curChar == '%') {
                        if (kind > 66) {
                           kind = 66;
                        }
                     } else if (this.curChar == '<') {
                        this.jjstateSet[this.jjnewStateCnt++] = 19;
                     } else if (this.curChar == '>') {
                        this.jjstateSet[this.jjnewStateCnt++] = 16;
                     } else if (this.curChar == '=') {
                        this.jjstateSet[this.jjnewStateCnt++] = 9;
                     } else if (this.curChar == '&') {
                        this.jjstateSet[this.jjnewStateCnt++] = 0;
                     }

                     if ((287667426198290432L & l) != 0L) {
                        if (kind > 80) {
                           kind = 80;
                        }

                        this.jjCheckNAddTwoStates(35, 36);
                     } else if (this.curChar == '0') {
                        if (kind > 80) {
                           kind = 80;
                        }

                        this.jjCheckNAddStates(19, 21);
                     } else if (this.curChar == '/') {
                        if (kind > 65) {
                           kind = 65;
                        }
                     } else if (this.curChar == '<') {
                        if (kind > 51) {
                           kind = 51;
                        }
                     } else if (this.curChar == '>') {
                        if (kind > 49) {
                           kind = 49;
                        }
                     } else if (this.curChar == '!') {
                        this.jjstateSet[this.jjnewStateCnt++] = 13;
                     }
                  case 2:
                  case 3:
                  case 4:
                  case 5:
                  case 6:
                  case 7:
                  case 8:
                  case 12:
                  case 22:
                  case 23:
                  case 24:
                  case 26:
                  case 27:
                  case 28:
                  case 30:
                  case 36:
                  case 39:
                  case 44:
                  case 47:
                  case 49:
                  case 51:
                  case 56:
                  case 59:
                  case 62:
                  case 67:
                  case 75:
                  case 76:
                  case 77:
                  case 90:
                  default:
                     break;
                  case 9:
                     if (this.curChar == '=' && kind > 41) {
                        kind = 41;
                     }
                     break;
                  case 10:
                     if (this.curChar == '=') {
                        this.jjstateSet[this.jjnewStateCnt++] = 9;
                     }
                     break;
                  case 11:
                     if ((287948969894477824L & l) != 0L) {
                        if (kind > 76) {
                           kind = 76;
                        }

                        this.jjCheckNAdd(33);
                     }
                     break;
                  case 13:
                     if (this.curChar == '=' && kind > 42) {
                        kind = 42;
                     }
                     break;
                  case 14:
                     if (this.curChar == '!') {
                        this.jjstateSet[this.jjnewStateCnt++] = 13;
                     }
                     break;
                  case 15:
                     if (this.curChar == '>' && kind > 49) {
                        kind = 49;
                     }
                     break;
                  case 16:
                     if (this.curChar == '=' && kind > 50) {
                        kind = 50;
                     }
                     break;
                  case 17:
                     if (this.curChar == '>') {
                        this.jjstateSet[this.jjnewStateCnt++] = 16;
                     }
                     break;
                  case 18:
                     if (this.curChar == '<' && kind > 51) {
                        kind = 51;
                     }
                     break;
                  case 19:
                     if (this.curChar == '=' && kind > 52) {
                        kind = 52;
                     }
                     break;
                  case 20:
                     if (this.curChar == '<') {
                        this.jjstateSet[this.jjnewStateCnt++] = 19;
                     }
                     break;
                  case 21:
                     if (this.curChar == '/' && kind > 65) {
                        kind = 65;
                     }
                     break;
                  case 25:
                     if (this.curChar == '%' && kind > 66) {
                        kind = 66;
                     }
                     break;
                  case 29:
                     if (this.curChar == '!' && kind > 67) {
                        kind = 67;
                     }
                     break;
                  case 31:
                     if ((287948969894477824L & l) != 0L) {
                        if (kind > 74) {
                           kind = 74;
                        }

                        this.jjstateSet[this.jjnewStateCnt++] = 31;
                     }
                     break;
                  case 32:
                     if (this.curChar == '$') {
                        if (kind > 76) {
                           kind = 76;
                        }

                        this.jjCheckNAdd(33);
                     }
                     break;
                  case 33:
                  case 91:
                     if ((287948969894477824L & l) != 0L) {
                        if (kind > 76) {
                           kind = 76;
                        }

                        this.jjCheckNAdd(33);
                     }
                     break;
                  case 34:
                     if ((287667426198290432L & l) != 0L) {
                        if (kind > 80) {
                           kind = 80;
                        }

                        this.jjCheckNAddTwoStates(35, 36);
                     }
                     break;
                  case 35:
                     if ((287948901175001088L & l) != 0L) {
                        if (kind > 80) {
                           kind = 80;
                        }

                        this.jjCheckNAddTwoStates(35, 36);
                     }
                     break;
                  case 37:
                     if (this.curChar == '"') {
                        this.jjCheckNAddStates(16, 18);
                     }
                     break;
                  case 38:
                     if ((-17179878401L & l) != 0L) {
                        this.jjCheckNAddStates(16, 18);
                     }
                     break;
                  case 40:
                     if ((-9217L & l) != 0L) {
                        this.jjCheckNAddStates(16, 18);
                     }
                     break;
                  case 41:
                     if (this.curChar == '"' && kind > 82) {
                        kind = 82;
                     }
                     break;
                  case 42:
                     if (this.curChar == '\'') {
                        this.jjCheckNAddStates(13, 15);
                     }
                     break;
                  case 43:
                     if ((-549755823105L & l) != 0L) {
                        this.jjCheckNAddStates(13, 15);
                     }
                     break;
                  case 45:
                     if ((-9217L & l) != 0L) {
                        this.jjCheckNAddStates(13, 15);
                     }
                     break;
                  case 46:
                     if (this.curChar == '\'' && kind > 82) {
                        kind = 82;
                     }
                     break;
                  case 48:
                     this.jjCheckNAddStates(25, 27);
                     break;
                  case 50:
                     if ((-2L & l) != 0L) {
                        this.jjCheckNAddStates(25, 27);
                     }
                     break;
                  case 52:
                     if ((287948901175001088L & l) != 0L) {
                        this.jjCheckNAddStates(3, 8);
                     }
                     break;
                  case 53:
                     if ((287948901175001088L & l) != 0L) {
                        this.jjCheckNAddTwoStates(53, 54);
                     }
                     break;
                  case 54:
                     if (this.curChar == '.') {
                        this.jjCheckNAdd(55);
                     }
                     break;
                  case 55:
                     if ((287948901175001088L & l) != 0L) {
                        if (kind > 81) {
                           kind = 81;
                        }

                        this.jjCheckNAddStates(28, 30);
                     }
                     break;
                  case 57:
                     if ((43980465111040L & l) != 0L) {
                        this.jjCheckNAdd(58);
                     }
                     break;
                  case 58:
                     if ((287948901175001088L & l) != 0L) {
                        if (kind > 81) {
                           kind = 81;
                        }

                        this.jjCheckNAddTwoStates(58, 59);
                     }
                     break;
                  case 60:
                     if ((287948901175001088L & l) != 0L) {
                        this.jjCheckNAddStates(31, 34);
                     }
                     break;
                  case 61:
                     if (this.curChar == '.') {
                        this.jjCheckNAddTwoStates(62, 59);
                     }
                     break;
                  case 63:
                     if ((43980465111040L & l) != 0L) {
                        this.jjCheckNAdd(64);
                     }
                     break;
                  case 64:
                     if ((287948901175001088L & l) != 0L) {
                        this.jjCheckNAddTwoStates(64, 59);
                     }
                     break;
                  case 65:
                     if (this.curChar == '0') {
                        if (kind > 80) {
                           kind = 80;
                        }

                        this.jjCheckNAddStates(19, 21);
                     }
                     break;
                  case 66:
                     if ((71776119061217280L & l) != 0L) {
                        if (kind > 80) {
                           kind = 80;
                        }

                        this.jjCheckNAddTwoStates(66, 36);
                     }
                     break;
                  case 68:
                     if ((287948901175001088L & l) != 0L) {
                        if (kind > 80) {
                           kind = 80;
                        }

                        this.jjCheckNAddTwoStates(68, 36);
                     }
                     break;
                  case 69:
                     if (this.curChar == '#') {
                        this.jjAddStates(11, 12);
                     }
                     break;
                  case 70:
                     if (this.curChar == '#') {
                        if (kind > 1) {
                           kind = 1;
                        }

                        this.jjCheckNAddStates(0, 2);
                     }
                     break;
                  case 71:
                     if ((-9217L & l) != 0L) {
                        if (kind > 1) {
                           kind = 1;
                        }

                        this.jjCheckNAddStates(0, 2);
                     }
                     break;
                  case 72:
                     if ((9216L & l) != 0L && kind > 1) {
                        kind = 1;
                     }
                     break;
                  case 73:
                     if (this.curChar == '\n' && kind > 1) {
                        kind = 1;
                     }
                     break;
                  case 74:
                     if (this.curChar == '\r') {
                        this.jjstateSet[this.jjnewStateCnt++] = 73;
                     }
                     break;
                  case 78:
                     if (this.curChar == '/') {
                        this.jjAddStates(9, 10);
                     }
                     break;
                  case 79:
                     if (this.curChar == '/') {
                        if (kind > 3) {
                           kind = 3;
                        }

                        this.jjCheckNAddStates(22, 24);
                     } else if (this.curChar == '*') {
                        this.jjCheckNAddTwoStates(80, 81);
                     }
                     break;
                  case 80:
                     if ((-4398046511105L & l) != 0L) {
                        this.jjCheckNAddTwoStates(80, 81);
                     }
                     break;
                  case 81:
                     if (this.curChar == '*') {
                        this.jjCheckNAddStates(35, 37);
                     }
                     break;
                  case 82:
                     if ((-145135534866433L & l) != 0L) {
                        this.jjCheckNAddTwoStates(83, 81);
                     }
                     break;
                  case 83:
                     if ((-4398046511105L & l) != 0L) {
                        this.jjCheckNAddTwoStates(83, 81);
                     }
                     break;
                  case 84:
                     if (this.curChar == '/' && kind > 2) {
                        kind = 2;
                     }
                     break;
                  case 85:
                     if (this.curChar == '/') {
                        if (kind > 3) {
                           kind = 3;
                        }

                        this.jjCheckNAddStates(22, 24);
                     }
                     break;
                  case 86:
                     if ((-9217L & l) != 0L) {
                        if (kind > 3) {
                           kind = 3;
                        }

                        this.jjCheckNAddStates(22, 24);
                     }
                     break;
                  case 87:
                     if ((9216L & l) != 0L && kind > 3) {
                        kind = 3;
                     }
                     break;
                  case 88:
                     if (this.curChar == '\n' && kind > 3) {
                        kind = 3;
                     }
                     break;
                  case 89:
                     if (this.curChar == '\r') {
                        this.jjstateSet[this.jjnewStateCnt++] = 88;
                     }
               }
            } while(i != startsAt);
         } else if (this.curChar < 128) {
            long l = 1L << (this.curChar & 63);

            do {
               --i;
               switch (this.jjstateSet[i]) {
                  case 1:
                     if ((576460745995190271L & l) != 0L) {
                        if (kind > 76) {
                           kind = 76;
                        }

                        this.jjCheckNAdd(33);
                     } else if (this.curChar == '`') {
                        this.jjCheckNAddStates(25, 27);
                     } else if (this.curChar == '|') {
                        this.jjstateSet[this.jjnewStateCnt++] = 5;
                     }

                     if (this.curChar == 'l') {
                        this.jjAddStates(38, 39);
                     } else if (this.curChar == 'g') {
                        this.jjAddStates(40, 41);
                     } else if (this.curChar == 'n') {
                        this.jjAddStates(42, 43);
                     } else if (this.curChar == '@') {
                        this.jjCheckNAdd(31);
                     } else if (this.curChar == 'm') {
                        this.jjstateSet[this.jjnewStateCnt++] = 27;
                     } else if (this.curChar == 'd') {
                        this.jjstateSet[this.jjnewStateCnt++] = 23;
                     } else if (this.curChar == 'e') {
                        this.jjstateSet[this.jjnewStateCnt++] = 11;
                     } else if (this.curChar == 'o') {
                        this.jjstateSet[this.jjnewStateCnt++] = 7;
                     } else if (this.curChar == 'a') {
                        this.jjstateSet[this.jjnewStateCnt++] = 3;
                     }
                     break;
                  case 2:
                     if (this.curChar == 'd' && kind > 39) {
                        kind = 39;
                     }
                     break;
                  case 3:
                     if (this.curChar == 'n') {
                        this.jjstateSet[this.jjnewStateCnt++] = 2;
                     }
                     break;
                  case 4:
                     if (this.curChar == 'a') {
                        this.jjstateSet[this.jjnewStateCnt++] = 3;
                     }
                     break;
                  case 5:
                     if (this.curChar == '|' && kind > 40) {
                        kind = 40;
                     }
                     break;
                  case 6:
                     if (this.curChar == '|') {
                        this.jjstateSet[this.jjnewStateCnt++] = 5;
                     }
                     break;
                  case 7:
                     if (this.curChar == 'r' && kind > 40) {
                        kind = 40;
                     }
                     break;
                  case 8:
                     if (this.curChar == 'o') {
                        this.jjstateSet[this.jjnewStateCnt++] = 7;
                     }
                  case 9:
                  case 10:
                  case 13:
                  case 14:
                  case 15:
                  case 16:
                  case 17:
                  case 18:
                  case 19:
                  case 20:
                  case 21:
                  case 25:
                  case 29:
                  case 34:
                  case 35:
                  case 37:
                  case 41:
                  case 42:
                  case 46:
                  case 52:
                  case 53:
                  case 54:
                  case 55:
                  case 57:
                  case 58:
                  case 60:
                  case 61:
                  case 63:
                  case 64:
                  case 65:
                  case 66:
                  case 69:
                  case 72:
                  case 73:
                  case 74:
                  case 77:
                  case 78:
                  case 79:
                  case 81:
                  case 84:
                  case 85:
                  case 87:
                  case 88:
                  case 89:
                  default:
                     break;
                  case 11:
                     if ((576460745995190271L & l) != 0L) {
                        if (kind > 76) {
                           kind = 76;
                        }

                        this.jjCheckNAdd(33);
                     }

                     if (this.curChar == 'q' && kind > 41) {
                        kind = 41;
                     }
                     break;
                  case 12:
                     if (this.curChar == 'e') {
                        this.jjstateSet[this.jjnewStateCnt++] = 11;
                     }
                     break;
                  case 22:
                     if (this.curChar == 'v' && kind > 65) {
                        kind = 65;
                     }
                     break;
                  case 23:
                     if (this.curChar == 'i') {
                        this.jjstateSet[this.jjnewStateCnt++] = 22;
                     }
                     break;
                  case 24:
                     if (this.curChar == 'd') {
                        this.jjstateSet[this.jjnewStateCnt++] = 23;
                     }
                     break;
                  case 26:
                     if (this.curChar == 'd' && kind > 66) {
                        kind = 66;
                     }
                     break;
                  case 27:
                     if (this.curChar == 'o') {
                        this.jjstateSet[this.jjnewStateCnt++] = 26;
                     }
                     break;
                  case 28:
                     if (this.curChar == 'm') {
                        this.jjstateSet[this.jjnewStateCnt++] = 27;
                     }
                     break;
                  case 30:
                     if (this.curChar == '@') {
                        this.jjCheckNAdd(31);
                     }
                     break;
                  case 31:
                     if ((576460745995190270L & l) != 0L) {
                        if (kind > 74) {
                           kind = 74;
                        }

                        this.jjCheckNAdd(31);
                     }
                     break;
                  case 32:
                     if ((576460745995190271L & l) != 0L) {
                        if (kind > 76) {
                           kind = 76;
                        }

                        this.jjCheckNAdd(33);
                     }
                     break;
                  case 33:
                     if ((576460745995190271L & l) != 0L) {
                        if (kind > 76) {
                           kind = 76;
                        }

                        this.jjCheckNAdd(33);
                     }
                     break;
                  case 36:
                     if ((18691697676544L & l) != 0L && kind > 80) {
                        kind = 80;
                     }
                     break;
                  case 38:
                     if ((-268435457L & l) != 0L) {
                        this.jjCheckNAddStates(16, 18);
                     }
                     break;
                  case 39:
                     if (this.curChar == '\\') {
                        this.jjstateSet[this.jjnewStateCnt++] = 40;
                     }
                     break;
                  case 40:
                     this.jjCheckNAddStates(16, 18);
                     break;
                  case 43:
                     if ((-268435457L & l) != 0L) {
                        this.jjCheckNAddStates(13, 15);
                     }
                     break;
                  case 44:
                     if (this.curChar == '\\') {
                        this.jjstateSet[this.jjnewStateCnt++] = 45;
                     }
                     break;
                  case 45:
                     this.jjCheckNAddStates(13, 15);
                     break;
                  case 47:
                     if (this.curChar == '`') {
                        this.jjCheckNAddStates(25, 27);
                     }
                     break;
                  case 48:
                     if ((-4563402753L & l) != 0L) {
                        this.jjCheckNAddStates(25, 27);
                     }
                     break;
                  case 49:
                     if (this.curChar == '\\') {
                        this.jjstateSet[this.jjnewStateCnt++] = 50;
                     }
                     break;
                  case 50:
                     this.jjCheckNAddStates(25, 27);
                     break;
                  case 51:
                     if (this.curChar == '`' && kind > 83) {
                        kind = 83;
                     }
                     break;
                  case 56:
                     if ((137438953504L & l) != 0L) {
                        this.jjAddStates(44, 45);
                     }
                     break;
                  case 59:
                     if ((360777252948L & l) != 0L && kind > 81) {
                        kind = 81;
                     }
                     break;
                  case 62:
                     if ((137438953504L & l) != 0L) {
                        this.jjAddStates(46, 47);
                     }
                     break;
                  case 67:
                     if ((72057594054705152L & l) != 0L) {
                        this.jjCheckNAdd(68);
                     }
                     break;
                  case 68:
                     if ((541165879422L & l) != 0L) {
                        if (kind > 80) {
                           kind = 80;
                        }

                        this.jjCheckNAddTwoStates(68, 36);
                     }
                     break;
                  case 70:
                     if (this.curChar == 'N') {
                        this.jjstateSet[this.jjnewStateCnt++] = 76;
                     }
                     break;
                  case 71:
                     if (kind > 1) {
                        kind = 1;
                     }

                     this.jjAddStates(0, 2);
                     break;
                  case 75:
                     if (this.curChar == 'N' && kind > 81) {
                        kind = 81;
                     }
                     break;
                  case 76:
                     if (this.curChar == 'a') {
                        this.jjstateSet[this.jjnewStateCnt++] = 75;
                     }
                     break;
                  case 80:
                     this.jjCheckNAddTwoStates(80, 81);
                     break;
                  case 82:
                  case 83:
                     this.jjCheckNAddTwoStates(83, 81);
                     break;
                  case 86:
                     if (kind > 3) {
                        kind = 3;
                     }

                     this.jjAddStates(22, 24);
                     break;
                  case 90:
                     if (this.curChar == 'n') {
                        this.jjAddStates(42, 43);
                     }
                     break;
                  case 91:
                     if ((576460745995190271L & l) != 0L) {
                        if (kind > 76) {
                           kind = 76;
                        }

                        this.jjCheckNAdd(33);
                     }

                     if (this.curChar == 'o') {
                        this.jjstateSet[this.jjnewStateCnt++] = 92;
                     } else if (this.curChar == 'e' && kind > 42) {
                        kind = 42;
                     }
                     break;
                  case 92:
                     if (this.curChar == 't' && kind > 67) {
                        kind = 67;
                     }
                     break;
                  case 93:
                     if (this.curChar == 'o') {
                        this.jjstateSet[this.jjnewStateCnt++] = 92;
                     }
                     break;
                  case 94:
                     if (this.curChar == 'g') {
                        this.jjAddStates(40, 41);
                     }
                     break;
                  case 95:
                     if (this.curChar == 't' && kind > 49) {
                        kind = 49;
                     }
                     break;
                  case 96:
                     if (this.curChar == 'e' && kind > 50) {
                        kind = 50;
                     }
                     break;
                  case 97:
                     if (this.curChar == 'l') {
                        this.jjAddStates(38, 39);
                     }
                     break;
                  case 98:
                     if (this.curChar == 't' && kind > 51) {
                        kind = 51;
                     }
                     break;
                  case 99:
                     if (this.curChar == 'e' && kind > 52) {
                        kind = 52;
                     }
               }
            } while(i != startsAt);
         } else {
            int hiByte = this.curChar >> 8;
            int i1 = hiByte >> 6;
            long l1 = 1L << (hiByte & 63);
            int i2 = (this.curChar & 255) >> 6;
            long l2 = 1L << (this.curChar & 63);

            do {
               --i;
               switch (this.jjstateSet[i]) {
                  case 38:
                  case 40:
                     if (jjCanMove_0(hiByte, i1, i2, l1, l2)) {
                        this.jjCheckNAddStates(16, 18);
                     }
                     break;
                  case 43:
                  case 45:
                     if (jjCanMove_0(hiByte, i1, i2, l1, l2)) {
                        this.jjCheckNAddStates(13, 15);
                     }
                     break;
                  case 48:
                  case 50:
                     if (jjCanMove_1(hiByte, i1, i2, l1, l2)) {
                        this.jjCheckNAddStates(25, 27);
                     }
                     break;
                  case 71:
                     if (jjCanMove_1(hiByte, i1, i2, l1, l2)) {
                        if (kind > 1) {
                           kind = 1;
                        }

                        this.jjAddStates(0, 2);
                     }
                     break;
                  case 80:
                     if (jjCanMove_1(hiByte, i1, i2, l1, l2)) {
                        this.jjCheckNAddTwoStates(80, 81);
                     }
                     break;
                  case 82:
                  case 83:
                     if (jjCanMove_1(hiByte, i1, i2, l1, l2)) {
                        this.jjCheckNAddTwoStates(83, 81);
                     }
                     break;
                  case 86:
                     if (jjCanMove_1(hiByte, i1, i2, l1, l2)) {
                        if (kind > 3) {
                           kind = 3;
                        }

                        this.jjAddStates(22, 24);
                     }
               }
            } while(i != startsAt);
         }

         if (kind != Integer.MAX_VALUE) {
            this.jjmatchedKind = kind;
            this.jjmatchedPos = curPos;
            kind = Integer.MAX_VALUE;
         }

         ++curPos;
         if ((i = this.jjnewStateCnt) == (startsAt = 100 - (this.jjnewStateCnt = startsAt))) {
            return curPos;
         }

         try {
            this.curChar = this.input_stream.readChar();
         } catch (IOException var13) {
            return curPos;
         }
      }
   }

   private final int jjStopStringLiteralDfa_1(int pos, long active0, long active1) {
      switch (pos) {
         case 0:
            if ((active0 & 33792L) != 0L) {
               this.jjmatchedKind = 75;
               return 17;
            } else {
               if ((active0 & 29186560L) == 0L && (active1 & 512L) == 0L) {
                  if ((active0 & 33554432L) != 0L) {
                     return 0;
                  }

                  if ((active0 & 2305957358422982656L) != 0L) {
                     return 15;
                  }

                  if ((active0 & 72057594037927936L) != 0L) {
                     this.jjmatchedKind = 65;
                     return 55;
                  }

                  if ((active0 & 144115188075855872L) != 0L) {
                     this.jjmatchedKind = 66;
                     return -1;
                  }

                  if ((active0 & 439804651110400L) != 0L) {
                     this.jjmatchedKind = 67;
                     return 19;
                  }

                  if ((active0 & 576460752303423488L) == 0L && (active1 & 32L) == 0L) {
                     if ((active0 & 288230376151711744L) == 0L && (active1 & 16L) == 0L) {
                        if ((active0 & 139264L) != 0L) {
                           this.jjmatchedKind = 75;
                           return 67;
                        }

                        return -1;
                     }

                     return 6;
                  }

                  return 11;
               }

               this.jjmatchedKind = 75;
               return 38;
            }
         case 1:
            if ((active0 & 512L) != 0L) {
               return 38;
            } else {
               if ((active0 & 29350912L) == 0L && (active1 & 512L) == 0L) {
                  if ((active0 & 8192L) != 0L) {
                     if (this.jjmatchedPos != 1) {
                        this.jjmatchedKind = 42;
                        this.jjmatchedPos = 1;
                     }

                     return 38;
                  }

                  if ((active0 & 144115188075855872L) != 0L) {
                     if (this.jjmatchedPos == 0) {
                        this.jjmatchedKind = 66;
                        this.jjmatchedPos = 0;
                     }

                     return -1;
                  }

                  return -1;
               }

               if (this.jjmatchedPos != 1) {
                  this.jjmatchedKind = 75;
                  this.jjmatchedPos = 1;
               }

               return 38;
            }
         case 2:
            if ((active0 & 26624L) == 0L && (active1 & 512L) == 0L) {
               if ((active0 & 29332480L) != 0L) {
                  this.jjmatchedKind = 75;
                  this.jjmatchedPos = 2;
                  return 38;
               }

               return -1;
            }

            return 38;
         case 3:
            if ((active0 & 28872704L) != 0L) {
               this.jjmatchedKind = 75;
               this.jjmatchedPos = 3;
               return 38;
            } else {
               if ((active0 & 459776L) != 0L) {
                  return 38;
               }

               return -1;
            }
         case 4:
            if ((active0 & 8949760L) != 0L) {
               return 38;
            } else {
               if ((active0 & 19922944L) != 0L) {
                  this.jjmatchedKind = 75;
                  this.jjmatchedPos = 4;
                  return 38;
               }

               return -1;
            }
         case 5:
            if ((active0 & 1048576L) != 0L) {
               return 38;
            } else {
               if ((active0 & 18874368L) != 0L) {
                  this.jjmatchedKind = 75;
                  this.jjmatchedPos = 5;
                  return 38;
               }

               return -1;
            }
         case 6:
            if ((active0 & 18874368L) != 0L) {
               this.jjmatchedKind = 75;
               this.jjmatchedPos = 6;
               return 38;
            }

            return -1;
         default:
            return -1;
      }
   }

   private final int jjStartNfa_1(int pos, long active0, long active1) {
      return this.jjMoveNfa_1(this.jjStopStringLiteralDfa_1(pos, active0, active1), pos + 1);
   }

   private int jjMoveStringLiteralDfa0_1() {
      switch (this.curChar) {
         case '!':
            return this.jjMoveStringLiteralDfa1_1(439804651110400L, 0L);
         case '"':
         case '$':
         case '\'':
         case '0':
         case '1':
         case '2':
         case '3':
         case '4':
         case '5':
         case '6':
         case '7':
         case '8':
         case '9':
         case '<':
         case '>':
         case '@':
         case 'A':
         case 'B':
         case 'C':
         case 'D':
         case 'E':
         case 'F':
         case 'G':
         case 'H':
         case 'I':
         case 'J':
         case 'K':
         case 'L':
         case 'M':
         case 'O':
         case 'P':
         case 'Q':
         case 'R':
         case 'S':
         case 'T':
         case 'U':
         case 'V':
         case 'W':
         case 'X':
         case 'Y':
         case 'Z':
         case '\\':
         case '_':
         case '`':
         case 'a':
         case 'd':
         case 'g':
         case 'h':
         case 'j':
         case 'k':
         case 'l':
         case 'm':
         case 'o':
         case 'p':
         case 'q':
         case 'u':
         case 'x':
         case 'y':
         case 'z':
         default:
            return this.jjMoveNfa_1(5, 0);
         case '#':
            return this.jjMoveStringLiteralDfa1_1(33554432L, 0L);
         case '%':
            return this.jjMoveStringLiteralDfa1_1(144115188075855872L, 0L);
         case '&':
            this.jjmatchedKind = 68;
            return this.jjMoveStringLiteralDfa1_1(288230376151711744L, 0L);
         case '(':
            return this.jjStopAtPos(0, 26);
         case ')':
            return this.jjStopAtPos(0, 27);
         case '*':
            this.jjmatchedKind = 64;
            return this.jjMoveStringLiteralDfa1_1(36028797018963968L, 0L);
         case '+':
            this.jjmatchedKind = 62;
            return this.jjMoveStringLiteralDfa1_1(9007199254740992L, 0L);
         case ',':
            return this.jjStopAtPos(0, 34);
         case '-':
            this.jjmatchedKind = 63;
            return this.jjMoveStringLiteralDfa1_1(18014398513676288L, 0L);
         case '.':
            this.jjmatchedKind = 35;
            return this.jjMoveStringLiteralDfa1_1(68719476736L, 256L);
         case '/':
            return this.jjMoveStringLiteralDfa1_1(72057594037927936L, 0L);
         case ':':
            return this.jjStopAtPos(0, 33);
         case ';':
            return this.jjStopAtPos(0, 32);
         case '=':
            this.jjmatchedKind = 61;
            return this.jjMoveStringLiteralDfa1_1(114349209288704L, 0L);
         case '?':
            this.jjmatchedKind = 37;
            return this.jjMoveStringLiteralDfa1_1(274877906944L, 0L);
         case 'N':
            return this.jjMoveStringLiteralDfa1_1(0L, 512L);
         case '[':
            return this.jjStopAtPos(0, 30);
         case ']':
            return this.jjStopAtPos(0, 31);
         case '^':
            this.jjmatchedKind = 70;
            return this.jjMoveStringLiteralDfa1_1(1152921504606846976L, 0L);
         case 'b':
            return this.jjMoveStringLiteralDfa1_1(8388608L, 0L);
         case 'c':
            return this.jjMoveStringLiteralDfa1_1(16777216L, 0L);
         case 'e':
            return this.jjMoveStringLiteralDfa1_1(33792L, 0L);
         case 'f':
            return this.jjMoveStringLiteralDfa1_1(2623488L, 0L);
         case 'i':
            return this.jjMoveStringLiteralDfa1_1(512L, 0L);
         case 'n':
            return this.jjMoveStringLiteralDfa1_1(139264L, 0L);
         case 'r':
            return this.jjMoveStringLiteralDfa1_1(1048576L, 0L);
         case 's':
            return this.jjMoveStringLiteralDfa1_1(65536L, 0L);
         case 't':
            return this.jjMoveStringLiteralDfa1_1(262144L, 0L);
         case 'v':
            return this.jjMoveStringLiteralDfa1_1(16384L, 0L);
         case 'w':
            return this.jjMoveStringLiteralDfa1_1(4096L, 0L);
         case '{':
            return this.jjStopAtPos(0, 28);
         case '|':
            this.jjmatchedKind = 69;
            return this.jjMoveStringLiteralDfa1_1(576460752303423488L, 0L);
         case '}':
            return this.jjStopAtPos(0, 29);
         case '~':
            return this.jjStopAtPos(0, 71);
      }
   }

   private int jjMoveStringLiteralDfa1_1(long active0, long active1) {
      try {
         this.curChar = this.input_stream.readChar();
      } catch (IOException var6) {
         this.jjStopStringLiteralDfa_1(0, active0, active1);
         return 1;
      }

      switch (this.curChar) {
         case '$':
            if ((active0 & 70368744177664L) != 0L) {
               return this.jjStopAtPos(1, 46);
            }

            if ((active0 & 281474976710656L) != 0L) {
               return this.jjStopAtPos(1, 48);
            }
            break;
         case '.':
            if ((active1 & 256L) != 0L) {
               this.jjmatchedKind = 72;
               this.jjmatchedPos = 1;
            }

            return this.jjMoveStringLiteralDfa2_1(active0, 68719476736L, active1, 0L);
         case ':':
            if ((active0 & 274877906944L) != 0L) {
               return this.jjStopAtPos(1, 38);
            }
            break;
         case '=':
            if ((active0 & 9007199254740992L) != 0L) {
               return this.jjStopAtPos(1, 53);
            }

            if ((active0 & 18014398509481984L) != 0L) {
               return this.jjStopAtPos(1, 54);
            }

            if ((active0 & 36028797018963968L) != 0L) {
               return this.jjStopAtPos(1, 55);
            }

            if ((active0 & 72057594037927936L) != 0L) {
               return this.jjStopAtPos(1, 56);
            }

            if ((active0 & 144115188075855872L) != 0L) {
               return this.jjStopAtPos(1, 57);
            }

            if ((active0 & 288230376151711744L) != 0L) {
               return this.jjStopAtPos(1, 58);
            }

            if ((active0 & 576460752303423488L) != 0L) {
               return this.jjStopAtPos(1, 59);
            }

            if ((active0 & 1152921504606846976L) != 0L) {
               return this.jjStopAtPos(1, 60);
            }
            break;
         case '>':
            if ((active0 & 4194304L) != 0L) {
               return this.jjStopAtPos(1, 22);
            }
            break;
         case '^':
            if ((active0 & 35184372088832L) != 0L) {
               return this.jjStopAtPos(1, 45);
            }

            if ((active0 & 140737488355328L) != 0L) {
               return this.jjStopAtPos(1, 47);
            }
            break;
         case 'a':
            return this.jjMoveStringLiteralDfa2_1(active0, 540672L, active1, 512L);
         case 'e':
            return this.jjMoveStringLiteralDfa2_1(active0, 1056768L, active1, 0L);
         case 'f':
            if ((active0 & 512L) != 0L) {
               return this.jjStartNfaWithStates_1(1, 9, 38);
            }
            break;
         case 'h':
            return this.jjMoveStringLiteralDfa2_1(active0, 4096L, active1, 0L);
         case 'i':
            return this.jjMoveStringLiteralDfa2_1(active0, 65536L, active1, 0L);
         case 'l':
            return this.jjMoveStringLiteralDfa2_1(active0, 1024L, active1, 0L);
         case 'm':
            return this.jjMoveStringLiteralDfa2_1(active0, 32768L, active1, 0L);
         case 'o':
            return this.jjMoveStringLiteralDfa2_1(active0, 16779264L, active1, 0L);
         case 'p':
            return this.jjMoveStringLiteralDfa2_1(active0, 33554432L, active1, 0L);
         case 'r':
            return this.jjMoveStringLiteralDfa2_1(active0, 8650752L, active1, 0L);
         case 'u':
            return this.jjMoveStringLiteralDfa2_1(active0, 2228224L, active1, 0L);
         case '~':
            if ((active0 & 8796093022208L) != 0L) {
               return this.jjStopAtPos(1, 43);
            }

            if ((active0 & 17592186044416L) != 0L) {
               return this.jjStopAtPos(1, 44);
            }
      }

      return this.jjStartNfa_1(0, active0, active1);
   }

   private int jjMoveStringLiteralDfa2_1(long old0, long active0, long old1, long active1) {
      if (((active0 = active0 & old0) | (active1 = active1 & old1)) == 0L) {
         return this.jjStartNfa_1(0, old0, old1);
      } else {
         try {
            this.curChar = this.input_stream.readChar();
         } catch (IOException var10) {
            this.jjStopStringLiteralDfa_1(1, active0, active1);
            return 2;
         }

         switch (this.curChar) {
            case '.':
               if ((active0 & 68719476736L) != 0L) {
                  return this.jjStopAtPos(2, 36);
               }
               break;
            case 'N':
               if ((active1 & 512L) != 0L) {
                  return this.jjStartNfaWithStates_1(2, 73, 38);
               }
               break;
            case 'e':
               return this.jjMoveStringLiteralDfa3_1(active0, 8388608L, active1, 0L);
            case 'i':
               return this.jjMoveStringLiteralDfa3_1(active0, 4096L, active1, 0L);
            case 'l':
               return this.jjMoveStringLiteralDfa3_1(active0, 655360L, active1, 0L);
            case 'n':
               return this.jjMoveStringLiteralDfa3_1(active0, 18874368L, active1, 0L);
            case 'p':
               return this.jjMoveStringLiteralDfa3_1(active0, 32768L, active1, 0L);
            case 'r':
               if ((active0 & 2048L) != 0L) {
                  return this.jjStartNfaWithStates_1(2, 11, 38);
               }

               if ((active0 & 16384L) != 0L) {
                  return this.jjStartNfaWithStates_1(2, 14, 38);
               }

               return this.jjMoveStringLiteralDfa3_1(active0, 33554432L, active1, 0L);
            case 's':
               return this.jjMoveStringLiteralDfa3_1(active0, 1024L, active1, 0L);
            case 't':
               return this.jjMoveStringLiteralDfa3_1(active0, 1048576L, active1, 0L);
            case 'u':
               return this.jjMoveStringLiteralDfa3_1(active0, 262144L, active1, 0L);
            case 'w':
               if ((active0 & 8192L) != 0L) {
                  return this.jjStartNfaWithStates_1(2, 13, 38);
               }
               break;
            case 'z':
               return this.jjMoveStringLiteralDfa3_1(active0, 65536L, active1, 0L);
         }

         return this.jjStartNfa_1(1, active0, active1);
      }
   }

   private int jjMoveStringLiteralDfa3_1(long old0, long active0, long old1, long active1) {
      if (((active0 = active0 & old0) | active1 & old1) == 0L) {
         return this.jjStartNfa_1(1, old0, old1);
      } else {
         try {
            this.curChar = this.input_stream.readChar();
         } catch (IOException var10) {
            this.jjStopStringLiteralDfa_1(2, active0, 0L);
            return 3;
         }

         switch (this.curChar) {
            case 'a':
               return this.jjMoveStringLiteralDfa4_1(active0, 41943040L);
            case 'c':
               return this.jjMoveStringLiteralDfa4_1(active0, 2097152L);
            case 'e':
               if ((active0 & 1024L) != 0L) {
                  return this.jjStartNfaWithStates_1(3, 10, 38);
               } else if ((active0 & 65536L) != 0L) {
                  return this.jjStartNfaWithStates_1(3, 16, 38);
               } else if ((active0 & 262144L) != 0L) {
                  return this.jjStartNfaWithStates_1(3, 18, 38);
               }
            case 'b':
            case 'd':
            case 'f':
            case 'g':
            case 'h':
            case 'i':
            case 'j':
            case 'k':
            case 'm':
            case 'n':
            case 'o':
            case 'p':
            case 'q':
            case 'r':
            default:
               return this.jjStartNfa_1(2, active0, 0L);
            case 'l':
               if ((active0 & 131072L) != 0L) {
                  return this.jjStartNfaWithStates_1(3, 17, 38);
               }

               return this.jjMoveStringLiteralDfa4_1(active0, 4096L);
            case 's':
               return this.jjMoveStringLiteralDfa4_1(active0, 524288L);
            case 't':
               return this.jjMoveStringLiteralDfa4_1(active0, 16809984L);
            case 'u':
               return this.jjMoveStringLiteralDfa4_1(active0, 1048576L);
         }
      }
   }

   private int jjMoveStringLiteralDfa4_1(long old0, long active0) {
      if ((active0 = active0 & old0) == 0L) {
         return this.jjStartNfa_1(2, old0, 0L);
      } else {
         try {
            this.curChar = this.input_stream.readChar();
         } catch (IOException var6) {
            this.jjStopStringLiteralDfa_1(3, active0, 0L);
            return 4;
         }

         switch (this.curChar) {
            case 'e':
               if ((active0 & 4096L) != 0L) {
                  return this.jjStartNfaWithStates_1(4, 12, 38);
               }

               if ((active0 & 524288L) != 0L) {
                  return this.jjStartNfaWithStates_1(4, 19, 38);
               }
            case 'f':
            case 'h':
            case 'j':
            case 'l':
            case 'm':
            case 'n':
            case 'o':
            case 'p':
            case 'q':
            case 's':
            case 'u':
            case 'v':
            case 'w':
            case 'x':
            default:
               break;
            case 'g':
               return this.jjMoveStringLiteralDfa5_1(active0, 33554432L);
            case 'i':
               return this.jjMoveStringLiteralDfa5_1(active0, 16777216L);
            case 'k':
               if ((active0 & 8388608L) != 0L) {
                  return this.jjStartNfaWithStates_1(4, 23, 38);
               }
               break;
            case 'r':
               return this.jjMoveStringLiteralDfa5_1(active0, 1048576L);
            case 't':
               return this.jjMoveStringLiteralDfa5_1(active0, 2097152L);
            case 'y':
               if ((active0 & 32768L) != 0L) {
                  return this.jjStartNfaWithStates_1(4, 15, 38);
               }
         }

         return this.jjStartNfa_1(3, active0, 0L);
      }
   }

   private int jjMoveStringLiteralDfa5_1(long old0, long active0) {
      if ((active0 = active0 & old0) == 0L) {
         return this.jjStartNfa_1(3, old0, 0L);
      } else {
         try {
            this.curChar = this.input_stream.readChar();
         } catch (IOException var6) {
            this.jjStopStringLiteralDfa_1(4, active0, 0L);
            return 5;
         }

         switch (this.curChar) {
            case 'i':
               return this.jjMoveStringLiteralDfa6_1(active0, 2097152L);
            case 'm':
               return this.jjMoveStringLiteralDfa6_1(active0, 33554432L);
            case 'n':
               if ((active0 & 1048576L) != 0L) {
                  return this.jjStartNfaWithStates_1(5, 20, 38);
               }

               return this.jjMoveStringLiteralDfa6_1(active0, 16777216L);
            default:
               return this.jjStartNfa_1(4, active0, 0L);
         }
      }
   }

   private int jjMoveStringLiteralDfa6_1(long old0, long active0) {
      if ((active0 = active0 & old0) == 0L) {
         return this.jjStartNfa_1(4, old0, 0L);
      } else {
         try {
            this.curChar = this.input_stream.readChar();
         } catch (IOException var6) {
            this.jjStopStringLiteralDfa_1(5, active0, 0L);
            return 6;
         }

         switch (this.curChar) {
            case 'a':
               if ((active0 & 33554432L) != 0L) {
                  return this.jjStopAtPos(6, 25);
               }
            default:
               return this.jjStartNfa_1(5, active0, 0L);
            case 'o':
               return this.jjMoveStringLiteralDfa7_1(active0, 2097152L);
            case 'u':
               return this.jjMoveStringLiteralDfa7_1(active0, 16777216L);
         }
      }
   }

   private int jjMoveStringLiteralDfa7_1(long old0, long active0) {
      if ((active0 = active0 & old0) == 0L) {
         return this.jjStartNfa_1(5, old0, 0L);
      } else {
         try {
            this.curChar = this.input_stream.readChar();
         } catch (IOException var6) {
            this.jjStopStringLiteralDfa_1(6, active0, 0L);
            return 7;
         }

         switch (this.curChar) {
            case 'e':
               if ((active0 & 16777216L) != 0L) {
                  return this.jjStartNfaWithStates_1(7, 24, 38);
               }
               break;
            case 'n':
               if ((active0 & 2097152L) != 0L) {
                  return this.jjStartNfaWithStates_1(7, 21, 38);
               }
         }

         return this.jjStartNfa_1(6, active0, 0L);
      }
   }

   private int jjStartNfaWithStates_1(int pos, int kind, int state) {
      this.jjmatchedKind = kind;
      this.jjmatchedPos = pos;

      try {
         this.curChar = this.input_stream.readChar();
      } catch (IOException var5) {
         return pos + 1;
      }

      return this.jjMoveNfa_1(state, pos + 1);
   }

   private int jjMoveNfa_1(int startState, int curPos) {
      int startsAt = 0;
      this.jjnewStateCnt = 76;
      int i = 1;
      this.jjstateSet[0] = startState;
      int kind = Integer.MAX_VALUE;

      while(true) {
         if (++this.jjround == Integer.MAX_VALUE) {
            this.ReInitRounds();
         }

         if (this.curChar < '@') {
            long l = 1L << this.curChar;

            do {
               --i;
               switch (this.jjstateSet[i]) {
                  case 0:
                     if (this.curChar == '#') {
                        if (kind > 1) {
                           kind = 1;
                        }

                        this.jjCheckNAddStates(59, 61);
                     }
                     break;
                  case 1:
                     if ((-9217L & l) != 0L) {
                        if (kind > 1) {
                           kind = 1;
                        }

                        this.jjCheckNAddStates(59, 61);
                     }
                     break;
                  case 2:
                     if ((9216L & l) != 0L && kind > 1) {
                        kind = 1;
                     }
                     break;
                  case 3:
                     if (this.curChar == '\n' && kind > 1) {
                        kind = 1;
                     }
                     break;
                  case 4:
                     if (this.curChar == '\r') {
                        this.jjstateSet[this.jjnewStateCnt++] = 3;
                     }
                     break;
                  case 5:
                     if ((287948969894477824L & l) != 0L) {
                        if (kind > 75) {
                           kind = 75;
                        }

                        this.jjCheckNAdd(38);
                     } else if (this.curChar == '/') {
                        this.jjAddStates(51, 52);
                     } else if (this.curChar == '\'') {
                        this.jjCheckNAddStates(53, 55);
                     } else if (this.curChar == '"') {
                        this.jjCheckNAddStates(56, 58);
                     } else if (this.curChar == '!') {
                        if (kind > 67) {
                           kind = 67;
                        }
                     } else if (this.curChar == '%') {
                        if (kind > 66) {
                           kind = 66;
                        }
                     } else if (this.curChar == '<') {
                        this.jjstateSet[this.jjnewStateCnt++] = 25;
                     } else if (this.curChar == '>') {
                        this.jjstateSet[this.jjnewStateCnt++] = 22;
                     } else if (this.curChar == '=') {
                        this.jjstateSet[this.jjnewStateCnt++] = 15;
                     } else if (this.curChar == '&') {
                        this.jjstateSet[this.jjnewStateCnt++] = 6;
                     } else if (this.curChar == '#') {
                        this.jjstateSet[this.jjnewStateCnt++] = 0;
                     }

                     if (this.curChar == '/') {
                        if (kind > 65) {
                           kind = 65;
                        }
                     } else if (this.curChar == '<') {
                        if (kind > 51) {
                           kind = 51;
                        }
                     } else if (this.curChar == '>') {
                        if (kind > 49) {
                           kind = 49;
                        }
                     } else if (this.curChar == '!') {
                        this.jjstateSet[this.jjnewStateCnt++] = 19;
                     }
                     break;
                  case 6:
                     if (this.curChar == '&' && kind > 39) {
                        kind = 39;
                     }
                     break;
                  case 7:
                     if (this.curChar == '&') {
                        this.jjstateSet[this.jjnewStateCnt++] = 6;
                     }
                  case 8:
                  case 9:
                  case 10:
                  case 11:
                  case 12:
                  case 13:
                  case 14:
                  case 18:
                  case 28:
                  case 29:
                  case 30:
                  case 32:
                  case 33:
                  case 34:
                  case 36:
                  case 41:
                  case 46:
                  case 49:
                  case 51:
                  case 53:
                  case 66:
                  default:
                     break;
                  case 15:
                     if (this.curChar == '=' && kind > 41) {
                        kind = 41;
                     }
                     break;
                  case 16:
                     if (this.curChar == '=') {
                        this.jjstateSet[this.jjnewStateCnt++] = 15;
                     }
                     break;
                  case 17:
                     if ((287948969894477824L & l) != 0L) {
                        if (kind > 75) {
                           kind = 75;
                        }

                        this.jjCheckNAdd(38);
                     }
                     break;
                  case 19:
                     if (this.curChar == '=' && kind > 42) {
                        kind = 42;
                     }
                     break;
                  case 20:
                     if (this.curChar == '!') {
                        this.jjstateSet[this.jjnewStateCnt++] = 19;
                     }
                     break;
                  case 21:
                     if (this.curChar == '>' && kind > 49) {
                        kind = 49;
                     }
                     break;
                  case 22:
                     if (this.curChar == '=' && kind > 50) {
                        kind = 50;
                     }
                     break;
                  case 23:
                     if (this.curChar == '>') {
                        this.jjstateSet[this.jjnewStateCnt++] = 22;
                     }
                     break;
                  case 24:
                     if (this.curChar == '<' && kind > 51) {
                        kind = 51;
                     }
                     break;
                  case 25:
                     if (this.curChar == '=' && kind > 52) {
                        kind = 52;
                     }
                     break;
                  case 26:
                     if (this.curChar == '<') {
                        this.jjstateSet[this.jjnewStateCnt++] = 25;
                     }
                     break;
                  case 27:
                     if (this.curChar == '/' && kind > 65) {
                        kind = 65;
                     }
                     break;
                  case 31:
                     if (this.curChar == '%' && kind > 66) {
                        kind = 66;
                     }
                     break;
                  case 35:
                     if (this.curChar == '!' && kind > 67) {
                        kind = 67;
                     }
                     break;
                  case 37:
                     if ((287948969894477824L & l) != 0L) {
                        if (kind > 74) {
                           kind = 74;
                        }

                        this.jjstateSet[this.jjnewStateCnt++] = 37;
                     }
                     break;
                  case 38:
                  case 67:
                     if ((287948969894477824L & l) != 0L) {
                        if (kind > 75) {
                           kind = 75;
                        }

                        this.jjCheckNAdd(38);
                     }
                     break;
                  case 39:
                     if (this.curChar == '"') {
                        this.jjCheckNAddStates(56, 58);
                     }
                     break;
                  case 40:
                     if ((-17179878401L & l) != 0L) {
                        this.jjCheckNAddStates(56, 58);
                     }
                     break;
                  case 42:
                     if ((-9217L & l) != 0L) {
                        this.jjCheckNAddStates(56, 58);
                     }
                     break;
                  case 43:
                     if (this.curChar == '"' && kind > 82) {
                        kind = 82;
                     }
                     break;
                  case 44:
                     if (this.curChar == '\'') {
                        this.jjCheckNAddStates(53, 55);
                     }
                     break;
                  case 45:
                     if ((-549755823105L & l) != 0L) {
                        this.jjCheckNAddStates(53, 55);
                     }
                     break;
                  case 47:
                     if ((-9217L & l) != 0L) {
                        this.jjCheckNAddStates(53, 55);
                     }
                     break;
                  case 48:
                     if (this.curChar == '\'' && kind > 82) {
                        kind = 82;
                     }
                     break;
                  case 50:
                     this.jjCheckNAddStates(62, 64);
                     break;
                  case 52:
                     if ((-2L & l) != 0L) {
                        this.jjCheckNAddStates(62, 64);
                     }
                     break;
                  case 54:
                     if (this.curChar == '/') {
                        this.jjAddStates(51, 52);
                     }
                     break;
                  case 55:
                     if (this.curChar == '/') {
                        if (kind > 3) {
                           kind = 3;
                        }

                        this.jjCheckNAddStates(48, 50);
                     } else if (this.curChar == '*') {
                        this.jjCheckNAddTwoStates(56, 57);
                     }
                     break;
                  case 56:
                     if ((-4398046511105L & l) != 0L) {
                        this.jjCheckNAddTwoStates(56, 57);
                     }
                     break;
                  case 57:
                     if (this.curChar == '*') {
                        this.jjCheckNAddStates(65, 67);
                     }
                     break;
                  case 58:
                     if ((-145135534866433L & l) != 0L) {
                        this.jjCheckNAddTwoStates(59, 57);
                     }
                     break;
                  case 59:
                     if ((-4398046511105L & l) != 0L) {
                        this.jjCheckNAddTwoStates(59, 57);
                     }
                     break;
                  case 60:
                     if (this.curChar == '/' && kind > 2) {
                        kind = 2;
                     }
                     break;
                  case 61:
                     if (this.curChar == '/') {
                        if (kind > 3) {
                           kind = 3;
                        }

                        this.jjCheckNAddStates(48, 50);
                     }
                     break;
                  case 62:
                     if ((-9217L & l) != 0L) {
                        if (kind > 3) {
                           kind = 3;
                        }

                        this.jjCheckNAddStates(48, 50);
                     }
                     break;
                  case 63:
                     if ((9216L & l) != 0L && kind > 3) {
                        kind = 3;
                     }
                     break;
                  case 64:
                     if (this.curChar == '\n' && kind > 3) {
                        kind = 3;
                     }
                     break;
                  case 65:
                     if (this.curChar == '\r') {
                        this.jjstateSet[this.jjnewStateCnt++] = 64;
                     }
               }
            } while(i != startsAt);
         } else if (this.curChar < 128) {
            long l = 1L << (this.curChar & 63);

            do {
               --i;
               switch (this.jjstateSet[i]) {
                  case 1:
                     if (kind > 1) {
                        kind = 1;
                     }

                     this.jjAddStates(59, 61);
                  case 2:
                  case 3:
                  case 4:
                  case 6:
                  case 7:
                  case 15:
                  case 16:
                  case 19:
                  case 20:
                  case 21:
                  case 22:
                  case 23:
                  case 24:
                  case 25:
                  case 26:
                  case 27:
                  case 31:
                  case 35:
                  case 39:
                  case 43:
                  case 44:
                  case 48:
                  case 54:
                  case 55:
                  case 57:
                  case 60:
                  case 61:
                  case 63:
                  case 64:
                  case 65:
                  default:
                     break;
                  case 5:
                     if ((576460745995190271L & l) != 0L) {
                        if (kind > 75) {
                           kind = 75;
                        }

                        this.jjCheckNAdd(38);
                     } else if (this.curChar == '`') {
                        this.jjCheckNAddStates(62, 64);
                     } else if (this.curChar == '|') {
                        this.jjstateSet[this.jjnewStateCnt++] = 11;
                     }

                     if (this.curChar == 'l') {
                        this.jjAddStates(68, 69);
                     } else if (this.curChar == 'g') {
                        this.jjAddStates(70, 71);
                     } else if (this.curChar == 'n') {
                        this.jjAddStates(72, 73);
                     } else if (this.curChar == '@') {
                        this.jjCheckNAdd(37);
                     } else if (this.curChar == 'm') {
                        this.jjstateSet[this.jjnewStateCnt++] = 33;
                     } else if (this.curChar == 'd') {
                        this.jjstateSet[this.jjnewStateCnt++] = 29;
                     } else if (this.curChar == 'e') {
                        this.jjstateSet[this.jjnewStateCnt++] = 17;
                     } else if (this.curChar == 'o') {
                        this.jjstateSet[this.jjnewStateCnt++] = 13;
                     } else if (this.curChar == 'a') {
                        this.jjstateSet[this.jjnewStateCnt++] = 9;
                     }
                     break;
                  case 8:
                     if (this.curChar == 'd' && kind > 39) {
                        kind = 39;
                     }
                     break;
                  case 9:
                     if (this.curChar == 'n') {
                        this.jjstateSet[this.jjnewStateCnt++] = 8;
                     }
                     break;
                  case 10:
                     if (this.curChar == 'a') {
                        this.jjstateSet[this.jjnewStateCnt++] = 9;
                     }
                     break;
                  case 11:
                     if (this.curChar == '|' && kind > 40) {
                        kind = 40;
                     }
                     break;
                  case 12:
                     if (this.curChar == '|') {
                        this.jjstateSet[this.jjnewStateCnt++] = 11;
                     }
                     break;
                  case 13:
                     if (this.curChar == 'r' && kind > 40) {
                        kind = 40;
                     }
                     break;
                  case 14:
                     if (this.curChar == 'o') {
                        this.jjstateSet[this.jjnewStateCnt++] = 13;
                     }
                     break;
                  case 17:
                     if ((576460745995190271L & l) != 0L) {
                        if (kind > 75) {
                           kind = 75;
                        }

                        this.jjCheckNAdd(38);
                     }

                     if (this.curChar == 'q' && kind > 41) {
                        kind = 41;
                     }
                     break;
                  case 18:
                     if (this.curChar == 'e') {
                        this.jjstateSet[this.jjnewStateCnt++] = 17;
                     }
                     break;
                  case 28:
                     if (this.curChar == 'v' && kind > 65) {
                        kind = 65;
                     }
                     break;
                  case 29:
                     if (this.curChar == 'i') {
                        this.jjstateSet[this.jjnewStateCnt++] = 28;
                     }
                     break;
                  case 30:
                     if (this.curChar == 'd') {
                        this.jjstateSet[this.jjnewStateCnt++] = 29;
                     }
                     break;
                  case 32:
                     if (this.curChar == 'd' && kind > 66) {
                        kind = 66;
                     }
                     break;
                  case 33:
                     if (this.curChar == 'o') {
                        this.jjstateSet[this.jjnewStateCnt++] = 32;
                     }
                     break;
                  case 34:
                     if (this.curChar == 'm') {
                        this.jjstateSet[this.jjnewStateCnt++] = 33;
                     }
                     break;
                  case 36:
                     if (this.curChar == '@') {
                        this.jjCheckNAdd(37);
                     }
                     break;
                  case 37:
                     if ((576460745995190270L & l) != 0L) {
                        if (kind > 74) {
                           kind = 74;
                        }

                        this.jjCheckNAdd(37);
                     }
                     break;
                  case 38:
                     if ((576460745995190271L & l) != 0L) {
                        if (kind > 75) {
                           kind = 75;
                        }

                        this.jjCheckNAdd(38);
                     }
                     break;
                  case 40:
                     if ((-268435457L & l) != 0L) {
                        this.jjCheckNAddStates(56, 58);
                     }
                     break;
                  case 41:
                     if (this.curChar == '\\') {
                        this.jjstateSet[this.jjnewStateCnt++] = 42;
                     }
                     break;
                  case 42:
                     this.jjCheckNAddStates(56, 58);
                     break;
                  case 45:
                     if ((-268435457L & l) != 0L) {
                        this.jjCheckNAddStates(53, 55);
                     }
                     break;
                  case 46:
                     if (this.curChar == '\\') {
                        this.jjstateSet[this.jjnewStateCnt++] = 47;
                     }
                     break;
                  case 47:
                     this.jjCheckNAddStates(53, 55);
                     break;
                  case 49:
                     if (this.curChar == '`') {
                        this.jjCheckNAddStates(62, 64);
                     }
                     break;
                  case 50:
                     if ((-4563402753L & l) != 0L) {
                        this.jjCheckNAddStates(62, 64);
                     }
                     break;
                  case 51:
                     if (this.curChar == '\\') {
                        this.jjstateSet[this.jjnewStateCnt++] = 52;
                     }
                     break;
                  case 52:
                     this.jjCheckNAddStates(62, 64);
                     break;
                  case 53:
                     if (this.curChar == '`' && kind > 83) {
                        kind = 83;
                     }
                     break;
                  case 56:
                     this.jjCheckNAddTwoStates(56, 57);
                     break;
                  case 58:
                  case 59:
                     this.jjCheckNAddTwoStates(59, 57);
                     break;
                  case 62:
                     if (kind > 3) {
                        kind = 3;
                     }

                     this.jjAddStates(48, 50);
                     break;
                  case 66:
                     if (this.curChar == 'n') {
                        this.jjAddStates(72, 73);
                     }
                     break;
                  case 67:
                     if ((576460745995190271L & l) != 0L) {
                        if (kind > 75) {
                           kind = 75;
                        }

                        this.jjCheckNAdd(38);
                     }

                     if (this.curChar == 'o') {
                        this.jjstateSet[this.jjnewStateCnt++] = 68;
                     } else if (this.curChar == 'e' && kind > 42) {
                        kind = 42;
                     }
                     break;
                  case 68:
                     if (this.curChar == 't' && kind > 67) {
                        kind = 67;
                     }
                     break;
                  case 69:
                     if (this.curChar == 'o') {
                        this.jjstateSet[this.jjnewStateCnt++] = 68;
                     }
                     break;
                  case 70:
                     if (this.curChar == 'g') {
                        this.jjAddStates(70, 71);
                     }
                     break;
                  case 71:
                     if (this.curChar == 't' && kind > 49) {
                        kind = 49;
                     }
                     break;
                  case 72:
                     if (this.curChar == 'e' && kind > 50) {
                        kind = 50;
                     }
                     break;
                  case 73:
                     if (this.curChar == 'l') {
                        this.jjAddStates(68, 69);
                     }
                     break;
                  case 74:
                     if (this.curChar == 't' && kind > 51) {
                        kind = 51;
                     }
                     break;
                  case 75:
                     if (this.curChar == 'e' && kind > 52) {
                        kind = 52;
                     }
               }
            } while(i != startsAt);
         } else {
            int hiByte = this.curChar >> 8;
            int i1 = hiByte >> 6;
            long l1 = 1L << (hiByte & 63);
            int i2 = (this.curChar & 255) >> 6;
            long l2 = 1L << (this.curChar & 63);

            do {
               --i;
               switch (this.jjstateSet[i]) {
                  case 1:
                     if (jjCanMove_1(hiByte, i1, i2, l1, l2)) {
                        if (kind > 1) {
                           kind = 1;
                        }

                        this.jjAddStates(59, 61);
                     }
                     break;
                  case 40:
                  case 42:
                     if (jjCanMove_0(hiByte, i1, i2, l1, l2)) {
                        this.jjCheckNAddStates(56, 58);
                     }
                     break;
                  case 45:
                  case 47:
                     if (jjCanMove_0(hiByte, i1, i2, l1, l2)) {
                        this.jjCheckNAddStates(53, 55);
                     }
                     break;
                  case 50:
                  case 52:
                     if (jjCanMove_1(hiByte, i1, i2, l1, l2)) {
                        this.jjCheckNAddStates(62, 64);
                     }
                     break;
                  case 56:
                     if (jjCanMove_1(hiByte, i1, i2, l1, l2)) {
                        this.jjCheckNAddTwoStates(56, 57);
                     }
                     break;
                  case 58:
                  case 59:
                     if (jjCanMove_1(hiByte, i1, i2, l1, l2)) {
                        this.jjCheckNAddTwoStates(59, 57);
                     }
                     break;
                  case 62:
                     if (jjCanMove_1(hiByte, i1, i2, l1, l2)) {
                        if (kind > 3) {
                           kind = 3;
                        }

                        this.jjAddStates(48, 50);
                     }
               }
            } while(i != startsAt);
         }

         if (kind != Integer.MAX_VALUE) {
            this.jjmatchedKind = kind;
            this.jjmatchedPos = curPos;
            kind = Integer.MAX_VALUE;
         }

         ++curPos;
         if ((i = this.jjnewStateCnt) == (startsAt = 76 - (this.jjnewStateCnt = startsAt))) {
            return curPos;
         }

         try {
            this.curChar = this.input_stream.readChar();
         } catch (IOException var13) {
            return curPos;
         }
      }
   }

   private final int jjStopStringLiteralDfa_0(int pos, long active0, long active1) {
      switch (pos) {
         case 0:
            if ((active0 & 33554432L) != 0L) {
               return 72;
            } else if ((active0 & 139264L) != 0L) {
               this.jjmatchedKind = 76;
               return 93;
            } else if ((active0 & 72057594037927936L) != 0L) {
               this.jjmatchedKind = 65;
               return 81;
            } else if ((active0 & 439804651110400L) != 0L) {
               this.jjmatchedKind = 67;
               return 13;
            } else {
               if ((active0 & 288230376151711744L) == 0L && (active1 & 16L) == 0L) {
                  if ((active0 & 2305957358422982656L) != 0L) {
                     return 9;
                  }

                  if ((active0 & 29186560L) == 0L && (active1 & 512L) == 0L) {
                     if ((active0 & 144115188075855872L) != 0L) {
                        this.jjmatchedKind = 66;
                        return -1;
                     }

                     if ((active0 & 33792L) != 0L) {
                        this.jjmatchedKind = 76;
                        return 11;
                     }

                     if ((active0 & 576460752303423488L) == 0L && (active1 & 32L) == 0L) {
                        return -1;
                     }

                     return 5;
                  }

                  this.jjmatchedKind = 76;
                  return 33;
               }

               return 0;
            }
         case 1:
            if ((active0 & 512L) != 0L) {
               return 33;
            } else if ((active0 & 144115188075855872L) != 0L) {
               if (this.jjmatchedPos == 0) {
                  this.jjmatchedKind = 66;
                  this.jjmatchedPos = 0;
               }

               return -1;
            } else {
               if ((active0 & 29350912L) == 0L && (active1 & 512L) == 0L) {
                  if ((active0 & 8192L) != 0L) {
                     if (this.jjmatchedPos != 1) {
                        this.jjmatchedKind = 42;
                        this.jjmatchedPos = 1;
                     }

                     return 33;
                  }

                  return -1;
               }

               if (this.jjmatchedPos != 1) {
                  this.jjmatchedKind = 76;
                  this.jjmatchedPos = 1;
               }

               return 33;
            }
         case 2:
            if ((active0 & 26624L) == 0L && (active1 & 512L) == 0L) {
               if ((active0 & 29332480L) != 0L) {
                  this.jjmatchedKind = 76;
                  this.jjmatchedPos = 2;
                  return 33;
               }

               return -1;
            }

            return 33;
         case 3:
            if ((active0 & 28872704L) != 0L) {
               this.jjmatchedKind = 76;
               this.jjmatchedPos = 3;
               return 33;
            } else {
               if ((active0 & 459776L) != 0L) {
                  return 33;
               }

               return -1;
            }
         case 4:
            if ((active0 & 8949760L) != 0L) {
               return 33;
            } else {
               if ((active0 & 19922944L) != 0L) {
                  this.jjmatchedKind = 76;
                  this.jjmatchedPos = 4;
                  return 33;
               }

               return -1;
            }
         case 5:
            if ((active0 & 1048576L) != 0L) {
               return 33;
            } else {
               if ((active0 & 18874368L) != 0L) {
                  this.jjmatchedKind = 76;
                  this.jjmatchedPos = 5;
                  return 33;
               }

               return -1;
            }
         case 6:
            if ((active0 & 18874368L) != 0L) {
               this.jjmatchedKind = 76;
               this.jjmatchedPos = 6;
               return 33;
            }

            return -1;
         default:
            return -1;
      }
   }

   private final int jjStartNfa_0(int pos, long active0, long active1) {
      return this.jjMoveNfa_0(this.jjStopStringLiteralDfa_0(pos, active0, active1), pos + 1);
   }

   private int jjMoveStringLiteralDfa0_0() {
      switch (this.curChar) {
         case '!':
            return this.jjMoveStringLiteralDfa1_0(439804651110400L, 0L);
         case '"':
         case '$':
         case '\'':
         case '0':
         case '1':
         case '2':
         case '3':
         case '4':
         case '5':
         case '6':
         case '7':
         case '8':
         case '9':
         case '<':
         case '>':
         case '@':
         case 'A':
         case 'B':
         case 'C':
         case 'D':
         case 'E':
         case 'F':
         case 'G':
         case 'H':
         case 'I':
         case 'J':
         case 'K':
         case 'L':
         case 'M':
         case 'O':
         case 'P':
         case 'Q':
         case 'R':
         case 'S':
         case 'T':
         case 'U':
         case 'V':
         case 'W':
         case 'X':
         case 'Y':
         case 'Z':
         case '\\':
         case '_':
         case '`':
         case 'a':
         case 'd':
         case 'g':
         case 'h':
         case 'j':
         case 'k':
         case 'l':
         case 'm':
         case 'o':
         case 'p':
         case 'q':
         case 'u':
         case 'x':
         case 'y':
         case 'z':
         default:
            return this.jjMoveNfa_0(1, 0);
         case '#':
            return this.jjMoveStringLiteralDfa1_0(33554432L, 0L);
         case '%':
            return this.jjMoveStringLiteralDfa1_0(144115188075855872L, 0L);
         case '&':
            this.jjmatchedKind = 68;
            return this.jjMoveStringLiteralDfa1_0(288230376151711744L, 0L);
         case '(':
            return this.jjStopAtPos(0, 26);
         case ')':
            return this.jjStopAtPos(0, 27);
         case '*':
            this.jjmatchedKind = 64;
            return this.jjMoveStringLiteralDfa1_0(36028797018963968L, 0L);
         case '+':
            this.jjmatchedKind = 62;
            return this.jjMoveStringLiteralDfa1_0(9007199254740992L, 0L);
         case ',':
            return this.jjStopAtPos(0, 34);
         case '-':
            this.jjmatchedKind = 63;
            return this.jjMoveStringLiteralDfa1_0(18014398513676288L, 0L);
         case '.':
            this.jjmatchedKind = 35;
            return this.jjMoveStringLiteralDfa1_0(68719476736L, 256L);
         case '/':
            return this.jjMoveStringLiteralDfa1_0(72057594037927936L, 0L);
         case ':':
            return this.jjStopAtPos(0, 33);
         case ';':
            return this.jjStopAtPos(0, 32);
         case '=':
            this.jjmatchedKind = 61;
            return this.jjMoveStringLiteralDfa1_0(114349209288704L, 0L);
         case '?':
            this.jjmatchedKind = 37;
            return this.jjMoveStringLiteralDfa1_0(274877906944L, 0L);
         case 'N':
            return this.jjMoveStringLiteralDfa1_0(0L, 512L);
         case '[':
            return this.jjStopAtPos(0, 30);
         case ']':
            return this.jjStopAtPos(0, 31);
         case '^':
            this.jjmatchedKind = 70;
            return this.jjMoveStringLiteralDfa1_0(1152921504606846976L, 0L);
         case 'b':
            return this.jjMoveStringLiteralDfa1_0(8388608L, 0L);
         case 'c':
            return this.jjMoveStringLiteralDfa1_0(16777216L, 0L);
         case 'e':
            return this.jjMoveStringLiteralDfa1_0(33792L, 0L);
         case 'f':
            return this.jjMoveStringLiteralDfa1_0(2623488L, 0L);
         case 'i':
            return this.jjMoveStringLiteralDfa1_0(512L, 0L);
         case 'n':
            return this.jjMoveStringLiteralDfa1_0(139264L, 0L);
         case 'r':
            return this.jjMoveStringLiteralDfa1_0(1048576L, 0L);
         case 's':
            return this.jjMoveStringLiteralDfa1_0(65536L, 0L);
         case 't':
            return this.jjMoveStringLiteralDfa1_0(262144L, 0L);
         case 'v':
            return this.jjMoveStringLiteralDfa1_0(16384L, 0L);
         case 'w':
            return this.jjMoveStringLiteralDfa1_0(4096L, 0L);
         case '{':
            return this.jjStopAtPos(0, 28);
         case '|':
            this.jjmatchedKind = 69;
            return this.jjMoveStringLiteralDfa1_0(576460752303423488L, 0L);
         case '}':
            return this.jjStopAtPos(0, 29);
         case '~':
            return this.jjStopAtPos(0, 71);
      }
   }

   private int jjMoveStringLiteralDfa1_0(long active0, long active1) {
      try {
         this.curChar = this.input_stream.readChar();
      } catch (IOException var6) {
         this.jjStopStringLiteralDfa_0(0, active0, active1);
         return 1;
      }

      switch (this.curChar) {
         case '$':
            if ((active0 & 70368744177664L) != 0L) {
               return this.jjStopAtPos(1, 46);
            }

            if ((active0 & 281474976710656L) != 0L) {
               return this.jjStopAtPos(1, 48);
            }
            break;
         case '.':
            if ((active1 & 256L) != 0L) {
               this.jjmatchedKind = 72;
               this.jjmatchedPos = 1;
            }

            return this.jjMoveStringLiteralDfa2_0(active0, 68719476736L, active1, 0L);
         case ':':
            if ((active0 & 274877906944L) != 0L) {
               return this.jjStopAtPos(1, 38);
            }
            break;
         case '=':
            if ((active0 & 9007199254740992L) != 0L) {
               return this.jjStopAtPos(1, 53);
            }

            if ((active0 & 18014398509481984L) != 0L) {
               return this.jjStopAtPos(1, 54);
            }

            if ((active0 & 36028797018963968L) != 0L) {
               return this.jjStopAtPos(1, 55);
            }

            if ((active0 & 72057594037927936L) != 0L) {
               return this.jjStopAtPos(1, 56);
            }

            if ((active0 & 144115188075855872L) != 0L) {
               return this.jjStopAtPos(1, 57);
            }

            if ((active0 & 288230376151711744L) != 0L) {
               return this.jjStopAtPos(1, 58);
            }

            if ((active0 & 576460752303423488L) != 0L) {
               return this.jjStopAtPos(1, 59);
            }

            if ((active0 & 1152921504606846976L) != 0L) {
               return this.jjStopAtPos(1, 60);
            }
            break;
         case '>':
            if ((active0 & 4194304L) != 0L) {
               return this.jjStopAtPos(1, 22);
            }
            break;
         case '^':
            if ((active0 & 35184372088832L) != 0L) {
               return this.jjStopAtPos(1, 45);
            }

            if ((active0 & 140737488355328L) != 0L) {
               return this.jjStopAtPos(1, 47);
            }
            break;
         case 'a':
            return this.jjMoveStringLiteralDfa2_0(active0, 540672L, active1, 512L);
         case 'e':
            return this.jjMoveStringLiteralDfa2_0(active0, 1056768L, active1, 0L);
         case 'f':
            if ((active0 & 512L) != 0L) {
               return this.jjStartNfaWithStates_0(1, 9, 33);
            }
            break;
         case 'h':
            return this.jjMoveStringLiteralDfa2_0(active0, 4096L, active1, 0L);
         case 'i':
            return this.jjMoveStringLiteralDfa2_0(active0, 65536L, active1, 0L);
         case 'l':
            return this.jjMoveStringLiteralDfa2_0(active0, 1024L, active1, 0L);
         case 'm':
            return this.jjMoveStringLiteralDfa2_0(active0, 32768L, active1, 0L);
         case 'o':
            return this.jjMoveStringLiteralDfa2_0(active0, 16779264L, active1, 0L);
         case 'p':
            return this.jjMoveStringLiteralDfa2_0(active0, 33554432L, active1, 0L);
         case 'r':
            return this.jjMoveStringLiteralDfa2_0(active0, 8650752L, active1, 0L);
         case 'u':
            return this.jjMoveStringLiteralDfa2_0(active0, 2228224L, active1, 0L);
         case '~':
            if ((active0 & 8796093022208L) != 0L) {
               return this.jjStopAtPos(1, 43);
            }

            if ((active0 & 17592186044416L) != 0L) {
               return this.jjStopAtPos(1, 44);
            }
      }

      return this.jjStartNfa_0(0, active0, active1);
   }

   private int jjMoveStringLiteralDfa2_0(long old0, long active0, long old1, long active1) {
      if (((active0 = active0 & old0) | (active1 = active1 & old1)) == 0L) {
         return this.jjStartNfa_0(0, old0, old1);
      } else {
         try {
            this.curChar = this.input_stream.readChar();
         } catch (IOException var10) {
            this.jjStopStringLiteralDfa_0(1, active0, active1);
            return 2;
         }

         switch (this.curChar) {
            case '.':
               if ((active0 & 68719476736L) != 0L) {
                  return this.jjStopAtPos(2, 36);
               }
               break;
            case 'N':
               if ((active1 & 512L) != 0L) {
                  return this.jjStartNfaWithStates_0(2, 73, 33);
               }
               break;
            case 'e':
               return this.jjMoveStringLiteralDfa3_0(active0, 8388608L, active1, 0L);
            case 'i':
               return this.jjMoveStringLiteralDfa3_0(active0, 4096L, active1, 0L);
            case 'l':
               return this.jjMoveStringLiteralDfa3_0(active0, 655360L, active1, 0L);
            case 'n':
               return this.jjMoveStringLiteralDfa3_0(active0, 18874368L, active1, 0L);
            case 'p':
               return this.jjMoveStringLiteralDfa3_0(active0, 32768L, active1, 0L);
            case 'r':
               if ((active0 & 2048L) != 0L) {
                  return this.jjStartNfaWithStates_0(2, 11, 33);
               }

               if ((active0 & 16384L) != 0L) {
                  return this.jjStartNfaWithStates_0(2, 14, 33);
               }

               return this.jjMoveStringLiteralDfa3_0(active0, 33554432L, active1, 0L);
            case 's':
               return this.jjMoveStringLiteralDfa3_0(active0, 1024L, active1, 0L);
            case 't':
               return this.jjMoveStringLiteralDfa3_0(active0, 1048576L, active1, 0L);
            case 'u':
               return this.jjMoveStringLiteralDfa3_0(active0, 262144L, active1, 0L);
            case 'w':
               if ((active0 & 8192L) != 0L) {
                  return this.jjStartNfaWithStates_0(2, 13, 33);
               }
               break;
            case 'z':
               return this.jjMoveStringLiteralDfa3_0(active0, 65536L, active1, 0L);
         }

         return this.jjStartNfa_0(1, active0, active1);
      }
   }

   private int jjMoveStringLiteralDfa3_0(long old0, long active0, long old1, long active1) {
      if (((active0 = active0 & old0) | active1 & old1) == 0L) {
         return this.jjStartNfa_0(1, old0, old1);
      } else {
         try {
            this.curChar = this.input_stream.readChar();
         } catch (IOException var10) {
            this.jjStopStringLiteralDfa_0(2, active0, 0L);
            return 3;
         }

         switch (this.curChar) {
            case 'a':
               return this.jjMoveStringLiteralDfa4_0(active0, 41943040L);
            case 'c':
               return this.jjMoveStringLiteralDfa4_0(active0, 2097152L);
            case 'e':
               if ((active0 & 1024L) != 0L) {
                  return this.jjStartNfaWithStates_0(3, 10, 33);
               } else if ((active0 & 65536L) != 0L) {
                  return this.jjStartNfaWithStates_0(3, 16, 33);
               } else if ((active0 & 262144L) != 0L) {
                  return this.jjStartNfaWithStates_0(3, 18, 33);
               }
            case 'b':
            case 'd':
            case 'f':
            case 'g':
            case 'h':
            case 'i':
            case 'j':
            case 'k':
            case 'm':
            case 'n':
            case 'o':
            case 'p':
            case 'q':
            case 'r':
            default:
               return this.jjStartNfa_0(2, active0, 0L);
            case 'l':
               if ((active0 & 131072L) != 0L) {
                  return this.jjStartNfaWithStates_0(3, 17, 33);
               }

               return this.jjMoveStringLiteralDfa4_0(active0, 4096L);
            case 's':
               return this.jjMoveStringLiteralDfa4_0(active0, 524288L);
            case 't':
               return this.jjMoveStringLiteralDfa4_0(active0, 16809984L);
            case 'u':
               return this.jjMoveStringLiteralDfa4_0(active0, 1048576L);
         }
      }
   }

   private int jjMoveStringLiteralDfa4_0(long old0, long active0) {
      if ((active0 = active0 & old0) == 0L) {
         return this.jjStartNfa_0(2, old0, 0L);
      } else {
         try {
            this.curChar = this.input_stream.readChar();
         } catch (IOException var6) {
            this.jjStopStringLiteralDfa_0(3, active0, 0L);
            return 4;
         }

         switch (this.curChar) {
            case 'e':
               if ((active0 & 4096L) != 0L) {
                  return this.jjStartNfaWithStates_0(4, 12, 33);
               }

               if ((active0 & 524288L) != 0L) {
                  return this.jjStartNfaWithStates_0(4, 19, 33);
               }
            case 'f':
            case 'h':
            case 'j':
            case 'l':
            case 'm':
            case 'n':
            case 'o':
            case 'p':
            case 'q':
            case 's':
            case 'u':
            case 'v':
            case 'w':
            case 'x':
            default:
               break;
            case 'g':
               return this.jjMoveStringLiteralDfa5_0(active0, 33554432L);
            case 'i':
               return this.jjMoveStringLiteralDfa5_0(active0, 16777216L);
            case 'k':
               if ((active0 & 8388608L) != 0L) {
                  return this.jjStartNfaWithStates_0(4, 23, 33);
               }
               break;
            case 'r':
               return this.jjMoveStringLiteralDfa5_0(active0, 1048576L);
            case 't':
               return this.jjMoveStringLiteralDfa5_0(active0, 2097152L);
            case 'y':
               if ((active0 & 32768L) != 0L) {
                  return this.jjStartNfaWithStates_0(4, 15, 33);
               }
         }

         return this.jjStartNfa_0(3, active0, 0L);
      }
   }

   private int jjMoveStringLiteralDfa5_0(long old0, long active0) {
      if ((active0 = active0 & old0) == 0L) {
         return this.jjStartNfa_0(3, old0, 0L);
      } else {
         try {
            this.curChar = this.input_stream.readChar();
         } catch (IOException var6) {
            this.jjStopStringLiteralDfa_0(4, active0, 0L);
            return 5;
         }

         switch (this.curChar) {
            case 'i':
               return this.jjMoveStringLiteralDfa6_0(active0, 2097152L);
            case 'm':
               return this.jjMoveStringLiteralDfa6_0(active0, 33554432L);
            case 'n':
               if ((active0 & 1048576L) != 0L) {
                  return this.jjStartNfaWithStates_0(5, 20, 33);
               }

               return this.jjMoveStringLiteralDfa6_0(active0, 16777216L);
            default:
               return this.jjStartNfa_0(4, active0, 0L);
         }
      }
   }

   private int jjMoveStringLiteralDfa6_0(long old0, long active0) {
      if ((active0 = active0 & old0) == 0L) {
         return this.jjStartNfa_0(4, old0, 0L);
      } else {
         try {
            this.curChar = this.input_stream.readChar();
         } catch (IOException var6) {
            this.jjStopStringLiteralDfa_0(5, active0, 0L);
            return 6;
         }

         switch (this.curChar) {
            case 'a':
               if ((active0 & 33554432L) != 0L) {
                  return this.jjStopAtPos(6, 25);
               }
            default:
               return this.jjStartNfa_0(5, active0, 0L);
            case 'o':
               return this.jjMoveStringLiteralDfa7_0(active0, 2097152L);
            case 'u':
               return this.jjMoveStringLiteralDfa7_0(active0, 16777216L);
         }
      }
   }

   private int jjMoveStringLiteralDfa7_0(long old0, long active0) {
      if ((active0 = active0 & old0) == 0L) {
         return this.jjStartNfa_0(5, old0, 0L);
      } else {
         try {
            this.curChar = this.input_stream.readChar();
         } catch (IOException var6) {
            this.jjStopStringLiteralDfa_0(6, active0, 0L);
            return 7;
         }

         switch (this.curChar) {
            case 'e':
               if ((active0 & 16777216L) != 0L) {
                  return this.jjStartNfaWithStates_0(7, 24, 33);
               }
               break;
            case 'n':
               if ((active0 & 2097152L) != 0L) {
                  return this.jjStartNfaWithStates_0(7, 21, 33);
               }
         }

         return this.jjStartNfa_0(6, active0, 0L);
      }
   }

   private int jjStartNfaWithStates_0(int pos, int kind, int state) {
      this.jjmatchedKind = kind;
      this.jjmatchedPos = pos;

      try {
         this.curChar = this.input_stream.readChar();
      } catch (IOException var5) {
         return pos + 1;
      }

      return this.jjMoveNfa_0(state, pos + 1);
   }

   private int jjMoveNfa_0(int startState, int curPos) {
      int startsAt = 0;
      this.jjnewStateCnt = 102;
      int i = 1;
      this.jjstateSet[0] = startState;
      int kind = Integer.MAX_VALUE;

      while(true) {
         if (++this.jjround == Integer.MAX_VALUE) {
            this.ReInitRounds();
         }

         if (this.curChar < '@') {
            long l = 1L << this.curChar;

            do {
               --i;
               switch (this.jjstateSet[i]) {
                  case 0:
                     if (this.curChar == '&' && kind > 39) {
                        kind = 39;
                     }
                     break;
                  case 1:
                     if ((287948901175001088L & l) != 0L) {
                        this.jjCheckNAddStates(80, 85);
                     } else if (this.curChar == '/') {
                        this.jjAddStates(86, 87);
                     } else if (this.curChar == '#') {
                        this.jjAddStates(88, 89);
                     } else if (this.curChar == '\'') {
                        this.jjCheckNAddStates(53, 55);
                     } else if (this.curChar == '"') {
                        this.jjCheckNAddStates(56, 58);
                     } else if (this.curChar == '$') {
                        if (kind > 76) {
                           kind = 76;
                        }

                        this.jjCheckNAdd(33);
                     } else if (this.curChar == '!') {
                        if (kind > 67) {
                           kind = 67;
                        }
                     } else if (this.curChar == '%') {
                        if (kind > 66) {
                           kind = 66;
                        }
                     } else if (this.curChar == '<') {
                        this.jjstateSet[this.jjnewStateCnt++] = 19;
                     } else if (this.curChar == '>') {
                        this.jjstateSet[this.jjnewStateCnt++] = 16;
                     } else if (this.curChar == '=') {
                        this.jjstateSet[this.jjnewStateCnt++] = 9;
                     } else if (this.curChar == '&') {
                        this.jjstateSet[this.jjnewStateCnt++] = 0;
                     }

                     if ((287667426198290432L & l) != 0L) {
                        if (kind > 80) {
                           kind = 80;
                        }

                        this.jjCheckNAddTwoStates(37, 38);
                     } else if (this.curChar == '0') {
                        if (kind > 80) {
                           kind = 80;
                        }

                        this.jjCheckNAddStates(90, 92);
                     } else if (this.curChar == '#') {
                        this.jjCheckNAdd(35);
                     } else if (this.curChar == '/') {
                        if (kind > 65) {
                           kind = 65;
                        }
                     } else if (this.curChar == '<') {
                        if (kind > 51) {
                           kind = 51;
                        }
                     } else if (this.curChar == '>') {
                        if (kind > 49) {
                           kind = 49;
                        }
                     } else if (this.curChar == '!') {
                        this.jjstateSet[this.jjnewStateCnt++] = 13;
                     }
                  case 2:
                  case 3:
                  case 4:
                  case 5:
                  case 6:
                  case 7:
                  case 8:
                  case 12:
                  case 22:
                  case 23:
                  case 24:
                  case 26:
                  case 27:
                  case 28:
                  case 30:
                  case 38:
                  case 41:
                  case 46:
                  case 49:
                  case 51:
                  case 53:
                  case 58:
                  case 61:
                  case 64:
                  case 69:
                  case 77:
                  case 78:
                  case 79:
                  case 92:
                  default:
                     break;
                  case 9:
                     if (this.curChar == '=' && kind > 41) {
                        kind = 41;
                     }
                     break;
                  case 10:
                     if (this.curChar == '=') {
                        this.jjstateSet[this.jjnewStateCnt++] = 9;
                     }
                     break;
                  case 11:
                     if ((287948969894477824L & l) != 0L) {
                        if (kind > 76) {
                           kind = 76;
                        }

                        this.jjCheckNAdd(33);
                     }
                     break;
                  case 13:
                     if (this.curChar == '=' && kind > 42) {
                        kind = 42;
                     }
                     break;
                  case 14:
                     if (this.curChar == '!') {
                        this.jjstateSet[this.jjnewStateCnt++] = 13;
                     }
                     break;
                  case 15:
                     if (this.curChar == '>' && kind > 49) {
                        kind = 49;
                     }
                     break;
                  case 16:
                     if (this.curChar == '=' && kind > 50) {
                        kind = 50;
                     }
                     break;
                  case 17:
                     if (this.curChar == '>') {
                        this.jjstateSet[this.jjnewStateCnt++] = 16;
                     }
                     break;
                  case 18:
                     if (this.curChar == '<' && kind > 51) {
                        kind = 51;
                     }
                     break;
                  case 19:
                     if (this.curChar == '=' && kind > 52) {
                        kind = 52;
                     }
                     break;
                  case 20:
                     if (this.curChar == '<') {
                        this.jjstateSet[this.jjnewStateCnt++] = 19;
                     }
                     break;
                  case 21:
                     if (this.curChar == '/' && kind > 65) {
                        kind = 65;
                     }
                     break;
                  case 25:
                     if (this.curChar == '%' && kind > 66) {
                        kind = 66;
                     }
                     break;
                  case 29:
                     if (this.curChar == '!' && kind > 67) {
                        kind = 67;
                     }
                     break;
                  case 31:
                     if ((287948969894477824L & l) != 0L) {
                        if (kind > 74) {
                           kind = 74;
                        }

                        this.jjstateSet[this.jjnewStateCnt++] = 31;
                     }
                     break;
                  case 32:
                     if (this.curChar == '$') {
                        if (kind > 76) {
                           kind = 76;
                        }

                        this.jjCheckNAdd(33);
                     }
                     break;
                  case 33:
                  case 93:
                     if ((287948969894477824L & l) != 0L) {
                        if (kind > 76) {
                           kind = 76;
                        }

                        this.jjCheckNAdd(33);
                     }
                     break;
                  case 34:
                     if (this.curChar == '#') {
                        this.jjCheckNAdd(35);
                     }
                     break;
                  case 35:
                     if ((287948901175001088L & l) != 0L) {
                        if (kind > 79) {
                           kind = 79;
                        }

                        this.jjCheckNAdd(35);
                     }
                     break;
                  case 36:
                     if ((287667426198290432L & l) != 0L) {
                        if (kind > 80) {
                           kind = 80;
                        }

                        this.jjCheckNAddTwoStates(37, 38);
                     }
                     break;
                  case 37:
                     if ((287948901175001088L & l) != 0L) {
                        if (kind > 80) {
                           kind = 80;
                        }

                        this.jjCheckNAddTwoStates(37, 38);
                     }
                     break;
                  case 39:
                     if (this.curChar == '"') {
                        this.jjCheckNAddStates(56, 58);
                     }
                     break;
                  case 40:
                     if ((-17179878401L & l) != 0L) {
                        this.jjCheckNAddStates(56, 58);
                     }
                     break;
                  case 42:
                     if ((-9217L & l) != 0L) {
                        this.jjCheckNAddStates(56, 58);
                     }
                     break;
                  case 43:
                     if (this.curChar == '"' && kind > 82) {
                        kind = 82;
                     }
                     break;
                  case 44:
                     if (this.curChar == '\'') {
                        this.jjCheckNAddStates(53, 55);
                     }
                     break;
                  case 45:
                     if ((-549755823105L & l) != 0L) {
                        this.jjCheckNAddStates(53, 55);
                     }
                     break;
                  case 47:
                     if ((-9217L & l) != 0L) {
                        this.jjCheckNAddStates(53, 55);
                     }
                     break;
                  case 48:
                     if (this.curChar == '\'' && kind > 82) {
                        kind = 82;
                     }
                     break;
                  case 50:
                     this.jjCheckNAddStates(62, 64);
                     break;
                  case 52:
                     if ((-2L & l) != 0L) {
                        this.jjCheckNAddStates(62, 64);
                     }
                     break;
                  case 54:
                     if ((287948901175001088L & l) != 0L) {
                        this.jjCheckNAddStates(80, 85);
                     }
                     break;
                  case 55:
                     if ((287948901175001088L & l) != 0L) {
                        this.jjCheckNAddTwoStates(55, 56);
                     }
                     break;
                  case 56:
                     if (this.curChar == '.') {
                        this.jjCheckNAdd(57);
                     }
                     break;
                  case 57:
                     if ((287948901175001088L & l) != 0L) {
                        if (kind > 81) {
                           kind = 81;
                        }

                        this.jjCheckNAddStates(93, 95);
                     }
                     break;
                  case 59:
                     if ((43980465111040L & l) != 0L) {
                        this.jjCheckNAdd(60);
                     }
                     break;
                  case 60:
                     if ((287948901175001088L & l) != 0L) {
                        if (kind > 81) {
                           kind = 81;
                        }

                        this.jjCheckNAddTwoStates(60, 61);
                     }
                     break;
                  case 62:
                     if ((287948901175001088L & l) != 0L) {
                        this.jjCheckNAddStates(96, 99);
                     }
                     break;
                  case 63:
                     if (this.curChar == '.') {
                        this.jjCheckNAddTwoStates(64, 61);
                     }
                     break;
                  case 65:
                     if ((43980465111040L & l) != 0L) {
                        this.jjCheckNAdd(66);
                     }
                     break;
                  case 66:
                     if ((287948901175001088L & l) != 0L) {
                        this.jjCheckNAddTwoStates(66, 61);
                     }
                     break;
                  case 67:
                     if (this.curChar == '0') {
                        if (kind > 80) {
                           kind = 80;
                        }

                        this.jjCheckNAddStates(90, 92);
                     }
                     break;
                  case 68:
                     if ((71776119061217280L & l) != 0L) {
                        if (kind > 80) {
                           kind = 80;
                        }

                        this.jjCheckNAddTwoStates(68, 38);
                     }
                     break;
                  case 70:
                     if ((287948901175001088L & l) != 0L) {
                        if (kind > 80) {
                           kind = 80;
                        }

                        this.jjCheckNAddTwoStates(70, 38);
                     }
                     break;
                  case 71:
                     if (this.curChar == '#') {
                        this.jjAddStates(88, 89);
                     }
                     break;
                  case 72:
                     if ((287948901175001088L & l) != 0L) {
                        if (kind > 79) {
                           kind = 79;
                        }

                        this.jjCheckNAdd(35);
                     } else if (this.curChar == '#') {
                        if (kind > 1) {
                           kind = 1;
                        }

                        this.jjCheckNAddStates(77, 79);
                     }
                     break;
                  case 73:
                     if ((-9217L & l) != 0L) {
                        if (kind > 1) {
                           kind = 1;
                        }

                        this.jjCheckNAddStates(77, 79);
                     }
                     break;
                  case 74:
                     if ((9216L & l) != 0L && kind > 1) {
                        kind = 1;
                     }
                     break;
                  case 75:
                     if (this.curChar == '\n' && kind > 1) {
                        kind = 1;
                     }
                     break;
                  case 76:
                     if (this.curChar == '\r') {
                        this.jjstateSet[this.jjnewStateCnt++] = 75;
                     }
                     break;
                  case 80:
                     if (this.curChar == '/') {
                        this.jjAddStates(86, 87);
                     }
                     break;
                  case 81:
                     if (this.curChar == '/') {
                        if (kind > 3) {
                           kind = 3;
                        }

                        this.jjCheckNAddStates(74, 76);
                     } else if (this.curChar == '*') {
                        this.jjCheckNAddTwoStates(82, 83);
                     }
                     break;
                  case 82:
                     if ((-4398046511105L & l) != 0L) {
                        this.jjCheckNAddTwoStates(82, 83);
                     }
                     break;
                  case 83:
                     if (this.curChar == '*') {
                        this.jjCheckNAddStates(100, 102);
                     }
                     break;
                  case 84:
                     if ((-145135534866433L & l) != 0L) {
                        this.jjCheckNAddTwoStates(85, 83);
                     }
                     break;
                  case 85:
                     if ((-4398046511105L & l) != 0L) {
                        this.jjCheckNAddTwoStates(85, 83);
                     }
                     break;
                  case 86:
                     if (this.curChar == '/' && kind > 2) {
                        kind = 2;
                     }
                     break;
                  case 87:
                     if (this.curChar == '/') {
                        if (kind > 3) {
                           kind = 3;
                        }

                        this.jjCheckNAddStates(74, 76);
                     }
                     break;
                  case 88:
                     if ((-9217L & l) != 0L) {
                        if (kind > 3) {
                           kind = 3;
                        }

                        this.jjCheckNAddStates(74, 76);
                     }
                     break;
                  case 89:
                     if ((9216L & l) != 0L && kind > 3) {
                        kind = 3;
                     }
                     break;
                  case 90:
                     if (this.curChar == '\n' && kind > 3) {
                        kind = 3;
                     }
                     break;
                  case 91:
                     if (this.curChar == '\r') {
                        this.jjstateSet[this.jjnewStateCnt++] = 90;
                     }
               }
            } while(i != startsAt);
         } else if (this.curChar < 128) {
            long l = 1L << (this.curChar & 63);

            do {
               --i;
               switch (this.jjstateSet[i]) {
                  case 1:
                     if ((576460745995190271L & l) != 0L) {
                        if (kind > 76) {
                           kind = 76;
                        }

                        this.jjCheckNAdd(33);
                     } else if (this.curChar == '`') {
                        this.jjCheckNAddStates(62, 64);
                     } else if (this.curChar == '|') {
                        this.jjstateSet[this.jjnewStateCnt++] = 5;
                     }

                     if (this.curChar == 'l') {
                        this.jjAddStates(103, 104);
                     } else if (this.curChar == 'g') {
                        this.jjAddStates(105, 106);
                     } else if (this.curChar == 'n') {
                        this.jjAddStates(107, 108);
                     } else if (this.curChar == '@') {
                        this.jjCheckNAdd(31);
                     } else if (this.curChar == 'm') {
                        this.jjstateSet[this.jjnewStateCnt++] = 27;
                     } else if (this.curChar == 'd') {
                        this.jjstateSet[this.jjnewStateCnt++] = 23;
                     } else if (this.curChar == 'e') {
                        this.jjstateSet[this.jjnewStateCnt++] = 11;
                     } else if (this.curChar == 'o') {
                        this.jjstateSet[this.jjnewStateCnt++] = 7;
                     } else if (this.curChar == 'a') {
                        this.jjstateSet[this.jjnewStateCnt++] = 3;
                     }
                     break;
                  case 2:
                     if (this.curChar == 'd' && kind > 39) {
                        kind = 39;
                     }
                     break;
                  case 3:
                     if (this.curChar == 'n') {
                        this.jjstateSet[this.jjnewStateCnt++] = 2;
                     }
                     break;
                  case 4:
                     if (this.curChar == 'a') {
                        this.jjstateSet[this.jjnewStateCnt++] = 3;
                     }
                     break;
                  case 5:
                     if (this.curChar == '|' && kind > 40) {
                        kind = 40;
                     }
                     break;
                  case 6:
                     if (this.curChar == '|') {
                        this.jjstateSet[this.jjnewStateCnt++] = 5;
                     }
                     break;
                  case 7:
                     if (this.curChar == 'r' && kind > 40) {
                        kind = 40;
                     }
                     break;
                  case 8:
                     if (this.curChar == 'o') {
                        this.jjstateSet[this.jjnewStateCnt++] = 7;
                     }
                  case 9:
                  case 10:
                  case 13:
                  case 14:
                  case 15:
                  case 16:
                  case 17:
                  case 18:
                  case 19:
                  case 20:
                  case 21:
                  case 25:
                  case 29:
                  case 34:
                  case 35:
                  case 36:
                  case 37:
                  case 39:
                  case 43:
                  case 44:
                  case 48:
                  case 54:
                  case 55:
                  case 56:
                  case 57:
                  case 59:
                  case 60:
                  case 62:
                  case 63:
                  case 65:
                  case 66:
                  case 67:
                  case 68:
                  case 71:
                  case 74:
                  case 75:
                  case 76:
                  case 79:
                  case 80:
                  case 81:
                  case 83:
                  case 86:
                  case 87:
                  case 89:
                  case 90:
                  case 91:
                  default:
                     break;
                  case 11:
                     if ((576460745995190271L & l) != 0L) {
                        if (kind > 76) {
                           kind = 76;
                        }

                        this.jjCheckNAdd(33);
                     }

                     if (this.curChar == 'q' && kind > 41) {
                        kind = 41;
                     }
                     break;
                  case 12:
                     if (this.curChar == 'e') {
                        this.jjstateSet[this.jjnewStateCnt++] = 11;
                     }
                     break;
                  case 22:
                     if (this.curChar == 'v' && kind > 65) {
                        kind = 65;
                     }
                     break;
                  case 23:
                     if (this.curChar == 'i') {
                        this.jjstateSet[this.jjnewStateCnt++] = 22;
                     }
                     break;
                  case 24:
                     if (this.curChar == 'd') {
                        this.jjstateSet[this.jjnewStateCnt++] = 23;
                     }
                     break;
                  case 26:
                     if (this.curChar == 'd' && kind > 66) {
                        kind = 66;
                     }
                     break;
                  case 27:
                     if (this.curChar == 'o') {
                        this.jjstateSet[this.jjnewStateCnt++] = 26;
                     }
                     break;
                  case 28:
                     if (this.curChar == 'm') {
                        this.jjstateSet[this.jjnewStateCnt++] = 27;
                     }
                     break;
                  case 30:
                     if (this.curChar == '@') {
                        this.jjCheckNAdd(31);
                     }
                     break;
                  case 31:
                     if ((576460745995190270L & l) != 0L) {
                        if (kind > 74) {
                           kind = 74;
                        }

                        this.jjCheckNAdd(31);
                     }
                     break;
                  case 32:
                     if ((576460745995190271L & l) != 0L) {
                        if (kind > 76) {
                           kind = 76;
                        }

                        this.jjCheckNAdd(33);
                     }
                     break;
                  case 33:
                     if ((576460745995190271L & l) != 0L) {
                        if (kind > 76) {
                           kind = 76;
                        }

                        this.jjCheckNAdd(33);
                     }
                     break;
                  case 38:
                     if ((18691697676544L & l) != 0L && kind > 80) {
                        kind = 80;
                     }
                     break;
                  case 40:
                     if ((-268435457L & l) != 0L) {
                        this.jjCheckNAddStates(56, 58);
                     }
                     break;
                  case 41:
                     if (this.curChar == '\\') {
                        this.jjstateSet[this.jjnewStateCnt++] = 42;
                     }
                     break;
                  case 42:
                     this.jjCheckNAddStates(56, 58);
                     break;
                  case 45:
                     if ((-268435457L & l) != 0L) {
                        this.jjCheckNAddStates(53, 55);
                     }
                     break;
                  case 46:
                     if (this.curChar == '\\') {
                        this.jjstateSet[this.jjnewStateCnt++] = 47;
                     }
                     break;
                  case 47:
                     this.jjCheckNAddStates(53, 55);
                     break;
                  case 49:
                     if (this.curChar == '`') {
                        this.jjCheckNAddStates(62, 64);
                     }
                     break;
                  case 50:
                     if ((-4563402753L & l) != 0L) {
                        this.jjCheckNAddStates(62, 64);
                     }
                     break;
                  case 51:
                     if (this.curChar == '\\') {
                        this.jjstateSet[this.jjnewStateCnt++] = 52;
                     }
                     break;
                  case 52:
                     this.jjCheckNAddStates(62, 64);
                     break;
                  case 53:
                     if (this.curChar == '`' && kind > 83) {
                        kind = 83;
                     }
                     break;
                  case 58:
                     if ((137438953504L & l) != 0L) {
                        this.jjAddStates(109, 110);
                     }
                     break;
                  case 61:
                     if ((360777252948L & l) != 0L && kind > 81) {
                        kind = 81;
                     }
                     break;
                  case 64:
                     if ((137438953504L & l) != 0L) {
                        this.jjAddStates(111, 112);
                     }
                     break;
                  case 69:
                     if ((72057594054705152L & l) != 0L) {
                        this.jjCheckNAdd(70);
                     }
                     break;
                  case 70:
                     if ((541165879422L & l) != 0L) {
                        if (kind > 80) {
                           kind = 80;
                        }

                        this.jjCheckNAddTwoStates(70, 38);
                     }
                     break;
                  case 72:
                     if (this.curChar == 'N') {
                        this.jjstateSet[this.jjnewStateCnt++] = 78;
                     }
                     break;
                  case 73:
                     if (kind > 1) {
                        kind = 1;
                     }

                     this.jjAddStates(77, 79);
                     break;
                  case 77:
                     if (this.curChar == 'N' && kind > 81) {
                        kind = 81;
                     }
                     break;
                  case 78:
                     if (this.curChar == 'a') {
                        this.jjstateSet[this.jjnewStateCnt++] = 77;
                     }
                     break;
                  case 82:
                     this.jjCheckNAddTwoStates(82, 83);
                     break;
                  case 84:
                  case 85:
                     this.jjCheckNAddTwoStates(85, 83);
                     break;
                  case 88:
                     if (kind > 3) {
                        kind = 3;
                     }

                     this.jjAddStates(74, 76);
                     break;
                  case 92:
                     if (this.curChar == 'n') {
                        this.jjAddStates(107, 108);
                     }
                     break;
                  case 93:
                     if ((576460745995190271L & l) != 0L) {
                        if (kind > 76) {
                           kind = 76;
                        }

                        this.jjCheckNAdd(33);
                     }

                     if (this.curChar == 'o') {
                        this.jjstateSet[this.jjnewStateCnt++] = 94;
                     } else if (this.curChar == 'e' && kind > 42) {
                        kind = 42;
                     }
                     break;
                  case 94:
                     if (this.curChar == 't' && kind > 67) {
                        kind = 67;
                     }
                     break;
                  case 95:
                     if (this.curChar == 'o') {
                        this.jjstateSet[this.jjnewStateCnt++] = 94;
                     }
                     break;
                  case 96:
                     if (this.curChar == 'g') {
                        this.jjAddStates(105, 106);
                     }
                     break;
                  case 97:
                     if (this.curChar == 't' && kind > 49) {
                        kind = 49;
                     }
                     break;
                  case 98:
                     if (this.curChar == 'e' && kind > 50) {
                        kind = 50;
                     }
                     break;
                  case 99:
                     if (this.curChar == 'l') {
                        this.jjAddStates(103, 104);
                     }
                     break;
                  case 100:
                     if (this.curChar == 't' && kind > 51) {
                        kind = 51;
                     }
                     break;
                  case 101:
                     if (this.curChar == 'e' && kind > 52) {
                        kind = 52;
                     }
               }
            } while(i != startsAt);
         } else {
            int hiByte = this.curChar >> 8;
            int i1 = hiByte >> 6;
            long l1 = 1L << (hiByte & 63);
            int i2 = (this.curChar & 255) >> 6;
            long l2 = 1L << (this.curChar & 63);

            do {
               --i;
               switch (this.jjstateSet[i]) {
                  case 40:
                  case 42:
                     if (jjCanMove_0(hiByte, i1, i2, l1, l2)) {
                        this.jjCheckNAddStates(56, 58);
                     }
                     break;
                  case 45:
                  case 47:
                     if (jjCanMove_0(hiByte, i1, i2, l1, l2)) {
                        this.jjCheckNAddStates(53, 55);
                     }
                     break;
                  case 50:
                  case 52:
                     if (jjCanMove_1(hiByte, i1, i2, l1, l2)) {
                        this.jjCheckNAddStates(62, 64);
                     }
                     break;
                  case 73:
                     if (jjCanMove_1(hiByte, i1, i2, l1, l2)) {
                        if (kind > 1) {
                           kind = 1;
                        }

                        this.jjAddStates(77, 79);
                     }
                     break;
                  case 82:
                     if (jjCanMove_1(hiByte, i1, i2, l1, l2)) {
                        this.jjCheckNAddTwoStates(82, 83);
                     }
                     break;
                  case 84:
                  case 85:
                     if (jjCanMove_1(hiByte, i1, i2, l1, l2)) {
                        this.jjCheckNAddTwoStates(85, 83);
                     }
                     break;
                  case 88:
                     if (jjCanMove_1(hiByte, i1, i2, l1, l2)) {
                        if (kind > 3) {
                           kind = 3;
                        }

                        this.jjAddStates(74, 76);
                     }
               }
            } while(i != startsAt);
         }

         if (kind != Integer.MAX_VALUE) {
            this.jjmatchedKind = kind;
            this.jjmatchedPos = curPos;
            kind = Integer.MAX_VALUE;
         }

         ++curPos;
         if ((i = this.jjnewStateCnt) == (startsAt = 102 - (this.jjnewStateCnt = startsAt))) {
            return curPos;
         }

         try {
            this.curChar = this.input_stream.readChar();
         } catch (IOException var13) {
            return curPos;
         }
      }
   }

   private static final boolean jjCanMove_0(int hiByte, int i1, int i2, long l1, long l2) {
      switch (hiByte) {
         case 0:
            return (jjbitVec2[i2] & l2) != 0L;
         case 32:
            return (jjbitVec3[i2] & l2) != 0L;
         default:
            return (jjbitVec0[i1] & l1) != 0L;
      }
   }

   private static final boolean jjCanMove_1(int hiByte, int i1, int i2, long l1, long l2) {
      switch (hiByte) {
         case 0:
            return (jjbitVec2[i2] & l2) != 0L;
         default:
            return (jjbitVec4[i1] & l1) != 0L;
      }
   }

   public ParserTokenManager(SimpleCharStream stream) {
      this.dotLexState = 2;
      this.debugStream = System.out;
      this.jjrounds = new int[102];
      this.jjstateSet = new int[204];
      this.jjimage = new StringBuilder();
      this.image = this.jjimage;
      this.curLexState = 2;
      this.defaultLexState = 2;
      this.input_stream = stream;
   }

   public ParserTokenManager(SimpleCharStream stream, int lexState) {
      this(stream);
      this.SwitchTo(lexState);
   }

   public void ReInit(SimpleCharStream stream) {
      this.jjmatchedPos = this.jjnewStateCnt = 0;
      this.curLexState = this.defaultLexState;
      this.input_stream = stream;
      this.ReInitRounds();
   }

   private void ReInitRounds() {
      this.jjround = -2147483647;

      for(int i = 102; i-- > 0; this.jjrounds[i] = Integer.MIN_VALUE) {
      }

   }

   public void ReInit(SimpleCharStream stream, int lexState) {
      this.ReInit(stream);
      this.SwitchTo(lexState);
   }

   public void SwitchTo(int lexState) {
      if (lexState < 3 && lexState >= 0) {
         this.curLexState = lexState;
      } else {
         throw new TokenMgrError("Error: Ignoring invalid lexical state : " + lexState + ". State unchanged.", 2);
      }
   }

   protected Token jjFillToken() {
      String im = jjstrLiteralImages[this.jjmatchedKind];
      String curTokenImage = im == null ? this.input_stream.GetImage() : im;
      int beginLine = this.input_stream.getBeginLine();
      int beginColumn = this.input_stream.getBeginColumn();
      int endLine = this.input_stream.getEndLine();
      int endColumn = this.input_stream.getEndColumn();
      Token t = Token.newToken(this.jjmatchedKind, curTokenImage);
      t.beginLine = beginLine;
      t.endLine = endLine;
      t.beginColumn = beginColumn;
      t.endColumn = endColumn;
      return t;
   }

   public Token getNextToken() {
      int curPos = 0;

      while(true) {
         try {
            this.curChar = this.input_stream.BeginToken();
         } catch (IOException var8) {
            this.jjmatchedKind = 0;
            Token matchedToken = this.jjFillToken();
            return matchedToken;
         }

         this.image = this.jjimage;
         this.image.setLength(0);
         this.jjimageLen = 0;
         switch (this.curLexState) {
            case 0:
               try {
                  this.input_stream.backup(0);

                  while(this.curChar <= ' ' && (4294981120L & 1L << this.curChar) != 0L) {
                     this.curChar = this.input_stream.BeginToken();
                  }
               } catch (IOException var12) {
                  continue;
               }

               this.jjmatchedKind = Integer.MAX_VALUE;
               this.jjmatchedPos = 0;
               curPos = this.jjMoveStringLiteralDfa0_0();
               break;
            case 1:
               try {
                  this.input_stream.backup(0);

                  while(this.curChar <= ' ' && (4294981120L & 1L << this.curChar) != 0L) {
                     this.curChar = this.input_stream.BeginToken();
                  }
               } catch (IOException var11) {
                  continue;
               }

               this.jjmatchedKind = Integer.MAX_VALUE;
               this.jjmatchedPos = 0;
               curPos = this.jjMoveStringLiteralDfa0_1();
               break;
            case 2:
               try {
                  this.input_stream.backup(0);

                  while(this.curChar <= ' ' && (4294981120L & 1L << this.curChar) != 0L) {
                     this.curChar = this.input_stream.BeginToken();
                  }
               } catch (IOException var10) {
                  continue;
               }

               this.jjmatchedKind = Integer.MAX_VALUE;
               this.jjmatchedPos = 0;
               curPos = this.jjMoveStringLiteralDfa0_2();
         }

         if (this.jjmatchedKind == Integer.MAX_VALUE) {
            int error_line = this.input_stream.getEndLine();
            int error_column = this.input_stream.getEndColumn();
            String error_after = null;
            boolean EOFSeen = false;

            try {
               this.input_stream.readChar();
               this.input_stream.backup(1);
            } catch (IOException var9) {
               EOFSeen = true;
               error_after = curPos <= 1 ? "" : this.input_stream.GetImage();
               if (this.curChar != '\n' && this.curChar != '\r') {
                  ++error_column;
               } else {
                  ++error_line;
                  error_column = 0;
               }
            }

            if (!EOFSeen) {
               this.input_stream.backup(1);
               error_after = curPos <= 1 ? "" : this.input_stream.GetImage();
            }

            throw new TokenMgrError(EOFSeen, this.curLexState, error_line, error_column, error_after, this.curChar, 0);
         }

         if (this.jjmatchedPos + 1 < curPos) {
            this.input_stream.backup(curPos - this.jjmatchedPos - 1);
         }

         if ((jjtoToken[this.jjmatchedKind >> 6] & 1L << (this.jjmatchedKind & 63)) != 0L) {
            Token matchedToken = this.jjFillToken();
            this.TokenLexicalActions(matchedToken);
            if (jjnewLexState[this.jjmatchedKind] != -1) {
               this.curLexState = jjnewLexState[this.jjmatchedKind];
            }

            return matchedToken;
         }

         if (jjnewLexState[this.jjmatchedKind] != -1) {
            this.curLexState = jjnewLexState[this.jjmatchedKind];
         }
      }
   }

   void TokenLexicalActions(Token matchedToken) {
      switch (this.jjmatchedKind) {
         case 15:
            this.image.append(jjstrLiteralImages[15]);
            this.lengthOfMatch = jjstrLiteralImages[15].length();
            this.popDot();
            break;
         case 16:
            this.image.append(jjstrLiteralImages[16]);
            this.lengthOfMatch = jjstrLiteralImages[16].length();
            this.popDot();
            break;
         case 35:
            this.image.append(jjstrLiteralImages[35]);
            this.lengthOfMatch = jjstrLiteralImages[35].length();
            this.pushDot();
            break;
         case 75:
            this.image.append(this.input_stream.GetSuffix(this.jjimageLen + (this.lengthOfMatch = this.jjmatchedPos + 1)));
            this.popDot();
            break;
         case 82:
            this.image.append(this.input_stream.GetSuffix(this.jjimageLen + (this.lengthOfMatch = this.jjmatchedPos + 1)));
            this.popDot();
      }

   }

   private void jjCheckNAdd(int state) {
      if (this.jjrounds[state] != this.jjround) {
         this.jjstateSet[this.jjnewStateCnt++] = state;
         this.jjrounds[state] = this.jjround;
      }

   }

   private void jjAddStates(int start, int end) {
      do {
         this.jjstateSet[this.jjnewStateCnt++] = jjnextStates[start];
      } while(start++ != end);

   }

   private void jjCheckNAddTwoStates(int state1, int state2) {
      this.jjCheckNAdd(state1);
      this.jjCheckNAdd(state2);
   }

   private void jjCheckNAddStates(int start, int end) {
      do {
         this.jjCheckNAdd(jjnextStates[start]);
      } while(start++ != end);

   }
}
