package org.apache.commons.jexl3.parser;

public abstract class ParserVisitor {
   protected final Object visit(SimpleNode node, Object data) {
      throw new UnsupportedOperationException(node.getClass().getSimpleName() + " : not supported yet.");
   }

   protected final Object visit(ASTAmbiguous node, Object data) {
      throw new UnsupportedOperationException("unexpected type of node");
   }

   protected abstract Object visit(ASTJexlScript var1, Object var2);

   protected abstract Object visit(ASTBlock var1, Object var2);

   protected abstract Object visit(ASTIfStatement var1, Object var2);

   protected abstract Object visit(ASTWhileStatement var1, Object var2);

   protected abstract Object visit(ASTContinue var1, Object var2);

   protected abstract Object visit(ASTBreak var1, Object var2);

   protected abstract Object visit(ASTForeachStatement var1, Object var2);

   protected abstract Object visit(ASTReturnStatement var1, Object var2);

   protected abstract Object visit(ASTAssignment var1, Object var2);

   protected abstract Object visit(ASTVar var1, Object var2);

   protected abstract Object visit(ASTReference var1, Object var2);

   protected abstract Object visit(ASTTernaryNode var1, Object var2);

   protected abstract Object visit(ASTOrNode var1, Object var2);

   protected abstract Object visit(ASTAndNode var1, Object var2);

   protected abstract Object visit(ASTBitwiseOrNode var1, Object var2);

   protected abstract Object visit(ASTBitwiseXorNode var1, Object var2);

   protected abstract Object visit(ASTBitwiseAndNode var1, Object var2);

   protected abstract Object visit(ASTEQNode var1, Object var2);

   protected abstract Object visit(ASTNENode var1, Object var2);

   protected abstract Object visit(ASTLTNode var1, Object var2);

   protected abstract Object visit(ASTGTNode var1, Object var2);

   protected abstract Object visit(ASTLENode var1, Object var2);

   protected abstract Object visit(ASTGENode var1, Object var2);

   protected abstract Object visit(ASTERNode var1, Object var2);

   protected abstract Object visit(ASTNRNode var1, Object var2);

   protected abstract Object visit(ASTSWNode var1, Object var2);

   protected abstract Object visit(ASTNSWNode var1, Object var2);

   protected abstract Object visit(ASTEWNode var1, Object var2);

   protected abstract Object visit(ASTNEWNode var1, Object var2);

   protected abstract Object visit(ASTAddNode var1, Object var2);

   protected abstract Object visit(ASTSubNode var1, Object var2);

   protected abstract Object visit(ASTMulNode var1, Object var2);

   protected abstract Object visit(ASTDivNode var1, Object var2);

   protected abstract Object visit(ASTModNode var1, Object var2);

   protected abstract Object visit(ASTUnaryMinusNode var1, Object var2);

   protected abstract Object visit(ASTBitwiseComplNode var1, Object var2);

   protected abstract Object visit(ASTNotNode var1, Object var2);

   protected abstract Object visit(ASTIdentifier var1, Object var2);

   protected abstract Object visit(ASTNullLiteral var1, Object var2);

   protected abstract Object visit(ASTTrueNode var1, Object var2);

   protected abstract Object visit(ASTFalseNode var1, Object var2);

   protected abstract Object visit(ASTNumberLiteral var1, Object var2);

   protected abstract Object visit(ASTStringLiteral var1, Object var2);

   protected abstract Object visit(ASTSetLiteral var1, Object var2);

   protected abstract Object visit(ASTExtendedLiteral var1, Object var2);

   protected abstract Object visit(ASTArrayLiteral var1, Object var2);

   protected abstract Object visit(ASTRangeNode var1, Object var2);

   protected abstract Object visit(ASTMapLiteral var1, Object var2);

   protected abstract Object visit(ASTMapEntry var1, Object var2);

   protected abstract Object visit(ASTEmptyFunction var1, Object var2);

   protected abstract Object visit(ASTEmptyMethod var1, Object var2);

   protected abstract Object visit(ASTSizeFunction var1, Object var2);

   protected abstract Object visit(ASTFunctionNode var1, Object var2);

   protected abstract Object visit(ASTMethodNode var1, Object var2);

   protected abstract Object visit(ASTSizeMethod var1, Object var2);

   protected abstract Object visit(ASTConstructorNode var1, Object var2);

   protected abstract Object visit(ASTArrayAccess var1, Object var2);

   protected abstract Object visit(ASTIdentifierAccess var1, Object var2);

   protected abstract Object visit(ASTArguments var1, Object var2);

   protected abstract Object visit(ASTReferenceExpression var1, Object var2);

   protected abstract Object visit(ASTSetAddNode var1, Object var2);

   protected abstract Object visit(ASTSetSubNode var1, Object var2);

   protected abstract Object visit(ASTSetMultNode var1, Object var2);

   protected abstract Object visit(ASTSetDivNode var1, Object var2);

   protected abstract Object visit(ASTSetModNode var1, Object var2);

   protected abstract Object visit(ASTSetAndNode var1, Object var2);

   protected abstract Object visit(ASTSetOrNode var1, Object var2);

   protected abstract Object visit(ASTSetXorNode var1, Object var2);

   protected abstract Object visit(ASTJxltLiteral var1, Object var2);

   protected abstract Object visit(ASTAnnotation var1, Object var2);

   protected abstract Object visit(ASTAnnotatedStatement var1, Object var2);
}
