package org.apache.commons.jexl3.parser;

public class TokenMgrError extends Error implements JavaccError {
   private static final long serialVersionUID = 1L;
   public static final int LEXICAL_ERROR = 0;
   public static final int STATIC_LEXER_ERROR = 1;
   public static final int INVALID_LEXICAL_STATE = 2;
   public static final int LOOP_DETECTED = 3;
   private int errorCode;
   private int state;
   private char current;
   private String after;
   private boolean eof;
   private int line;
   private int column;

   public String getMessage() {
      return "Lexical error at line " + this.line + ", column " + this.column + ".  Encountered: " + (this.eof ? "<EOF> " : StringParser.escapeString(String.valueOf(this.current), '"') + " (" + this.current + "), ") + "after : " + StringParser.escapeString(this.after, '"');
   }

   public TokenMgrError(String message, int reason) {
      super(message);
      this.errorCode = reason;
   }

   public TokenMgrError(boolean EOFSeen, int lexState, int errorLine, int errorColumn, String errorAfter, char curChar, int reason) {
      this.eof = EOFSeen;
      this.state = lexState;
      this.line = errorLine;
      this.column = errorColumn;
      this.after = errorAfter;
      this.current = curChar;
      this.errorCode = reason;
   }

   public int getErrorCode() {
      return this.errorCode;
   }

   public int getLine() {
      return this.line;
   }

   public int getColumn() {
      return this.column;
   }

   public String getAfter() {
      return this.after;
   }

   protected static final String addEscapes(String str) {
      StringBuffer retval = new StringBuffer();

      for(int i = 0; i < str.length(); ++i) {
         switch (str.charAt(i)) {
            case '\u0000':
               break;
            case '\b':
               retval.append("//b");
               break;
            case '\t':
               retval.append("//t");
               break;
            case '\n':
               retval.append("//n");
               break;
            case '\f':
               retval.append("//f");
               break;
            case '\r':
               retval.append("//r");
               break;
            case '"':
               retval.append("//\"");
               break;
            case '\'':
               retval.append("//'");
               break;
            case '/':
               retval.append("////");
               break;
            default:
               char ch;
               if ((ch = str.charAt(i)) >= ' ' && ch <= '~') {
                  retval.append(ch);
               } else {
                  String s = "0000" + Integer.toString(ch, 16);
                  retval.append("//u" + s.substring(s.length() - 4, s.length()));
               }
         }
      }

      return retval.toString();
   }
}
