package org.apache.commons.jexl3.scripting;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.apache.commons.jexl3.parser.StringParser;

public class JexlScriptEngineFactory implements ScriptEngineFactory {
   public String getEngineName() {
      return "JEXL Engine";
   }

   public String getEngineVersion() {
      return "3.0";
   }

   public String getLanguageName() {
      return "JEXL";
   }

   public String getLanguageVersion() {
      return "3.0";
   }

   public String getMethodCallSyntax(String obj, String m, String... args) {
      StringBuilder sb = new StringBuilder();
      sb.append(obj);
      sb.append('.');
      sb.append(m);
      sb.append('(');
      boolean needComma = false;

      for(String arg : args) {
         if (needComma) {
            sb.append(',');
         }

         sb.append(arg);
         needComma = true;
      }

      sb.append(')');
      return sb.toString();
   }

   public List<String> getExtensions() {
      return Collections.unmodifiableList(Arrays.asList("jexl", "jexl2", "jexl3"));
   }

   public List<String> getMimeTypes() {
      return Collections.unmodifiableList(Arrays.asList("application/x-jexl", "application/x-jexl2", "application/x-jexl3"));
   }

   public List<String> getNames() {
      return Collections.unmodifiableList(Arrays.asList("JEXL", "Jexl", "jexl", "JEXL2", "Jexl2", "jexl2", "JEXL3", "Jexl3", "jexl3"));
   }

   public String getOutputStatement(String toDisplay) {
      return toDisplay == null ? "JEXL.out.print(null)" : "JEXL.out.print(" + StringParser.escapeString(toDisplay, '\'') + ")";
   }

   public Object getParameter(String key) {
      if (key.equals("javax.script.engine")) {
         return this.getEngineName();
      } else if (key.equals("javax.script.engine_version")) {
         return this.getEngineVersion();
      } else if (key.equals("javax.script.name")) {
         return this.getNames();
      } else if (key.equals("javax.script.language")) {
         return this.getLanguageName();
      } else if (key.equals("javax.script.language_version")) {
         return this.getLanguageVersion();
      } else {
         return key.equals("THREADING") ? null : null;
      }
   }

   public String getProgram(String... statements) {
      StringBuilder sb = new StringBuilder();

      for(String statement : statements) {
         sb.append(statement.trim());
         if (!statement.endsWith(";")) {
            sb.append(';');
         }
      }

      return sb.toString();
   }

   public ScriptEngine getScriptEngine() {
      return new JexlScriptEngine(this);
   }
}
