package org.apache.commons.jexl3.scripting;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

public class Main {
   static BufferedReader read(Charset charset, String fileName) throws Exception {
      return new BufferedReader(new InputStreamReader((InputStream)(fileName == null ? System.in : new FileInputStream(new File(fileName))), charset == null ? Charset.defaultCharset() : charset));
   }

   public static void main(String[] args) throws Exception {
      JexlScriptEngineFactory fac = new JexlScriptEngineFactory();
      ScriptEngine engine = fac.getScriptEngine();
      engine.put("args", args);
      if (args.length == 1) {
         Object value = engine.eval(read((Charset)null, args[0]));
         System.out.println("Return value: " + value);
      } else {
         BufferedReader console = read((Charset)null, null);
         System.out.print("> ");

         String line;
         for(; null != (line = console.readLine()); System.out.print("> ")) {
            try {
               Object value = engine.eval(line);
               System.out.println("Return value: " + value);
            } catch (ScriptException e) {
               System.out.println(e.getLocalizedMessage());
            }
         }
      }

   }
}
