package org.apache.commons.logging;

import java.io.PrintStream;
import java.util.Hashtable;

public class LogFactory {
   public static final String PRIORITY_KEY = "priority";
   public static final String TCCL_KEY = "use_tccl";
   public static final String FACTORY_PROPERTY = "org.apache.commons.logging.LogFactory";
   public static final String FACTORY_DEFAULT = "org.apache.commons.logging.impl.LogFactoryImpl";
   public static final String FACTORY_PROPERTIES = "commons-logging.properties";
   protected static final String SERVICE_ID = "META-INF/services/org.apache.commons.logging.LogFactory";
   public static final String DIAGNOSTICS_DEST_PROPERTY = "org.apache.commons.logging.diagnostics.dest";
   private static PrintStream diagnosticsStream = null;
   public static final String HASHTABLE_IMPLEMENTATION_PROPERTY = "org.apache.commons.logging.LogFactory.HashtableImpl";
   private static final String WEAK_HASHTABLE_CLASSNAME = "org.apache.commons.logging.impl.WeakHashtable";
   protected static Hashtable factories = null;
   /** @deprecated */
   protected static volatile LogFactory nullClassLoaderFactory = null;

   protected LogFactory() {
   }

   public static LogFactory getFactory() throws LogConfigurationException {
      LogFactory factory = new LogFactory();
      return factory;
   }

   public static Log getLog(String cls) {
      return new DefLog();
   }

   public static Log getLog(Class<?> cls) {
      return new DefLog();
   }

   public static void release(ClassLoader classLoader) {
      // 释放指定类加载器的日志工厂实例
      if (factories != null) {
         factories.remove(classLoader);
      }
   }

   public static void release() {
      // 释放所有日志工厂实例
      if (factories != null) {
         factories.clear();
      }
   }

   public static class DefLog implements Log {
      public void debug(Object var1) {
      }

      public void debug(Object var1, Throwable var2) {
      }

      public void error(Object var1) {
      }

      public void error(Object var1, Throwable var2) {
      }

      public void fatal(Object var1) {
      }

      public void fatal(Object var1, Throwable var2) {
      }

      public void info(Object var1) {
      }

      public void info(Object var1, Throwable var2) {
      }

      public boolean isDebugEnabled() {
         return false;
      }

      public boolean isErrorEnabled() {
         return false;
      }

      public boolean isFatalEnabled() {
         return false;
      }

      public boolean isInfoEnabled() {
         return false;
      }

      public boolean isTraceEnabled() {
         return false;
      }

      public boolean isWarnEnabled() {
         return false;
      }

      public void trace(Object var1) {
      }

      public void trace(Object var1, Throwable var2) {
      }

      public void warn(Object var1) {
      }

      public void warn(Object var1, Throwable var2) {
      }
   }
}
