package test;

import bean.Column;
import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import util.JdbcUtil;
import util.SqlUtil;
import util.StringJoin;

public class EsTest {
   public static void main(String[] args) throws SQLException {
      String content = "{\n      \"ip_port\": \"192.168.47.134:9200\",\n      \"url\": \"http://192.168.47.134:9200/\",\n      \"username\": \"test1\",\n      \"password\": \"123456\",\n      \"dbType\": \"es\",\n      \"redisMode\": \"none\",\n      \"redisIp\": \"192.168.2.105\",\n      \"redisPort\": \"6379\",\n      \"redisUsername\": \"\",\n      \"redisPassword\": \"redis\",\n      \"redisDatabase\": \"0\",\n      \"excludeSchema\": []\n    }";
      JdbcUtil.initData(content);

      try {
         Thread.sleep(2000L);
      } catch (InterruptedException e) {
         e.printStackTrace();
      }

      for(int i = 0; i < 1; ++i) {
         String sql = "GET /_search \n";
         Map<String, String> params = new HashMap();
         params.put("sql", sql);
         params.put("dbType", "es");
         params.put("url", "http://192.168.47.134:9200/");
         params.put("replaceSchema", "testcon");
         params.put("replaceNewTable", "people_bk");
         params.put("replaceTable", ".*test.*");
         params.put("replaceColumn", "name1");
         params.put("expression", "concat(substr(${value},1,1),'**')");
         params.put("configPath", "D:/masking-mysql.properties");
         Map<String, String> map = new HashMap();
         map.put("ghca31.AT_TEST.name", "替1");
         map.put("ghca31.AT_TEST2.name", "替2");
         map.put("ghca31.AT_TEST3.name", "替3");
         map.put("ghca31.AT_TEST.name", "替4");
         map.put("ghca31.AT_TEST2.name", "替5");
         map.put("ghca31.AT_TEST3.name", "替6");
         map.put("ghca_classify_encrytest.T_CONSOLE_DICTIONARY.value", "替7");
         SqlUtil sqlUtil = new SqlUtil();
         System.out.println("\n\n[0]********************************************************************************");
         System.out.println("--------------------- source sql    ------------------------------------------------");
         System.out.println(sql);
         System.out.println("---------------------/source sql    ------------------------------------------------");
         System.out.println("---------------------parse structure------------------------------------------------");
         Map<String, Object> s2 = sqlUtil.parseSqlStructure(params);
         System.out.println("\n\n====schemaMap====");
         Map<String, Object> schemaMap = (Map)s2.get("schemaMap");

         for(Map.Entry<String, Object> item : schemaMap.entrySet()) {
            System.out.println((String)item.getKey() + "\t" + item.getValue());
         }

         System.out.println("\n\n====tableMap====");
         Map<String, Object> tableMap = (Map)s2.get("tableMap");

         for(Map.Entry<String, Object> item : tableMap.entrySet()) {
            System.out.println((String)item.getKey() + "\t" + item.getValue());
         }

         System.out.println("\n\n====whereMap====");
         Map<String, Object> whereMap = (Map)s2.get("whereMap");

         for(Map.Entry<String, Object> item : whereMap.entrySet()) {
            System.out.println((String)item.getKey() + "\t" + item.getValue());
         }

         System.out.println("\n\n====whereList====");

         for(Map<String, Object> where : (ArrayList<Map<String, Object>>)s2.get("whereList")) {
            for(Map.Entry<String, Object> item : where.entrySet()) {
               System.out.println((String)item.getKey() + "\t" + item.getValue());
            }
         }

         System.out.println("\n\n====columnList====");
         ArrayList<Column> columnList = (ArrayList)s2.get("columnList");
         String[] fields = new String[]{"columnName", "columnAlisa", "fullName", "nowName", "dataType", "schema", "table", "value", "expr"};
         int[] size = max(fields, columnList);

         for(int j = 0; j < fields.length; ++j) {
            fields[j] = String.format("%" + size[j] + "s", fields[j]);
         }

         System.out.println(StringJoin.join(fields, "  "));

         for(Column item : columnList) {
            StringBuilder output = new StringBuilder();
            printColumn(item, output, size);
            System.out.println(output);
         }

         System.out.println("\n\n====SQL====");
         System.out.println(s2.get("sql"));
         System.out.println("\n\n====/SQL====");
         System.out.println("---------------------/parse structure------------------------------------------------");
      }

   }

   static double invoke(String sql) {
      try {
         long c = System.nanoTime();
         SQLUtils.parseStatements(sql, DbType.mysql);
         long c1 = System.nanoTime();
         double c2 = (double)(c1 - c) / (double)1000000.0F;
         return c2;
      } catch (Exception e) {
         e.printStackTrace();
         return (double)0.0F;
      }
   }

   static void printColumn(Column col, StringBuilder s, int[] size) {
      s.append(format(col.getColumnName(), size[0])).append("  ").append(format(col.getColumnAlisa(), size[1])).append("  ").append(format(col.getFullName(), size[2])).append("  ").append(format(col.getNowName(), size[3])).append("  ").append(format(col.getDataType(), size[4])).append("  ").append(format(col.getSchema(), size[5])).append("  ").append(format(col.getTable(), size[6])).append("  ").append(format(col.getValue(), size[7])).append("  ").append(format(col.getExpr(), size[8]));
   }

   static String format(Object value, int size) {
      return String.format("%" + size + "s", value);
   }

   static int[] max(String[] fields, List<Column> columns) {
      int[] size = new int[fields.length];

      try {
         for(int i = 0; i < fields.length; ++i) {
            String name = fields[i];
            name = (name.charAt(0) + "").toUpperCase() + name.substring(1);
            String method = "get" + name;
            Method m = Column.class.getDeclaredMethod(method);
            int max = name.length();
            if (columns != null) {
               for(Column column : columns) {
                  Object value = m.invoke(column);
                  if (value != null) {
                     int s = value.toString().length();
                     max = max < s ? s : max;
                  }
               }
            }

            size[i] = max;
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return size;
   }

   class A implements Runnable {
      String sql;

      public A(String sql) {
         this.sql = sql;
      }

      public void run() {
         EsTest.invoke(this.sql);
      }
   }
}
