package test;

import bean.Column;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import util.JdbcUtil;
import util.SqlUtil;
import util.StringJoin;

public class PostGresTest {
   public static void main(String[] args) throws Exception {
      String content = "{\n      \"ip_port\": \"192.168.2.173:5432\",\n      \"url\": \"jdbc:postgresql://192.168.2.173:5432/postgres\",\n      \"username\": \"postgres\",\n      \"isIgnorecase\":\"1\",\n      \"password\": \"postgres\",\n      \"dbType\": \"postgresql\",\n      \"excludeSchema\": []\n    }";
      JdbcUtil.initData(content);
      Thread.sleep(1000L);
      parseSelect1();
   }

   static void parseAlterView() throws Exception {
      testGram("ALTER VIEW a_view SET SCHEMA  new_schema; ");
      testGram("ALTER VIEW a_view SET SCHEMA  public; ");
   }

   static void parseAlterSchema() throws Exception {
      testGram("alter schema myschema rename to myschema1");
      testGram("alter schema public rename to public2");
      testGram("alter schema myschema owner to myuser");
   }

   static void parseDrop() throws Exception {
      testGram("DROP SCHEMA public CASCADE;");
      testGram("DROP SCHEMA IF EXISTS mystuff CASCADE;");
      testGram("DROP SCHEMA mystuff,public RESTRICT;");
      testGram("DROP TABLE IF EXISTS films RESTRICT;");
      testGram("DROP TABLE IF EXISTS schema1.mytable RESTRICT;");
      testGram("DROP TABLE mytable,schema2.films CASCADE;");
   }

   static void parseAlterTable() throws Exception {
      testGram("alter table only PUBLIC.person rename name to person_name");
      testGram("alter table PUBLIC.person rename COLUMN name to person_name");
      testGram("alter table if exists only PUBLIC.person rename COLUMN name to person_name");
      testGram("alter table if exists only PUBLIC.person rename name to person_name");
      testGram("alter table only PUBLIC.person rename name to person_name");
      testGram("alter table only PUBLIC.person rename CONSTRAINT  name to person_name");
      testGram("alter table PUBLIC.person rename CONSTRAINT  name to person_name");
      testGram("alter table if exists only PUBLIC.person rename  CONSTRAINT  name to person_name");
      testGram("alter table if exists only PUBLIC.person rename CONSTRAINT  name to person_name");
      testGram("alter table only PUBLIC.person RENAME CONSTRAINT name to person_name");
      testGram("alter table only PUBLIC.person rename to person_name");
      testGram("alter table PUBLIC.person rename to person_name");
      testGram("alter table if exists only PUBLIC.person rename   to person_name");
      testGram("alter table if exists only PUBLIC.person rename to person_name");
      testGram("alter table only PUBLIC.person RENAME   to person_name");
      testGram("alter table only PUBLIC.person set schema  person_name");
      testGram("alter table PUBLIC.person set schema  person_name");
      testGram("alter table if exists only PUBLIC.person set schema  person_name");
      testGram("alter table if exists only PUBLIC.person set schema person_name");
      testGram("alter table only PUBLIC.person set schema  person_name");
      testGram("alter table all in tablespace my_space set tablespace  person_name");
      testGram("alter table PUBLIC.person set schema  person_name");
      testGram("alter table if exists only PUBLIC.person set schema  person_name");
      testGram("alter table if exists only PUBLIC.person set schema person_name");
      testGram("alter table only PUBLIC.person set schema  person_name");
      testGram("alter table mytable  set WITH  (REORGANIZE=true)");
      testGram("alter table mytable set WITH  (REORGANIZE=false)");
      testGram("alter table  if exists  mytable set WITH  (REORGANIZE=false)");
      testGram("alter table  if exists  mytable set WITH  (REORGANIZE=true)");
      testGram("alter table only mytable  set WITH  (REORGANIZE=true)");
      testGram("alter table only mytable  set WITH  (REORGANIZE=false)");
      testGram("alter table  if exists only mytable set WITH  (REORGANIZE=false)");
      testGram("alter table  if exists only mytable set WITH  (REORGANIZE=true)");
      testGram("alter table mytable set DISTRIBUTED RANDOMLY");
      testGram("alter table  if exists  mytable set DISTRIBUTED RANDOMLY ");
      testGram("alter table only mytable set  DISTRIBUTED RANDOMLY ");
      testGram("alter table  if exists only mytable set DISTRIBUTED RANDOMLY");
      testGram("alter table mytable set DISTRIBUTED REPLICATED ");
      testGram("alter table  if exists  mytable set DISTRIBUTED REPLICATED  ");
      testGram("alter table only mytable set  DISTRIBUTED REPLICATED  ");
      testGram("alter table  if exists only mytable set DISTRIBUTED REPLICATED ");
      testGram("alter table mytable set DISTRIBUTED BY (c1) ");
      testGram("alter table mytable set DISTRIBUTED BY (c1 opclass1) ");
      testGram("alter table mytable set DISTRIBUTED BY (c1 opclass1,c2) ");
      testGram("alter table mytable set DISTRIBUTED BY (c1 opclass1,c2 opclass2) ");
      testGram("alter table mytable set DISTRIBUTED BY (c1 opclass1,c2 opclass2,c3 opclass3) ");
      testGram("alter table if exists mytable set DISTRIBUTED BY (c1) ");
      testGram("alter table if exists mytable set DISTRIBUTED BY (c1 opclass1) ");
      testGram("alter table if exists mytable set DISTRIBUTED BY (c1 opclass1,c2) ");
      testGram("alter table if exists mytable set DISTRIBUTED BY (c1 opclass1,c2 opclass2) ");
      testGram("alter table if exists mytable set DISTRIBUTED BY (c1 opclass1,c2 opclass2,c3 opclass3) ");
      testGram("alter table only mytable set DISTRIBUTED BY (c1) ");
      testGram("alter table only mytable set DISTRIBUTED BY (c1 opclass1) ");
      testGram("alter table only mytable set DISTRIBUTED BY (c1 opclass1,c2) ");
      testGram("alter table only mytable set DISTRIBUTED BY (c1 opclass1,c2 opclass2) ");
      testGram("alter table only mytable set DISTRIBUTED BY (c1 opclass1,c2 opclass2,c3 opclass3) ");
      testGram("alter table if exists only mytable set DISTRIBUTED BY (c1) ");
      testGram("alter table if exists only mytable set DISTRIBUTED BY (c1 opclass1) ");
      testGram("alter table if exists only mytable set DISTRIBUTED BY (c1 opclass1,c2) ");
      testGram("alter table if exists only mytable set DISTRIBUTED BY (c1 opclass1,c2 opclass2) ");
      testGram("alter table if exists only mytable set DISTRIBUTED BY (c1 opclass1,c2 opclass2,c3 opclass3) ");
      testGram("alter table mytable add column c2 varchar(50) ");
      testGram("alter table if exists mytable add column c2 varchar(50)  ");
      testGram("alter table only mytable add column c2 varchar(50)  ");
      testGram("alter table if exists only mytable add column c2 varchar(50)  ");
      testGram("alter table mytable add column c2 varchar(50) default '123' ");
      testGram("alter table if exists mytable add column c2 varchar(50) default '123' ");
      testGram("alter table only mytable add column c2 varchar(50) default '123' ");
      testGram("alter table if exists only mytable add column c2 varchar(50) default '123' ");
      testGram("alter table mytable add column c2 varchar(50) default '123' COLLATE 123 ");
      testGram("alter table if exists mytable add column c2 varchar(50) default '123'  COLLATE 123");
      testGram("alter table only mytable add column c2 varchar(50) default '123'  COLLATE 123");
      testGram("alter table if exists only mytable add column c2 varchar(50) default '123'  COLLATE 123");
      testGram("alter table mytable add column c2 varchar(50) default '123' COLLATE 123 encoding ( 'utf-8')");
      testGram("alter table if exists mytable add column c2 varchar(50) default '123'  COLLATE 123 encoding ( 'utf-8','gb2312')");
      testGram("alter table only mytable add column c2 varchar(50) default '123'  COLLATE 123 encoding ( 'utf-8','gb2312')");
      testGram("alter table if exists only mytable add column c2 varchar(50) default '123'  COLLATE 123 encoding ( 'utf-8','gb2312')");
      testGram("alter table mytable add column c2 varchar(50) encoding ( 'utf-8')");
      testGram("alter table if exists mytable add column c2 varchar(50) COLLATE 123 encoding ( 'utf-8','gb2312')");
      testGram("alter table only mytable add column c2 varchar(50) default '123'encoding ( 'utf-8','gb2312')");
      testGram("alter table if exists only mytable add column c2 varchar(50)  encoding ( 'utf-8','gb2312')");
      testGram("alter table if exists only mytable drop column if exists  c3 restrict");
      testGram("alter table if exists only mytable drop column c3 restrict");
      testGram("alter table if exists only mytable drop if exists  c3 restrict");
      testGram("alter table if exists only mytable drop c3 restrict");
      testGram("alter table if exists only mytable drop column if exists  c3 CASCADE");
      testGram("alter table if exists only mytable drop column c3 CASCADE");
      testGram("alter table if exists only mytable drop if exists  c3 CASCADE");
      testGram("alter table if exists only mytable drop c3 CASCADE");
      testGram("alter table  only mytable drop column if exists  c3 restrict");
      testGram("alter table if exists  mytable drop column c3 restrict");
      testGram("alter table if exists only mytable alter column c3 set data type int(10) collate 1 using a");
      testGram("alter table if exists only mytable alter column c3 set data type int(10) collate 1");
      testGram("alter table if exists only mytable alter column c3 set data type int(10)  using a");
      testGram("alter table if exists only mytable alter column c3 set data type int(10) ");
      testGram("alter table if exists only mytable alter column c3 type int(10) collate 1 using a");
      testGram("alter table if exists only mytable alter column c3 type int(10) collate 1");
      testGram("alter table if exists only mytable alter column c3 type int(10)  using a");
      testGram("alter table if exists only mytable alter column c3 type int(10) ");
      testGram("alter table if exists only mytable alter  c3 type int(10) ");
      testGram("alter table if exists only mytable alter column c1 set default 123 ");
      testGram("alter table if exists only mytable alter column c2 drop default ");
      testGram("alter table if exists only mytable alter column c2 set not null ");
      testGram("alter table if exists only mytable alter column c2 drop not null ");
      testGram("alter table if exists only mytable alter column c2 set STATISTICS  123 ");
      testGram("alter table if exists only mytable alter column column set (a=1,b=2) ");
      testGram("alter table if exists only mytable alter column column reset (a,b,c) ");
      testGram("alter table if exists only mytable add constraint cons1 unique using index idx_person_1  ");
      testGram("alter table if exists only mytable add constraint cons1 primary key using index idx_person_1  ");
      testGram("alter table if exists only mytable add constraint cons1 unique using index idx_person_1  DEFERRABLE ");
      testGram("alter table if exists only mytable add constraint cons1 primary key using index  idx_person_1  DEFERRABLE ");
      testGram("alter table if exists only mytable add constraint cons1 unique using index idx_person_1  NOT DEFERRABLE  ");
      testGram("alter table if exists only mytable add constraint cons1 primary key using index idx_person_1  NOT DEFERRABLE  ");
      testGram("alter table if exists only mytable add constraint cons1 unique using index idx_person_1  INITIALLY DEFERRED ");
      testGram("alter table if exists only mytable add constraint cons1 primary key using index  idx_person_1  INITIALLY DEFERRED   ");
      testGram("alter table if exists only mytable add constraint cons1 unique using index idx_person_1  INITIALLY IMMEDIATE  ");
      testGram("alter table if exists only mytable add constraint cons1 primary key using index  idx_person_1  INITIALLY IMMEDIATE  ");
      testGram("alter table if exists only mytable VALIDATE  constraint cons1 ");
      testGram("alter table if exists only mytable drop   constraint cons1 ");
      testGram("alter table if exists only mytable drop constraint if exists    cons1 ");
      testGram("alter table if exists only mytable drop   constraint cons1 RESTRICT  ");
      testGram("alter table if exists only mytable drop  constraint if exists   cons1 RESTRICT  ");
      testGram("alter table if exists only mytable drop   constraint cons1 CASCADE  ");
      testGram("alter table if exists only mytable drop constraint if exists   cons1 CASCADE  ");
      testGram("alter table if exists only mytable DISABLE TRIGGER  triger1  ");
      testGram("alter table if exists only mytable DISABLE TRIGGER  ALL  ");
      testGram("alter table if exists only mytable DISABLE TRIGGER  USER  ");
      testGram("alter table if exists only mytable eNable TRIGGER  triger1  ");
      testGram("alter table if exists only mytable eNable TRIGGER  ALL  ");
      testGram("alter table if exists only mytable eNable TRIGGER  USER  ");
      testGram("alter table if exists only mytable cluster on my_index_name ");
      testGram("alter table if exists only mytable set  without cluster ");
      testGram("alter table if exists only mytable set  without oids ");
      testGram("alter table if exists only mytable set (a=1)");
      testGram("alter table if exists only mytable set (b=1)");
      testGram("alter table if exists only mytable reset (a)");
      testGram("alter table if exists only mytable reset (a,b,)");
      testGram("alter table if exists only mytable INHERIT  father_table");
      testGram("alter table if exists only mytable no INHERIT  father_table");
      testGram("alter table if exists only mytable of `mytype` ");
      testGram("alter table if exists only mytable not of ");
      testGram("alter table if exists only mytable OWNER to root ");
      testGram("alter table if exists only mytable set tablespace my_new_tablespace ");
      testGram("alter table if exists only mytable OWNER to root ,set tablespace my_new_tablespace ");
   }

   static void parseUpdate() throws Exception {
      testGram("UPDATE films SET kind = 'Dramatic' WHERE kind = 'Drama';");
   }

   static void parseCreateView() throws Exception {
      testGram("SELECT 'Hello World'");
      testGram("CREATE VIEW vista AS SELECT 'Hello World';");
      testGram("CREATE OR REPLACE VIEW vista AS SELECT 'Hello World';");
      testGram("CREATE OR REPLACE TEMP VIEW vista with (check_option=CASCADED) AS SELECT 'Hello World';");
      testGram("CREATE TEMP VIEW vista AS SELECT 'Hello World';");
      testGram("CREATE TEMPORARY VIEW vista with (security_barrier=true) AS SELECT 'Hello World';");
      testGram("CREATE TEMP VIEW vista AS SELECT 'Hello World' WITH CASCADED CHECK OPTION;");
      testGram("CREATE VIEW vista AS SELECT text 'Hello World' AS hello;");
      testGram("CREATE VIEW comedies AS SELECT * FROM films WHERE kind = 'comedy';");
      testGram("CREATE VIEW comedies AS SELECT * FROM films WHERE kind = 'comedy' WITH LOCAL CHECK OPTION;");
      testGram("CREATE VIEW topten AS SELECT name, rank, gender, year FROM names, rank WHERE rank < '11' AND names.id=rank.id;");
      testGram("CREATE RECURSIVE VIEW public.nums_1_100 (n) AS VALUES (1) UNION ALL SELECT n+1 FROM nums_1_100 WHERE n < 100;");
      testGram("CREATE VIEW public.foo AS WITH RECURSIVE foo(i) AS (SELECT 1 UNION ALL SELECT i+1 from (SELECT * FROM foo UNION SELECT 0) bar ) SELECT * FROM foo LIMIT 5;");
      testGram("WITH RECURSIVE foo(i) AS (SELECT 1 UNION ALL SELECT i+1 from (SELECT * FROM foo UNION SELECT 0) bar ) SELECT * FROM foo LIMIT 5;");
      testGram("CREATE OR REPLACE RECURSIVE VIEW public.nums_1_100 (n) AS VALUES (1) UNION ALL SELECT n+1 FROM nums_1_100 WHERE n < 100;");
      testGram("CREATE OR REPLACE TEMP RECURSIVE VIEW public.nums_1_100 (n) AS VALUES (1) UNION ALL SELECT n+1 FROM nums_1_100 WHERE n < 100;");
      testGram("CREATE TEMP RECURSIVE VIEW public.nums_1_100 (n) AS VALUES (1) UNION ALL SELECT n+1 FROM nums_1_100 WHERE n < 100;");
      testGram("CREATE TEMPORARY RECURSIVE VIEW public.nums_1_100 (n) AS VALUES (1) UNION ALL SELECT n+1 FROM nums_1_100 WHERE n < 100;");
   }

   static void parseCreateTable() throws Exception {
      testGram("create table mytable ( c1 varchar(50) )");
      testGram("create global temporary table mytable ( c1 varchar(50) )");
      testGram("create local UNLOGGED table mytable ( c1 varchar(50) )");
      testGram("create  TEMPORARY  table mytable ( c1 varchar(50) )");
      testGram("create  TEMP  table mytable ( c1 varchar(50) )");
      testGram("create  UNLOGGED table mytable ( c1 varchar(50) )");
      testGram("create table mytable ( c1 varchar(50),c2 varchar(50) )");
      testGram("create table mytable ( c1 varchar(50) constraint my_constraint   )");
      testGram("create table mytable ( c1 varchar(50) constraint my_constraint not null  )");
      testGram("create table mytable ( c1 varchar(50)  not null  )");
      testGram("create table mytable ( c1 varchar(50)   null  )");
      testGram("create table mytable ( c1 varchar(50)   check (c1>10)  )");
      testGram("create table mytable ( c1 varchar(50)  default 'abc'  )");
      testGram("create table mytable ( c1 varchar(50) unique   )");
      testGram("create table mytable ( c1 varchar(50) unique with(a=1)  )");
      testGram("create table mytable ( c1 varchar(50) unique with(a=1,b=2)  )");
      testGram("create table mytable ( c1 varchar(50) unique using index tablespace my_tablespace  )");
      testGram("create table mytable ( c1 varchar(50) unique with(a=1) using index tablespace my_tablespace  )");
      testGram("create table mytable ( c1 varchar(50) unique with(a=1,b=2) using index tablespace my_tablespace  )");
      testGram("create table mytable ( c1 varchar(50) unique with(a,b=2) using index tablespace my_tablespace  )");
      testGram("create table mytable ( c1 varchar(50) references tb1  )");
      testGram("create table mytable ( c1 varchar(50) references tb1 (cc1) )");
      testGram("create table mytable ( c1 varchar(50) references tb1 match full )");
      testGram("create table mytable ( c1 varchar(50) references tb1 match PARTIAL  )");
      testGram("create table mytable ( c1 varchar(50) references tb1 match SIMPLE   )");
      testGram("create table mytable ( c1 varchar(50) references tb1 on delete cascade   )");
      testGram("create table mytable ( c1 varchar(50) references tb1 on update set default   )");
      testGram("create table mytable ( c1 varchar(50) references tb1 on update on DELETE    )");
      testGram("create table mytable ( c1 varchar(50) references tb1 on update on update   )");
      testGram("create table mytable ( c1 varchar(50) references tb1 on update no action   )");
      testGram("create table mytable ( c1 varchar(50) references tb1 on update restrict   )");
      testGram("create table mytable ( c1 varchar(50) references tb1 on update set null   )");
      testGram("create table mytable ( c1 varchar(50) references tb1 on update set DEFAULT   )");
      testGram("create table mytable ( c1 varchar(50) DEFERRABLE   )");
      testGram("create table mytable ( c1 varchar(50) NOT DEFERRABLE   )");
      testGram("create table mytable ( c1 varchar(50)  INITIALLY DEFERRED  )");
      testGram("create table mytable ( c1 varchar(50) INITIALLY IMMEDIATE   )");
      testGram("create table mytable ( c1 varchar(50) not null  check (c1>10)  unique with(a=1)  references tb1 on update set DEFAULT INITIALLY IMMEDIATE ,c2 varchar(50) primary key  )");
      testGram("create table mytable ( c1 varchar(50) INITIALLY IMMEDIATE encoding (compresstype=zlib,compresslevel=0)  ) ");
      testGram("create table mytable ( c1 varchar(50)  UNIQUE (c2,c1 ) ) ");
      testGram("create table mytable ( c1 varchar(50)  like my_tables_source INCLUDING DEFAULTS  EXCLUDING STORAGE ) ");
      testGram("create table mytable ( c1 varchar(50),c2 varchar(50) ) inherits (ta,tb)");
      testGram("create table mytable ( c1 varchar(50),c2 varchar(50) ) with (a=1,b=2)");
      testGram("create table mytable ( c1 varchar(50),c2 varchar(50) ) on commit PRESERVE ROWS ");
      testGram("create table mytable ( c1 varchar(50),c2 varchar(50) ) on commit DELETE  ROWS ");
      testGram("create table mytable ( c1 varchar(50),c2 varchar(50) ) on commit DROP  ");
      testGram("create table mytable ( c1 varchar(50),c2 varchar(50) ) tablespace mytablespace  ");
      testGram("create table mytable ( c1 varchar(50),c2 varchar(50) ) distributed by (c1 opc1,c2,c3) ");
      testGram("create table mytable ( c1 varchar(50),c2 varchar(50) ) distributed RANDOMLY  ");
      testGram("create table mytable ( c1 varchar(50),c2 varchar(50) ) distributed REPLICATED  ");
      testGram("CREATE TABLE baby.rank (id int, rank int, year smallint, \ngender char(1), count int ) DISTRIBUTED BY (rank, gender, \nyear);");
      testGram("CREATE TABLE films (\ncode        char(5) CONSTRAINT firstkey PRIMARY KEY,\ntitle       varchar(40) NOT NULL,\ndid         integer NOT NULL,\ndate_prod   date,\nkind        varchar(10)\n);");
      testGram("CREATE TABLE distributors (\ndid    integer PRIMARY KEY DEFAULT nextval('serial'),\nname   varchar(40) NOT NULL CHECK (name <> '')\n);");
      testGram("CREATE TABLE sales (txn_id int, qty int, date date) \nWITH (appendoptimized=true, compresslevel=5) \nDISTRIBUTED BY (txn_id);");
   }

   static void parseInsert() throws Exception {
      testGram("insert into table1 select * from table1");
   }

   static void parseDelete() throws Exception {
      testGram("DELETE FROM rank USING names WHERE names.id = rank.id AND name = 'Hannah';");
   }

   static void parseTruncate() throws Exception {
      testGram("TRUNCATE aa.films, distributors;");
      testGram("TRUNCATE TABLE films, distributors;");
      testGram("TRUNCATE TABLE ONLY films, distributors;");
      testGram("TRUNCATE TABLE ONLY films, distributors RESTART IDENTITY;");
      testGram("TRUNCATE TABLE ONLY films, distributors RESTART IDENTITY CASCADE;");
      testGram("TRUNCATE TABLE ONLY films, distributors RESTART IDENTITY RESTRICT;");
      testGram("TRUNCATE TABLE ONLY films, distributors  CONTINUE IDENTITY;");
      testGram("TRUNCATE TABLE ONLY films, distributors  CONTINUE IDENTITY CASCADE;");
      testGram("TRUNCATE TABLE ONLY films, distributors  CONTINUE IDENTITY RESTRICT;");
      testGram("TRUNCATE films, distributors RESTART IDENTITY;");
   }

   static void parseSelect1() throws Exception {
      testGram("select d.dept_id, d.parent_id, d.ancestors, d.dept_name, d.order_num, d.leader, d.phone, d.email, d.status,\n\t\t\t(select dept_name from sys_dept where dept_id = d.parent_id) parent_name\n\t\tfrom sys_dept d\n\t\twhere d.dept_id = ? -- appUsername=");
   }

   static void parseSelect() throws Exception {
      testGram("select * from films");
      testGram("select code,title,kind from films f");
      testGram("select 1");
      testGram("select * from (select code from films) a");
      testGram("select code,title,kind from films a left join person b on a.did=b.id");
      testGram("select code,title,kind,age from films a left join person b on a.did=b.id");
      testGram("select * from (select code,title,kind from films a left join person b on a.did=b.id) t");
      testGram("select * from (select code,title,kind,age from films a left join person b on a.did=b.id) t");
      testGram("select * from person union all select * from person2 t");
      testGram("select * from person t(id1,name1,sex1) where t.id1='1'");
      testGram("select id1,name,sex from person3 as t(id1,name,sex)");
      testGram("SELECT  username as name from person ;");
      testGram("SELECT  'Hello World' as hello ;");
      testGram("select title from person where title is not null");
      testGram("select * from substr('hello world',2,3)");
      testGram("select * from  person * ");
      testGram("select * from  ( select * from person *) t");
      testGram("select * from  ( select id,name,sex from person *) t (tid,tname,tsex)");
      testGram("select * from substr('hello world',2,3) with ordinality");
      testGram("SELECT * FROM substr('hello world',2,3) WITH ORDINALITY as t (name)");
      testGram("select * from ccc3() as (name varchar)");
      testGram("select * from ccc3(1,'2') as (name varchar,addr varchar)");
      testGram("select * from person natural join person1");
      testGram("select * from person  join person1 on person.id=person1.id");
      testGram("select * from person inner join person1 on person.id=person1.id");
      testGram("select * from person LEFT  join person1 on person.id=person1.id");
      testGram("select * from person left OUTER  join person1 on person.id=person1.id");
      testGram("select * from person RIGHT   join person1 on person.id=person1.id");
      testGram("select * from person RIGHT  OUTER  join person1 on person.id=person1.id");
      testGram("select * from person FULL     join person1 on person.id=person1.id");
      testGram("select * from person FULL   OUTER  join person1 on person.id=person1.id");
      testGram("select * from person CROSS JOIN person1");
      testGram("select * from person inner join person1 using(id);");
      testGram("select * from person LEFT  join person1  using(id);");
      testGram("select * from person left OUTER  join person1  using(id);");
      testGram("select * from person RIGHT   join person1   using(id);");
      testGram("select * from person RIGHT  OUTER  join person1  using(id);");
      testGram("select * from person FULL     join person1  using(id);");
      testGram("select * from person FULL   OUTER  join person1  using(id);");
      testGram("with films_with(aa,bb,cc) as ( select code,title,did from films)\nselect * from films_with;");
      testGram("WITH RECURSIVE all_managers(aa, bb, cc, level) AS (\n    SELECT eid, ename, manager_id, 0 FROM employees WHERE ename='Bob'\n    UNION ALL\n    SELECT e.eid, e.ename, e.manager_id, level+1\n    FROM employees e\n    JOIN all_managers am ON e.eid = am.manager_id\n)\nSELECT * FROM all_managers ORDER BY level DESC;");
      testGram("WITH RECURSIVE foo(i) AS (\n    SELECT 1\n  UNION ALL\n    SELECT i+1 FROM (SELECT * FROM foo UNION SELECT 0) bar\n)\nSELECT * FROM foo LIMIT 5;");
      testGram("WITH RECURSIVE foo(i) AS (\n    SELECT 1\n  UNION ALL\n    SELECT i+1 from foo\n)\nSELECT * FROM foo LIMIT 5;\n");
      testGram("WITH  foo  AS (\n\t\tSELECT 1\n\t)\nSELECT *\nFROM foo");
      testGram("WITH  foo  AS (\n\t\tvalues (1,2),(3,4)\n\t\t\t)\nSELECT *\nFROM foo");
      testGram("WITH  foo  AS (\n\t\tselect * from person\n\t\t\t)\nSELECT *\nFROM foo");
      testGram("WITH  foo  AS (\n\t\tinsert into person values('3','王五','女','20','财务',3000) returning *\n\t\t)\nSELECT *\nFROM foo");
      testGram("\nWITH  foo  AS (\n\t\tdelete from person where id='5' returning *\n\t\t)\nSELECT *\nFROM foo");
      testGram("select * from person union select * from person1;");
      testGram("select * from person union all select * from person1;");
      testGram("select * from person union distinct select * from person1;");
      testGram("select * from person INTERSECT  select * from person1;");
      testGram("select * from person INTERSECT  all select * from person1;");
      testGram("select * from person INTERSECT  distinct select * from person1;");
      testGram("select * from person EXCEPT  select * from person1;");
      testGram("select * from person EXCEPT  all select * from person1;");
      testGram("select * from person EXCEPT  distinct select * from person1;");
      testGram("with t as (select * from person) select * from t");
      testGram("with t as (select * from person) table only t");
      testGram("table only person");
      testGram("table person *");
      testGram("select * from (\n\twith t as (select * from person) table only t\n) tx join person1 p  on tx.id=p.id");
      testGram("select  distinct on (name='李四') * from person t  ");
      testGram("select  all  * from person t ");
      testGram("select  all  * from person t where id='1' ");
      testGram("select * from person as t");
      testGram("\nwith  tb1 as (select  * from films)\nselect * from  person as t(a,b,c,d)");
      testGram("select * from (values (1),(2),(3)) t (id)");
      testGram("select * from (\nSELECT *\nFROM \n(VALUES (1),(2),(3)) t (id)\n) t1 cross join person p  \n");
      testGram("select * from substr('hello world',2,3)");
      testGram("SELECT name, rank() OVER (mywindow) FROM person\nGROUP BY name\nWINDOW mywindow AS (ORDER BY sum(salary));\n");
      testGram("\t\nSELECT \n\tname, rank() OVER ( mywindow) ,rank()OVER(win1)\nFROM person\nGROUP BY name\nWINDOW mywindow AS (ORDER BY sum(salary))\n, win1 as (mywindow )");
      testGram("select * from films as t(xx,n1,n2,n3)");
      testGram("select * from (select * from person as t(x,y,z)) t1x   (a,b,c,d)");
      testGram("select * from (select * from films) t");
      testGram("select id ,count(*) from person group by id");
      testGram("select id , addr,count(*) from t1 group by id,addr");
      testGram("select id ,count(*) from t1 group by id+1");
      testGram("select id ,count(*) from t1 group by ROLLUP (id)");
      testGram("select id ,count(*) from t1 group by CUBE  (id)");
      testGram("select id,addr ,count(*) from t1 group by ROLLUP (id,addr)");
      testGram("select id,addr ,count(*) from t1 group by CUBE  (id,addr)");
      testGram("select id ,count(*) from t1 group by GROUPING SETS (id)");
      testGram("select id ,count(*) from t1 group by GROUPING  SETS (  ROLLUP (id) )");
      testGram("select id ,count(*) from t1 group by GROUPING  SETS (  CUBE (id) )");
      testGram("select id ,count(*) from t1 group by id having count(*)>2");
      testGram("select id , addr,count(*) from t1 group by id,addr having count(*)>2");
      testGram("select id ,count(*) from t1 group by id+1 having count(*)>2");
      testGram("select id ,count(*) from t1 group by ROLLUP (id) having count(*)>2");
      testGram("select id ,count(*) from t1 group by CUBE  (id) having count(*)>2");
      testGram("select id,addr ,count(*) from t1 group by ROLLUP (id,addr) having count(*)>2");
      testGram("select id,addr ,count(*) from t1 group by CUBE  (id,addr) having count(*)>2");
      testGram("select id ,count(*) from t1 group by GROUPING SETS (id) having count(*)>2");
      testGram("select id ,count(*) from t1 group by GROUPING  SETS (  ROLLUP (id) ) having count(*)>2");
      testGram("select id ,count(*) from t1 group by GROUPING  SETS (  CUBE (id) ) having count(*)>2");
      testGram("select * from t1 order by id");
      testGram("select * from t1 order by id asc");
      testGram("select * from t1 order by id desc");
      testGram("select * from t1 order by id nulls first");
      testGram("select * from t1 order by id asc nulls first");
      testGram("select * from t1 order by id desc nulls first");
      testGram("select * from t1 order by id nulls LAST");
      testGram("select * from t1 order by id asc nulls LAST");
      testGram("select * from t1 order by id desc nulls LAST");
      testGram("select * from t1 order by id using <");
      testGram("select * from t1 order by id using <=");
      testGram("select * from public.person ");
      testGram("select * from person ");
      testGram("select * from t1 limit 1");
      testGram("select * from t1 limit all");
      testGram("select * from person order by id limit 2 offset 1");
      testGram("select * from person order by id offset 1 fetch next 5 rows only");
      testGram("select * from person order by id offset 1 fetch next 5 row only");
      testGram("select * from person order by id offset 1 fetch first 5 rows only");
      testGram("select * from person order by id offset 1 fetch first 5 row only");
      testGram("select * from person order by id offset 1 rows fetch next 5 rows only");
      testGram("select * from person order by id offset 1 rows fetch next 5 row only");
      testGram("select * from person order by id offset 1 rows fetch first 5 rows only");
      testGram("select * from person order by id offset 1 rows fetch first 5 row only");
      testGram("select * from person order by id offset 1 row fetch next 5 rows only");
      testGram("select * from person order by id offset 1 row fetch next 5 row only");
      testGram("select * from person order by id offset 1 row fetch first 5 rows only");
      testGram("select * from person order by id offset 1 row fetch first 5 row only");
      testGram("select * from t1 offset 10 ");
      testGram("select * from t1 offset 10 row");
      testGram("select * from t1 offset 10 rows");
      testGram("select * from person fetch first 10 row only");
      testGram("select * from person fetch next 10  rows only");
      testGram("select * from person for update");
      testGram("select * from person for no key update");
      testGram("select * from person for  SHARE");
      testGram("select * from person for KEY SHARE");
      testGram("select * from person for update of person");
      testGram("select * from person t for update of t");
      testGram("select * from person t1,person1 t2 for update of t1,t2\n");
      testGram("select * from person t1,person1 t2 for update of t1,t2 nowait");
      testGram("select * from person t1,person1 t2 for key share of t2 nowait for update of t1 nowait");
      testGram("select * into public.person4  from public.person ");
      testGram("select * into temporary person_temp  from public.person ");
      testGram("select * into person from person1 as t(xx,n1,n2,n3)");
      testGram("select * into temporary person_temp1  from public.person ;");
      testGram("select * into temp person_temp2  from public.person ;");
      testGram("select * into UNLOGGED person_temp3  from public.person ;");
      testGram("select * into temporary table person_temp1  from public.person ;");
      testGram("select * into temp table person_temp2  from public.person ;");
      testGram("select * into UNLOGGED table person_temp3  from public.person ;");
      testGram("select * into UNLOGGED table person_temp3  from public.person for update;");
   }

   static void testGram(String sql) throws Exception {
      Map<String, String> params = new HashMap();
      params.put("sql", sql);
      params.put("dbType", "postgresql");
      params.put("schema", "wmx");
      params.put("url", "jdbc:postgresql://192.168.2.173:5432/postgres");
      params.put("replaceSchema", ".*");
      params.put("replaceNewTable", "people_bk");
      params.put("replaceTable", ".*");
      params.put("replaceColumn", ".*title.*");
      params.put("expression", "concat(substr(${value},1,1),'**')");
      params.put("configPath", "D:/masking-mysql.properties");
      params.put("limit", "3");
      System.out.println("...................................................");
      System.out.println("\n\n[0]********************************************************************************");
      System.out.println("--------------------- source sql    ------------------------------------------------");
      System.out.println(sql);
      System.out.println("---------------------/source sql    ------------------------------------------------");
      System.out.println("---------------------parse structure------------------------------------------------");
      SqlUtil sqlUtil = new SqlUtil();
      Map<String, Object> s2 = sqlUtil.parseSqlStructure(params);
      System.out.println("\n\n====schemaMap====");
      Map<String, Object> schemaMap = (Map)s2.get("schemaMap");

      for(Map.Entry<String, Object> item : schemaMap.entrySet()) {
         System.out.println((String)item.getKey() + "\t" + item.getValue());
      }

      System.out.println("\n\n====tableMap====");
      Map<String, Object> tableMap = (Map)s2.get("tableMap");

      for(Map.Entry<String, Object> item : tableMap.entrySet()) {
         System.out.println((String)item.getKey() + "\t" + item.getValue());
      }

      System.out.println("\n\n====whereMap====");
      Map<String, Object> whereMap = (Map)s2.get("whereMap");

      for(Map.Entry<String, Object> item : whereMap.entrySet()) {
         System.out.println((String)item.getKey() + "\t" + item.getValue());
      }

      System.out.println("\n\n====whereList====");

      for(Map<String, Object> where : (ArrayList<Map<String, Object>>)s2.get("whereList")) {
         for(Map.Entry<String, Object> item : where.entrySet()) {
            System.out.println((String)item.getKey() + "\t" + item.getValue());
         }
      }

      System.out.println("\n\n====columnList====");
      ArrayList<Column> columnList = (ArrayList)s2.get("columnList");
      String[] fields = new String[]{"columnName", "columnAlisa", "fullName", "nowName", "dataType", "schema", "table", "value", "expr"};
      int[] size = max(fields, columnList);

      for(int j = 0; j < fields.length; ++j) {
         fields[j] = String.format("%" + size[j] + "s", fields[j]);
      }

      System.out.println(StringJoin.join(fields, "  "));

      for(Column item : columnList) {
         StringBuilder output = new StringBuilder();
         printColumn(item, output, size);
         System.out.println(output);
      }

      System.out.println("\n\n====SQL====");
      System.out.println(s2.get("sql"));
      System.out.println("\n\n====/SQL====");
      System.out.println("---------------------/parse structure------------------------------------------------");
   }

   static void printColumn(Column col, StringBuilder s, int[] size) {
      s.append(format(col.getColumnName(), size[0])).append("  ").append(format(col.getColumnAlisa(), size[1])).append("  ").append(format(col.getFullName(), size[2])).append("  ").append(format(col.getNowName(), size[3])).append("  ").append(format(col.getDataType(), size[4])).append("  ").append(format(col.getSchema(), size[5])).append("  ").append(format(col.getTable(), size[6])).append("  ").append(format(col.getValue(), size[7])).append("  ").append(format(col.getExpr(), size[8]));
   }

   static String format(Object value, int size) {
      return String.format("%" + size + "s", value);
   }

   static int[] max(String[] fields, List<Column> columns) {
      int[] size = new int[fields.length];

      try {
         for(int i = 0; i < fields.length; ++i) {
            String name = fields[i];
            name = (name.charAt(0) + "").toUpperCase() + name.substring(1);
            String method = "get" + name;
            Method m = Column.class.getDeclaredMethod(method);
            int max = name.length();
            if (columns != null) {
               for(Column column : columns) {
                  Object value = m.invoke(column);
                  if (value != null) {
                     int s = value.toString().length();
                     max = max < s ? s : max;
                  }
               }
            }

            size[i] = max;
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return size;
   }

   static void parseTest() throws Exception {
      testGram("\nWITH  foo  AS (\n\t\tdelete from person where id='5' returning *\n\t\t)\nSELECT *\nFROM foo");
   }
}
