package test;

import bean.Column;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import util.JdbcUtil;
import util.SqlUtil;
import util.StringJoin;

public class SparkTest {
   public static void main(String[] args) throws Exception {
      String content = "{\n      \"ip_port\": \"192.168.2.229:10000\",\n      \"url\": \"jdbc:hive2://192.168.2.229:10000\",\n      \"username\": \"root\",\n      \"password\": \"root\",\n      \"dbType\": \"sparksql\",\n      \"redisMode\": \"read\",\n      \"redisIp\": \"192.168.2.105\",\n      \"redisPort\": \"6379\",\n      \"redisUsername\": \"\",\n      \"redisPassword\": \"redis\",\n      \"redisDatabase\": \"0\",\n      \"excludeSchema\": []\n    }";
      JdbcUtil.initData(content);
      SparkTest myTest = new SparkTest();
      myTest.test();
   }

   public void test() throws Exception {
      Map<String, String> params = new HashMap();
      String sql = "SELECT * FROM V_QTSC_JCXX_JLDXX";
      sql = "SELECT JLDXXBS, JLDBH, JLDMC, SSZKDM, SSZKMC, ZKSSDWDM, ZKSSDWMC, ZKSSEJDWDM, ZKSSEJDWMC, ZKSSGLQDM, ZKSSGLQMC, JLLXDM, JLLXMC, KHMC, CJR, CJSJ FROM V_QTSC_JCXX_JLDXX";
      sql = "select * from tb12";
      sql = " insert into tb12 values ('a','b');";
      sql = "insert into tb12 table sys_dept";
      sql = "select * from sys_user a left join sys_dept b on a.dept_id=b.dept_id";
      sql = "insert into sys_dept2 from sys_dept as select * limit 1;";
      sql = "insert into sys_dept2 table sys_dept";
      sql = "insert into sys_dept2 values (1,2,'3')";
      sql = "insert into sys_dept2 (id,name) values (1,2)";
      sql = "insert into sys_dept2  as  select * from sys_dept";
      sql = "insert OVERWRITE sys_dept2 from sys_dept as select * limit 1;";
      sql = "insert OVERWRITE sys_dept2 table sys_dept";
      sql = "insert OVERWRITE sys_dept2 values (1,2,'3')";
      sql = "insert OVERWRITE sys_dept2 (id,name) values (1,2)";
      sql = "insert OVERWRITE sys_dept2  as  select * from sys_dept";
      sql = "select * from sys_dept where dept_id in (1,2,3)";
      sql = " select * from (select * from sys_dept where dept_id=100) as t pivot (count(dept_id) as a for dept_name in ('若依科技' as `若依科技`))";
      sql = "select * from sys_dept where dept_id in (1,2,3) order by dept_name";
      sql = "select * from sys_dept a lateral view  explode(array(30,60)) xx as xxxx;";
      sql = "select * from sys_dept  tablesample (1 ROWS);";
      sql = " select * from sys_dept order by dept_name nulls first";
      sql = "select user_name from sys_user where dept_id in (select dept_id from sys_dept)";
      sql = "select * from ry.personal_concact_datasets";
      params.put("sql", sql);
      params.put("dbType", "sparksql");
      params.put("schema", "ry");
      params.put("url", "jdbc:hive2://192.168.2.229:10000/ry");
      params.put("replaceSchema", ".*");
      params.put("replaceNewTable", "tbxx");
      params.put("replaceTable", ".*");
      params.put("replaceColumn", ".*name.*");
      params.put("expression", "substr(${value},1,1)||'****'");
      params.put("configPath", "D:/masking-mysql.properties");
      Map<String, String> map = new HashMap();
      map.put("ghca31.AT_TEST.name", "替1");
      map.put("ghca31.AT_TEST2.name", "替2");
      map.put("ghca31.AT_TEST3.name", "替3");
      map.put("ghca31.AT_TEST.name", "替4");
      map.put("ghca31.AT_TEST2.name", "替5");
      map.put("ghca31.AT_TEST3.name", "替6");
      map.put("ghca_classify_encrytest.T_CONSOLE_DICTIONARY.value", "替7");
      SqlUtil sqlUtil = new SqlUtil();
      System.out.println("\n\n[0]********************************************************************************");
      System.out.println("--------------------- source sql    ------------------------------------------------");
      System.out.println(sql);
      System.out.println("---------------------/source sql    ------------------------------------------------");
      System.out.println("---------------------parse structure------------------------------------------------");
      params.put("sql", sql);
      Map<String, Object> stringObjectMap = SqlUtil.stringMapToObjectMap(params);
      String desensitization = sqlUtil.desensitization(stringObjectMap);
      System.out.println(".column 脫敏...........................................................");
      System.out.println(desensitization);
      System.out.println("......................................................................");
      String table_desensitization = sqlUtil.table_desensitization(params);
      System.out.println(".table  替換...........................................................");
      System.out.println(table_desensitization);
      System.out.println("......................................................................");
      Map<String, List<String>> modifyTable = new HashMap();
      List<String> vals = new ArrayList();
      vals.add("張三");
      modifyTable.put("USER_NAME", vals);
      Map<String, String> tableKeyWord = new HashMap();
      Map<String, Object> param = new HashMap(params);
      param.put("modifyTable", modifyTable);
      param.put("tableKeyWord", tableKeyWord);
      tableKeyWord.put("tb12", "USER_NAME");
      param.put("operateType", "select");
      param.put("limit", "10");
      String rowvisit = sqlUtil.rowVisitControl(param);
      System.out.println(".row visit ...........................................................");
      System.out.println(rowvisit);
      System.out.println("......................................................................");
      Map<String, Object> s2 = sqlUtil.parseSqlStructure(params);
      System.out.println("\n\n====schemaMap====");
      Map<String, Object> schemaMap = (Map)s2.get("schemaMap");

      for(Map.Entry<String, Object> item : schemaMap.entrySet()) {
         System.out.println((String)item.getKey() + "\t" + item.getValue());
      }

      System.out.println("\n\n====tableMap====");
      Map<String, Object> tableMap = (Map)s2.get("tableMap");

      for(Map.Entry<String, Object> item : tableMap.entrySet()) {
         System.out.println((String)item.getKey() + "\t" + item.getValue());
      }

      System.out.println("\n\n====whereMap====");
      Map<String, Object> whereMap = (Map)s2.get("whereMap");

      for(Map.Entry<String, Object> item : whereMap.entrySet()) {
         System.out.println((String)item.getKey() + "\t" + item.getValue());
      }

      System.out.println("\n\n====whereList====");

      for(Map<String, Object> where : (ArrayList<Map<String, Object>>)s2.get("whereList")) {
         for(Map.Entry<String, Object> item : where.entrySet()) {
            System.out.println((String)item.getKey() + "\t" + item.getValue());
         }
      }

      System.out.println("\n\n====columnList====");
      ArrayList<Column> columnList = (ArrayList)s2.get("columnList");
      String[] fields = new String[]{"columnName", "columnAlisa", "fullName", "nowName", "dataType", "schema", "table", "value", "expr"};
      int[] size = this.max(fields, columnList);

      for(int j = 0; j < fields.length; ++j) {
         fields[j] = String.format("%" + size[j] + "s", fields[j]);
      }

      System.out.println(StringJoin.join(fields, "  "));

      for(Column item : columnList) {
         StringBuilder output = new StringBuilder();
         this.printColumn(item, output, size);
         System.out.println(output);
      }

      System.out.println("\n\n====SQL====");
      System.out.println(s2.get("sql"));
      System.out.println("\n\n====/SQL====");
      System.out.println("---------------------/parse structure------------------------------------------------");
   }

   private void printColumn(Column col, StringBuilder s, int[] size) {
      s.append(this.format(col.getColumnName(), size[0])).append("  ").append(this.format(col.getColumnAlisa(), size[1])).append("  ").append(this.format(col.getFullName(), size[2])).append("  ").append(this.format(col.getNowName(), size[3])).append("  ").append(this.format(col.getDataType(), size[4])).append("  ").append(this.format(col.getSchema(), size[5])).append("  ").append(this.format(col.getTable(), size[6])).append("  ").append(this.format(col.getValue(), size[7])).append("  ").append(this.format(col.getExpr(), size[8]));
   }

   private String format(Object value, int size) {
      return String.format("%" + size + "s", value);
   }

   private int[] max(String[] fields, List<Column> columns) {
      int[] size = new int[fields.length];

      try {
         for(int i = 0; i < fields.length; ++i) {
            String name = fields[i];
            name = (name.charAt(0) + "").toUpperCase() + name.substring(1);
            String method = "get" + name;
            Method m = Column.class.getDeclaredMethod(method);
            int max = name.length();
            if (columns != null) {
               for(Column column : columns) {
                  Object value = m.invoke(column);
                  if (value != null) {
                     int s = value.toString().length();
                     max = max < s ? s : max;
                  }
               }
            }

            size[i] = max;
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return size;
   }
}
