package util;

import java.util.HashMap;
import java.util.Map;

public class ParseCacheUtil {
   public static boolean isOpen = false;
   public static Integer limit = 1000;
   public static final String SQLPARSE_CACHE = "sqlparseCache";
   public static Map<String, Map<String, Object>> sqlparseCacheMap = new HashMap();
   public static Map<String, Map<String, Object>> sqlResultCacheMap = new HashMap();

   public static String getFlag(Map<String, String> param) {
      String sql = (String)param.get("sql");
      boolean isEncryption = param.containsKey("encryption");
      String permission = (String)param.get("permission");
      String url = (String)param.get("url");
      String schema = (String)param.get("schema");
      String dbType = (String)param.get("dbType");
      StringBuilder builder = new StringBuilder();
      builder.append(sql).append(isEncryption).append(permission).append(url).append(schema).append(dbType);
      String flag = builder.toString();
      return flag;
   }

   public static String getPolicyFlag(Map<String, Object> param) {
      String sql = (String)param.get("sql");
      String dbType = (String)param.get("dbType");
      String schema = (String)param.get("schema");
      String url = (String)param.get("url");
      String replaceSchema = (String)param.get("replaceSchema");
      String replaceTable = (String)param.get("replaceTable");
      String replaceColumn = (String)param.get("replaceColumn");
      String expression = (String)param.get("expression");
      StringBuilder builder = new StringBuilder();
      builder.append(sql).append(dbType).append(schema).append(url).append(replaceSchema).append(replaceTable).append(replaceColumn).append(expression);
      String flag = builder.toString();
      return flag;
   }

   public static String getFlag(String sql, String schema) {
      StringBuilder builder = new StringBuilder();
      builder.append(sql).append(schema);
      String flag = builder.toString();
      return flag;
   }

   public static void checkLimit() {
      if (sqlparseCacheMap.size() > limit) {
         sqlparseCacheMap = new HashMap();
      }

      if (sqlResultCacheMap.size() > limit) {
         sqlResultCacheMap = new HashMap();
      }

   }

   public static void init() {
      sqlparseCacheMap = new HashMap();
      sqlResultCacheMap = new HashMap();
   }
}
