package util.getdata;

import bean.Column;
import bean.Schema;
import bean.Table;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import util.StringJoin;

class ColumnThreads implements Runnable {
   public static final int QUERY_TABLE_NUMS = 200;
   private List<Column> columnList;
   private Connection connection;
   private List<Schema> tempSchemas;
   private List<Table> tempTables;
   private CountDownLatch cdl = null;

   public ColumnThreads(Connection connection, List<Schema> tempSchemas, List<Table> tempTables, List<Column> columnList, CountDownLatch cdl) {
      this.connection = connection;
      this.tempSchemas = tempSchemas;
      this.tempTables = tempTables;
      this.columnList = columnList;
      this.cdl = cdl;
   }

   public void run() {
      Statement statement = null;
      ResultSet resultSet = null;

      try {
         statement = this.connection.createStatement();
         List<String> schemaNames = new ArrayList();

         for(int i = 0; i < this.tempSchemas.size(); ++i) {
            Schema schema = (Schema)this.tempSchemas.get(i);
            if (schema != null && schema.getName().length() > 0) {
               schemaNames.add(schema.getName());
            }
         }

         String schemasWhere = StringJoin.join(schemaNames, "','");
         List<String> tableNames = new ArrayList();

         for(int i = 0; i < this.tempTables.size(); ++i) {
            Table table = (Table)this.tempTables.get(i);
            if (table != null && table.getName().length() > 0) {
               tableNames.add(table.getName());
            }
         }

         String sql = "SELECT  A.COLUMN_NAME,A.OWNER,A.TABLE_NAME,A.DATA_TYPE, CASE WHEN INSTR(DATA_TYPE,'(')>0 THEN DATA_TYPE ELSE     (          DATA_TYPE || '(' || A.DATA_LENGTH || (CASE WHEN A.DATA_SCALE IS NULL THEN '' ELSE ','|| A.DATA_SCALE END)  || ')'     ) END AS COLUMN_TYPE,  B.COMMENTS AS REMARK, DATA_LENGTH AS LENGTH, DATA_SCALE AS SCALE ,NVL(C.PK,0) PK  FROM  DBA_TAB_COLUMNS A  JOIN DBA_COL_COMMENTS B ON A.OWNER=B.OWNER AND A.TABLE_NAME=B.TABLE_NAME AND A.COLUMN_NAME =  B.COLUMN_NAME  LEFT JOIN (\nSELECT A.OWNER ,A.TABLE_NAME, B.COLUMN_NAME,1 AS PK FROM SYS.ALL_CONSTRAINTS A  \nLEFT JOIN ALL_CONS_COLUMNS B ON A.OWNER=B.OWNER AND A.CONSTRAINT_NAME=B.CONSTRAINT_NAME  AND A.TABLE_NAME=B.TABLE_NAME \nWHERE A.TABLE_NAME  ='AT_TEST' AND A.CONSTRAINT_TYPE ='P'\n) C ON A.OWNER=C.OWNER AND A.TABLE_NAME=C.TABLE_NAME AND A.COLUMN_NAME=C.COLUMN_NAME\n  WHERE A.OWNER  in( '" + schemasWhere + "') ORDER BY A.COLUMN_ID ASC";
         resultSet = statement.executeQuery(sql);

         while(resultSet.next()) {
            Column column = new Column();
            String schema = resultSet.getString("OWNER");
            String table = resultSet.getString("TABLE_NAME");
            column.setColumnName(resultSet.getString("COLUMN_NAME"));
            column.setSchema(schema);
            column.setTable(table);
            column.setDataType(resultSet.getString("DATA_TYPE"));
            column.setColumnType(resultSet.getString("COLUMN_TYPE"));
            column.setLength(resultSet.getObject("LENGTH") + "");
            Object scale = resultSet.getObject("SCALE");
            column.setDigits(scale == null ? "" : scale.toString());
            String remark = resultSet.getString("REMARK");
            column.setRemark(remark == null ? "" : remark);
            column.setPk(resultSet.getInt("PK"));
            this.columnList.add(column);
         }

         resultSet.close();
      } catch (SQLException throwables) {
         throwables.printStackTrace();
      } finally {
         try {
            resultSet.close();
         } catch (SQLException throwables) {
            throwables.printStackTrace();
         }

         try {
            statement.close();
         } catch (SQLException throwables) {
            throwables.printStackTrace();
         }

         this.cdl.countDown();
      }

   }
}
