package util.sqlparse.visitor.common;

import java.util.HashMap;
import java.util.Map;

public class ID {
   protected static int SEAD = 1;
   public int id;
   protected Map<String, Object> attributes;

   public ID() {
      this.id = SEAD++;
   }

   public Object getAttribute(String name) {
      return this.attributes == null ? null : this.attributes.get(name);
   }

   public boolean containsAttribute(String name) {
      return this.attributes == null ? false : this.attributes.containsKey(name);
   }

   public void putAttribute(String name, Object value) {
      if (this.attributes == null) {
         this.attributes = new HashMap(1);
      }

      this.attributes.put(name, value);
   }

   public void putAttribute(String name) {
      if (this.attributes == null) {
         this.attributes = new HashMap(1);
      }

      this.attributes.put(name, true);
   }

   public Map<String, Object> getAttributesDirect() {
      return this.attributes;
   }
}
