package util.sqlparse.visitor.hivetdh;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import util.StringJoin;

public class ExlFunctionProvider {
   public String substr(String str, Integer begin) {
      return this.substr(str, begin, str.length());
   }

   public String substr(String str, Integer begin, Integer length) {
      if (str != null && str.length() != 0) {
         int len = str.length();
         begin = begin - 1;
         if (begin < 0) {
            begin = 0;
         }

         if (begin >= len) {
            begin = len - 1;
         }

         if (length < 0) {
            length = 0;
         }

         int endIndex = begin + length;
         if (endIndex > len) {
            endIndex = len;
         }

         return str.substring(begin, endIndex);
      } else {
         return str;
      }
   }

   public String substring(String str, Integer begin, Integer end) {
      if (str != null && str.length() != 0) {
         int len = str.length();
         begin = begin - 1;
         if (begin < 0) {
            begin = 0;
         }

         if (begin >= len) {
            begin = len - 1;
         }

         if (end > len) {
            end = len - begin + 1;
         }

         return str.substring(begin, end);
      } else {
         return str;
      }
   }

   public int length(String str) {
      return str == null ? 0 : str.length();
   }

   public String left(String str, Byte len) {
      return this.left(str, Integer.valueOf(len));
   }

   public String left(String str, Integer len) {
      if (str != null && str.length() != 0) {
         len = Math.min(len, str.length());
         return str.substring(0, len);
      } else {
         return str;
      }
   }

   public String now() {
      Date date = new Date();
      SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      return sdf.format(date);
   }

   public String current_timestamp() {
      return this.now();
   }

   public String to_char(Date date, String format) {
      if (format != null && format.length() != 0) {
         SimpleDateFormat sdf = new SimpleDateFormat(format);
         return sdf.format(date);
      } else {
         return date.toString();
      }
   }

   public long timestamp(Date date) {
      return date.getTime();
   }

   public Date date(Double d) {
      return new Date(d.longValue());
   }

   public Date date(Long d) {
      return new Date(d);
   }

   public String date(String str) {
      Date date = this.date(str, "yyyy-MM-dd HH:mm:ss");
      if (date == null) {
         date = this.date(str, "yyyy-MM-dd");
      }

      SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
      return sdf.format(date);
   }

   public Long unix_timestamp(String str) {
      Date date = this.date(str, "yyyy-MM-dd HH:mm:ss");
      if (date == null) {
         date = this.date(str, "yyyy-MM-dd");
      }

      long currentSeconds = date.getTime() / 1000L;
      return currentSeconds;
   }

   public String from_unixtime(Long unixTimestamp) {
      Date date = new Date(unixTimestamp * 1000L);
      SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      String formattedDateTime = sdf.format(date);
      return formattedDateTime;
   }

   public Date date(String str, String format) {
      if (str != null && str.length() != 0) {
         SimpleDateFormat sdf = new SimpleDateFormat(format);
         return sdf.parse(str, new ParsePosition(0));
      } else {
         return null;
      }
   }

   public double random() {
      return Math.random();
   }

   public double rand() {
      return Math.random();
   }

   public double ceiling(Double v) {
      return Math.ceil(v);
   }

   public Integer floor(Double v) {
      return (int)Math.floor(v);
   }

   public int position(String str, String pattern) {
      if (str != null && str.length() != 0) {
         if (pattern != null && pattern.length() != 0) {
            int index = str.indexOf(pattern);
            return index + 1;
         } else {
            return str.length();
         }
      } else {
         return 0;
      }
   }

   public String concat(String str1, String str2, String str3, String str4, String str5, String str6, String str7, String str8) {
      return this.concatCommon(str1, str2, str3, str4, str5, str6, str7, str8);
   }

   public String concat(String str1, String str2, String str3, String str4, String str5, String str6, String str7) {
      return this.concatCommon(str1, str2, str3, str4, str5, str6, str7);
   }

   public String concat(String str1, String str2, String str3, String str4, String str5, String str6) {
      return this.concatCommon(str1, str2, str3, str4, str5, str6);
   }

   public String concat(String str1, String str2, String str3, String str4, String str5) {
      return this.concatCommon(str1, str2, str3, str4, str5);
   }

   public String concat(String str1, String str2, String str3, String str4) {
      return this.concatCommon(str1, str2, str3, str4);
   }

   public String concat(String str1, String str2, String str3) {
      return this.concatCommon(str1, str2, str3);
   }

   public String concat(String str1, String str2) {
      return this.concatCommon(str1, str2);
   }

   public int instr(String str1, String str2) {
      return str1 == null ? 0 : str1.indexOf(str2);
   }

   public String concatCommon(String... strs) {
      StringBuilder sb = new StringBuilder();

      for(String str : strs) {
         sb.append(str);
      }

      return sb.toString();
   }

   public String mask(String originalString, String replaceStr, Integer n, Integer m) {
      m = Math.min(m, originalString.length());
      if (originalString != null && replaceStr != null) {
         if (n >= m) {
            return originalString;
         } else {
            StringBuilder sb = new StringBuilder(originalString);
            sb.replace(n, m, StringJoin.join(Collections.nCopies(m - n, replaceStr), ""));
            return sb.toString();
         }
      } else {
         return originalString;
      }
   }
}
