package util.sqlparse.visitor.mariadb.visitor;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.dialect.mariadb.ast.statement.MariadbAlterTableAddExtPartition;
import com.alibaba.druid.sql.dialect.mariadb.ast.statement.MariadbAlterTableDropExtPartition;
import com.alibaba.druid.sql.dialect.mariadb.ast.statement.MariadbDeleteStatement;
import com.alibaba.druid.sql.dialect.mariadb.ast.statement.MariadbListResourceGroupStatement;
import com.alibaba.druid.sql.dialect.mariadb.ast.statement.MariadbSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mariadb.ast.statement.MariadbUpdateStatement;
import com.alibaba.druid.sql.dialect.mariadb.visitor.DefaultMariadbASTVisitor;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlKillStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.SQLAlterResourceGroupStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.SQLCreateResourceGroupStatement;
import java.util.ArrayList;
import java.util.List;

public class WhereVisitor extends DefaultMariadbASTVisitor {
   private boolean debug = false;
   private List<String> wheres = new ArrayList();

   public List<String> getWheres() {
      return this.wheres;
   }

   public void perform(List<SQLStatement> statements) {
      if (statements != null && statements.size() != 0) {
         for(SQLStatement statement : statements) {
            statement.accept(this);
         }

      }
   }

   public boolean visit(SQLUpdateStatement x) {
      SQLExpr where = x.getWhere();
      if (where != null) {
         this.wheres.add(where.toString());
      }

      return true;
   }

   public void endVisit(MySqlKillStatement x) {
   }

   public boolean visit(MySqlKillStatement x) {
      return false;
   }

   public boolean visit(SQLCreateResourceGroupStatement x) {
      return false;
   }

   public void endVisit(SQLCreateResourceGroupStatement x) {
   }

   public boolean visit(SQLAlterResourceGroupStatement x) {
      return false;
   }

   public void endVisit(SQLAlterResourceGroupStatement x) {
   }

   public boolean visit(MariadbUpdateStatement x) {
      SQLExpr where = x.getWhere();
      if (where != null) {
         this.wheres.add(where.toString());
      }

      return true;
   }

   public boolean visit(MariadbAlterTableAddExtPartition x) {
      return false;
   }

   public void endVisit(MariadbAlterTableAddExtPartition x) {
   }

   public boolean visit(MariadbListResourceGroupStatement x) {
      return false;
   }

   public void endVisit(MariadbListResourceGroupStatement x) {
   }

   public boolean visit(MariadbAlterTableDropExtPartition x) {
      return false;
   }

   public void endVisit(MariadbAlterTableDropExtPartition x) {
   }

   public boolean visit(SQLDeleteStatement x) {
      SQLExpr where = x.getWhere();
      if (where != null) {
         this.wheres.add(where.toString());
      }

      return true;
   }

   public boolean visit(MariadbDeleteStatement x) {
      SQLExpr where = x.getWhere();
      if (where != null) {
         this.wheres.add(where.toString());
      }

      return true;
   }

   public boolean visit(MariadbSelectQueryBlock x) {
      SQLExpr where = x.getWhere();
      if (where != null) {
         this.wheres.add(where.toString());
      }

      SQLSelectGroupByClause groupBy = x.getGroupBy();
      if (groupBy != null && groupBy.getHaving() != null) {
         this.wheres.add(groupBy.getHaving().toString());
      }

      return true;
   }
}
