package com.alibaba.druid.sql.ast;

import com.alibaba.druid.sql.dialect.oracle.ast.OracleSegmentAttributesImpl;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLPartitionValue extends OracleSegmentAttributesImpl {
   protected Operator operator;
   protected final List<SQLExpr> items = new ArrayList();

   public SQLPartitionValue(Operator operator) {
      this.operator = operator;
   }

   public List<SQLExpr> getItems() {
      return this.items;
   }

   public void addItem(SQLExpr item) {
      if (item != null) {
         item.setParent(this);
      }

      this.items.add(item);
   }

   public Operator getOperator() {
      return this.operator;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.getItems());
      }

      visitor.endVisit(this);
   }

   public SQLPartitionValue clone() {
      SQLPartitionValue x = new SQLPartitionValue(this.operator);

      for(SQLExpr item : this.items) {
         SQLExpr item2 = item.clone();
         item2.setParent(x);
         x.items.add(item2);
      }

      return x;
   }

   public static enum Operator {
      LessThan,
      In,
      List,
      EquorLessThan;
   }
}
