package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public final class SQLExistsExpr extends SQLExprImpl implements Serializable {
   private static final long serialVersionUID = 1L;
   public boolean not = false;
   public SQLSelect subQuery;

   public SQLExistsExpr() {
   }

   public SQLExistsExpr(SQLSelect subQuery) {
      this.setSubQuery(subQuery);
   }

   public SQLExistsExpr(SQLSelect subQuery, boolean not) {
      this.setSubQuery(subQuery);
      this.not = not;
   }

   public boolean isNot() {
      return this.not;
   }

   public void setNot(boolean not) {
      this.not = not;
   }

   public SQLSelect getSubQuery() {
      return this.subQuery;
   }

   public void setSubQuery(SQLSelect subQuery) {
      if (subQuery != null) {
         subQuery.setParent(this);
      }

      this.subQuery = subQuery;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this) && this.subQuery != null) {
         this.subQuery.accept(visitor);
      }

      visitor.endVisit(this);
   }

   public List getChildren() {
      return Collections.singletonList(this.subQuery);
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.not ? 1231 : 1237);
      result = 31 * result + (this.subQuery == null ? 0 : this.subQuery.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         SQLExistsExpr other = (SQLExistsExpr)obj;
         if (this.not != other.not) {
            return false;
         } else {
            if (this.subQuery == null) {
               if (other.subQuery != null) {
                  return false;
               }
            } else if (!this.subQuery.equals(other.subQuery)) {
               return false;
            }

            return true;
         }
      }
   }

   public SQLExistsExpr clone() {
      SQLExistsExpr x = new SQLExistsExpr();
      x.not = this.not;
      if (this.subQuery != null) {
         x.setSubQuery(this.subQuery.clone());
      }

      return x;
   }
}
