package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class SQLAlterTableConvertCharSet extends SQLObjectImpl implements SQLAlterTableItem {
   private SQLExpr charset;
   private SQLExpr collate;

   public SQLExpr getCharset() {
      return this.charset;
   }

   public void setCharset(SQLExpr charset) {
      if (charset != null) {
         charset.setParent(this);
      }

      this.charset = charset;
   }

   public SQLExpr getCollate() {
      return this.collate;
   }

   public void setCollate(SQLExpr collate) {
      if (collate != null) {
         collate.setParent(this);
      }

      this.collate = collate;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.charset);
         this.acceptChild(visitor, this.collate);
      }

      visitor.endVisit(this);
   }
}
