package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLIndex;
import com.alibaba.druid.sql.ast.SQLIndexDefinition;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLCreateIndexStatement extends SQLStatementImpl implements SQLCreateStatement, SQLIndex {
   private SQLIndexDefinition indexDefinition = new SQLIndexDefinition();
   private boolean concurrently;
   protected SQLName tablespace;
   protected boolean deferedRebuild;
   protected SQLTableSource in;
   protected SQLExternalRecordFormat rowFormat;
   protected SQLName storedAs;
   protected List<SQLAssignItem> properties = new ArrayList();
   protected List<SQLAssignItem> tableProperties = new ArrayList();
   protected boolean storing;
   protected boolean ifNotExists;
   protected SQLExpr where;

   public SQLExpr getWhere() {
      return this.where;
   }

   public void setWhere(SQLExpr where) {
      this.where = where;
   }

   public SQLCreateIndexStatement() {
      this.indexDefinition.setParent(this);
   }

   public SQLCreateIndexStatement(DbType dbType) {
      super(dbType);
      this.indexDefinition.setParent(this);
   }

   public SQLIndexDefinition getIndexDefinition() {
      return this.indexDefinition;
   }

   public SQLTableSource getTable() {
      return this.indexDefinition.getTable();
   }

   public void setTable(SQLName table) {
      this.setTable((SQLTableSource)(new SQLExprTableSource(table)));
   }

   public void setTable(SQLTableSource table) {
      this.indexDefinition.setTable(table);
   }

   public String getTableName() {
      if (this.indexDefinition.getTable() instanceof SQLExprTableSource) {
         SQLExpr expr = ((SQLExprTableSource)this.indexDefinition.getTable()).getExpr();
         if (expr instanceof SQLIdentifierExpr) {
            return ((SQLIdentifierExpr)expr).getName();
         }

         if (expr instanceof SQLPropertyExpr) {
            return ((SQLPropertyExpr)expr).getName();
         }
      }

      return null;
   }

   public List<SQLSelectOrderByItem> getItems() {
      return this.indexDefinition.getColumns();
   }

   public void addItem(SQLSelectOrderByItem item) {
      if (item != null) {
         item.setParent(this);
      }

      this.indexDefinition.getColumns().add(item);
   }

   public SQLName getName() {
      return this.indexDefinition.getName();
   }

   public void setName(SQLName name) {
      this.indexDefinition.setName(name);
   }

   public String getType() {
      return this.indexDefinition.getType();
   }

   public void setType(String type) {
      this.indexDefinition.setType(type);
   }

   public String getUsing() {
      return this.indexDefinition.hasOptions() ? this.indexDefinition.getOptions().getIndexType() : null;
   }

   public void setUsing(String using) {
      this.indexDefinition.getOptions().setIndexType(using);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.indexDefinition.getName());
         this.acceptChild(visitor, this.indexDefinition.getTable());
         this.acceptChild(visitor, this.indexDefinition.getColumns());
         this.acceptChild(visitor, this.tablespace);
         this.acceptChild(visitor, this.in);
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      if (this.indexDefinition.getName() != null) {
         children.add(this.indexDefinition.getName());
      }

      if (this.indexDefinition.getTable() != null) {
         children.add(this.indexDefinition.getTable());
      }

      children.addAll(this.indexDefinition.getColumns());
      return children;
   }

   public String getSchema() {
      SQLName name = null;
      if (this.indexDefinition.getTable() instanceof SQLExprTableSource) {
         SQLExpr expr = ((SQLExprTableSource)this.indexDefinition.getTable()).getExpr();
         if (expr instanceof SQLName) {
            name = (SQLName)expr;
         }
      }

      if (name == null) {
         return null;
      } else {
         return name instanceof SQLPropertyExpr ? ((SQLPropertyExpr)name).getOwnernName() : null;
      }
   }

   public SQLCreateIndexStatement clone() {
      SQLCreateIndexStatement x = new SQLCreateIndexStatement();
      this.indexDefinition.cloneTo(x.indexDefinition);
      x.setIfNotExists(this.ifNotExists);
      return x;
   }

   public SQLExpr getComment() {
      return this.indexDefinition.hasOptions() ? this.indexDefinition.getOptions().getComment() : null;
   }

   public void setComment(SQLExpr x) {
      this.indexDefinition.getOptions().setComment(x);
   }

   public SQLName getTablespace() {
      return this.tablespace;
   }

   public void setTablespace(SQLName x) {
      if (x != null) {
         x.setParent(this);
      }

      this.tablespace = x;
   }

   public boolean isConcurrently() {
      return this.concurrently;
   }

   public void setConcurrently(boolean concurrently) {
      this.concurrently = concurrently;
   }

   public List<SQLAssignItem> getOptions() {
      return this.indexDefinition.getCompatibleOptions();
   }

   public boolean isDeferedRebuild() {
      return this.deferedRebuild;
   }

   public void setDeferedRebuild(boolean deferedRebuild) {
      this.deferedRebuild = deferedRebuild;
   }

   public SQLTableSource getIn() {
      return this.in;
   }

   public void setIn(SQLName x) {
      if (x == null) {
         this.in = null;
      } else {
         this.setIn((SQLTableSource)(new SQLExprTableSource(x)));
      }
   }

   public void setIn(SQLTableSource x) {
      if (x != null) {
         x.setParent(this);
      }

      this.in = x;
   }

   public SQLName getStoredAs() {
      return this.storedAs;
   }

   public void setStoredAs(SQLName x) {
      if (x != null) {
         x.setParent(this);
      }

      this.storedAs = x;
   }

   public SQLExternalRecordFormat getRowFormat() {
      return this.rowFormat;
   }

   public void setRowFormat(SQLExternalRecordFormat x) {
      if (x != null) {
         x.setParent(this);
      }

      this.rowFormat = x;
   }

   public List<SQLAssignItem> getProperties() {
      return this.properties;
   }

   public List<SQLAssignItem> getTableProperties() {
      return this.tableProperties;
   }

   public void addOption(String name, SQLExpr value) {
      SQLAssignItem assignItem = new SQLAssignItem(new SQLIdentifierExpr(name), value);
      assignItem.setParent(this);
      this.indexDefinition.getOptions().getOtherOptions().add(assignItem);
      this.indexDefinition.getCompatibleOptions().add(assignItem);
   }

   public boolean isGlobal() {
      return this.indexDefinition.isGlobal();
   }

   public void setGlobal(boolean global) {
      this.indexDefinition.setGlobal(global);
   }

   public boolean isLocal() {
      return this.indexDefinition.isLocal();
   }

   public void setLocal(boolean local) {
      this.indexDefinition.setLocal(local);
   }

   public SQLExpr getDbPartitionBy() {
      return this.indexDefinition.getDbPartitionBy();
   }

   public void setDbPartitionBy(SQLExpr x) {
      this.indexDefinition.setDbPartitionBy(x);
   }

   public SQLExpr getTablePartitions() {
      return this.indexDefinition.getTbPartitions();
   }

   public void setTablePartitions(SQLExpr x) {
      this.indexDefinition.setTbPartitions(x);
   }

   public SQLExpr getTablePartitionBy() {
      return this.indexDefinition.getTbPartitionBy();
   }

   public void setTablePartitionBy(SQLExpr x) {
      this.indexDefinition.setTbPartitionBy(x);
   }

   public boolean isStoring() {
      return this.storing;
   }

   public void setStoring(boolean storing) {
      this.storing = storing;
   }

   public List<SQLName> getCovering() {
      return this.indexDefinition.getCovering();
   }

   public List<SQLSelectOrderByItem> getColumns() {
      return this.indexDefinition.getColumns();
   }

   public boolean isIfNotExists() {
      return this.ifNotExists;
   }

   public void setIfNotExists(boolean ifNotExists) {
      this.ifNotExists = ifNotExists;
   }
}
