package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class SQLDumpStatement extends SQLStatementImpl {
   private boolean overwrite;
   private SQLExprTableSource into;
   private SQLSelect select;

   public SQLSelect getSelect() {
      return this.select;
   }

   public void setSelect(SQLSelect x) {
      if (x != null) {
         x.setParent(this);
      }

      this.select = x;
   }

   public SQLExprTableSource getInto() {
      return this.into;
   }

   public void setInto(SQLExpr x) {
      if (x != null) {
         this.setInto(new SQLExprTableSource(x));
      }
   }

   public void setInto(SQLExprTableSource x) {
      if (x != null) {
         x.setParent(this);
      }

      this.into = x;
   }

   public boolean isOverwrite() {
      return this.overwrite;
   }

   public void setOverwrite(boolean overwrite) {
      this.overwrite = overwrite;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         if (this.into != null) {
            this.into.accept(visitor);
         }

         if (this.select != null) {
            this.select.accept(visitor);
         }
      }

      visitor.endVisit(this);
   }
}
