package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SQLSelectStatement extends SQLStatementImpl {
   protected SQLSelect select;

   public SQLSelectStatement() {
   }

   public SQLSelectStatement(DbType dbType) {
      super(dbType);
   }

   public SQLSelectStatement(SQLSelect select) {
      this.setSelect(select);
   }

   public SQLSelectStatement(SQLSelect select, DbType dbType) {
      this(dbType);
      this.setSelect(select);
   }

   public SQLSelect getSelect() {
      return this.select;
   }

   public void setSelect(SQLSelect select) {
      if (select != null) {
         select.setParent(this);
      }

      this.select = select;
   }

   public void output(Appendable buf) {
      this.select.output(buf);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this) && this.select != null) {
         this.select.accept(visitor);
      }

      visitor.endVisit(this);
   }

   public SQLSelectStatement clone() {
      SQLSelectStatement x = new SQLSelectStatement();
      x.dbType = this.dbType;
      x.afterSemi = this.afterSemi;
      if (this.select != null) {
         x.setSelect(this.select.clone());
      }

      if (this.headHints != null) {
         for(SQLCommentHint h : this.headHints) {
            SQLCommentHint h2 = h.clone();
            h2.setParent(x);
            if (x.headHints == null) {
               x.headHints = new ArrayList(this.headHints.size());
            }

            x.headHints.add(h2);
         }
      }

      return x;
   }

   public List<SQLObject> getChildren() {
      return Collections.singletonList(this.select);
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         SQLSelectStatement that = (SQLSelectStatement)o;
         return this.select != null ? this.select.equals(that.select) : that.select == null;
      } else {
         return false;
      }
   }

   public int hashCode() {
      return this.select != null ? this.select.hashCode() : 0;
   }

   public List<String> computeSelecteListAlias() {
      return this.select.computeSelecteListAlias();
   }

   public boolean addWhere(SQLExpr where) {
      return this.select.addWhere(where);
   }
}
