package com.alibaba.druid.sql.dialect.db2.ast.expr;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLTextLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLValuableExpr;
import com.alibaba.druid.sql.ast.statement.SQLCharacterDataType;
import com.alibaba.druid.sql.dialect.db2.visitor.DB2ASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.Collections;
import java.util.List;

public class DB2CurrentTimeExpr extends SQLTextLiteralExpr implements SQLValuableExpr, Comparable<SQLCharExpr> {
   public static final SQLDataType DATA_TYPE = new SQLCharacterDataType("char");

   public DB2CurrentTimeExpr() {
   }

   protected void accept0(SQLASTVisitor v) {
      this.accept0((DB2ASTVisitor)v);
   }

   public DB2CurrentTimeExpr(String text) {
      this.text = text;
   }

   public DB2CurrentTimeExpr(String text, SQLObject parent) {
      this.text = text;
      this.parent = parent;
   }

   public void output(Appendable buf) {
      this.accept(new SQLASTOutputVisitor(buf));
   }

   protected void accept0(DB2ASTVisitor visitor) {
      visitor.visit(this);
      visitor.endVisit(this);
   }

   public Object getValue() {
      return this.text;
   }

   public String toString() {
      return SQLUtils.toSQLString(this);
   }

   public SQLCharExpr clone() {
      return new SQLCharExpr(this.text);
   }

   public SQLDataType computeDataType() {
      return DATA_TYPE;
   }

   public List<SQLObject> getChildren() {
      return Collections.emptyList();
   }

   public int compareTo(DB2CurrentTimeExpr o) {
      return this.text.compareTo(o.text);
   }

   public int compareTo(SQLCharExpr sqlCharExpr) {
      return 0;
   }
}
