package com.alibaba.druid.sql.dialect.db2.ast.stmt.alterTable;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.dialect.db2.ast.DB2SQLObject;
import com.alibaba.druid.sql.dialect.db2.ast.DB2SQLObjectImpl;
import com.alibaba.druid.sql.dialect.db2.visitor.DB2ASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class DB2AlterTableDisableEnabelTrigger extends DB2SQLObjectImpl implements SQLAlterTableItem, DB2SQLObject {
   private boolean isEnable;
   private SQLExpr trigger;
   private Type type = null;

   public SQLExpr getTrigger() {
      return this.trigger;
   }

   public void setTrigger(SQLExpr trigger) {
      this.trigger = trigger;
      trigger.setParent(this);
   }

   public Type getType() {
      return this.type;
   }

   public void setType(Type type) {
      this.type = type;
   }

   public boolean isEnable() {
      return this.isEnable;
   }

   public void setEnable(boolean enable) {
      this.isEnable = enable;
   }

   public void accept0(SQLASTVisitor visitor) {
      this.accept0((DB2ASTVisitor)visitor);
   }

   public void accept0(DB2ASTVisitor visitor) {
      if (visitor.visit(this) && this.trigger != null) {
         this.trigger.accept(visitor);
      }

      visitor.endVisit(this);
   }

   public DB2AlterTableDisableEnabelTrigger clone() {
      DB2AlterTableDisableEnabelTrigger c = new DB2AlterTableDisableEnabelTrigger();
      c.setTrigger(this.trigger.clone());
      c.type = this.type;
      c.isEnable = this.isEnable;
      return c;
   }

   public static enum Type {
      all,
      user;
   }
}
