package com.alibaba.druid.sql.dialect.db2.ast.stmt.alterTable;

import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.dialect.db2.ast.DB2SQLObjectImpl;
import com.alibaba.druid.sql.dialect.db2.visitor.DB2ASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class DB2AlterTableModify extends DB2SQLObjectImpl implements SQLAlterTableItem {
   private List<SQLColumnDefinition> columns = new ArrayList();

   public void accept0(DB2ASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.columns);
      }

      visitor.endVisit(this);
   }

   public List<SQLColumnDefinition> getColumns() {
      return this.columns;
   }

   public void addColumn(SQLColumnDefinition column) {
      if (column != null) {
         column.setParent(this);
      }

      this.columns.add(column);
   }
}
