package com.alibaba.druid.sql.dialect.db2.ast.stmt.alterTable;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.dialect.db2.ast.DB2SQLObjectImpl;
import com.alibaba.druid.sql.dialect.db2.visitor.DB2ASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class DB2AlterTableSetWith extends DB2SQLObjectImpl implements SQLAlterTableItem {
   private boolean withReorgnize = false;
   private DistributeType distributeType;
   private List<DB2AlterTableDistributeByOption> options = new ArrayList();

   public boolean isWithReorgnize() {
      return this.withReorgnize;
   }

   public void setWithReorgnize(boolean withReorgnize) {
      this.withReorgnize = withReorgnize;
   }

   public DistributeType getDistributeType() {
      return this.distributeType;
   }

   public void setDistributeType(DistributeType distributeType) {
      this.distributeType = distributeType;
   }

   public List<DB2AlterTableDistributeByOption> getOptions() {
      return this.options;
   }

   public void setOptions(List<DB2AlterTableDistributeByOption> options) {
      this.options = options;
   }

   public void addOption(DB2AlterTableDistributeByOption option) {
      this.options.add(option);
      option.setParent(this);
   }

   public void accept0(DB2ASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.options);
      }

      visitor.endVisit(this);
   }

   public DB2AlterTableSetWith clone() {
      DB2AlterTableSetWith c = new DB2AlterTableSetWith();
      c.distributeType = this.distributeType;
      c.withReorgnize = this.withReorgnize;
      if (this.options != null && this.options.size() > 0) {
         for(DB2AlterTableDistributeByOption option : this.options) {
            c.addOption(option.clone());
         }
      }

      return c;
   }

   public static class DB2AlterTableDistributeByOption extends DB2SQLObjectImpl {
      private SQLExpr columnName;
      private SQLExpr opClass;

      public SQLExpr getColumnName() {
         return this.columnName;
      }

      public void setColumnName(SQLExpr columnName) {
         columnName.setParent(this);
         this.columnName = columnName;
      }

      public SQLExpr getOpClass() {
         return this.opClass;
      }

      public void setOpClass(SQLExpr opClass) {
         opClass.setParent(this);
         this.opClass = opClass;
      }

      public void accept0(SQLASTVisitor visitor) {
         this.accept0((DB2ASTVisitor)visitor);
      }

      public void accept0(DB2ASTVisitor visitor) {
         if (visitor.visit(this)) {
            if (this.columnName != null) {
               this.columnName.accept(visitor);
            }

            if (this.opClass != null) {
               this.opClass.accept(visitor);
            }
         }

         visitor.endVisit(this);
      }

      public DB2AlterTableDistributeByOption clone() {
         DB2AlterTableDistributeByOption o = new DB2AlterTableDistributeByOption();
         o.setColumnName(this.columnName.clone());
         if (this.opClass != null) {
            o.setOpClass(this.opClass.clone());
         }

         return o;
      }
   }

   public static enum DistributeType {
      with,
      by,
      randomly,
      replicated;
   }
}
