package com.alibaba.druid.sql.dialect.dm.ast.stmt;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLCreateStatement;
import com.alibaba.druid.sql.dialect.dm.visitor.DmASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class DmCreateSchemaStatement extends SQLStatementImpl implements DmStatement, SQLCreateStatement {
   List<SQLStatement> stmtList = new ArrayList();
   private SQLIdentifierExpr schemaName;
   private SQLIdentifierExpr userName;
   private boolean authorization;

   public DmCreateSchemaStatement(DbType dbType) {
      this.dbType = dbType;
   }

   public SQLIdentifierExpr getSchemaName() {
      return this.schemaName;
   }

   public void setSchemaName(SQLIdentifierExpr schemaName) {
      this.schemaName = schemaName;
   }

   public SQLIdentifierExpr getUserName() {
      return this.userName;
   }

   public void setUserName(SQLIdentifierExpr userName) {
      this.userName = userName;
   }

   public boolean isAuthorization() {
      return this.authorization;
   }

   public void setAuthorization(boolean authorization) {
      this.authorization = authorization;
   }

   protected void accept0(SQLASTVisitor v) {
      if (v instanceof DmASTVisitor) {
         this.accept0((DmASTVisitor)v);
      } else {
         if (v instanceof SQLASTOutputVisitor) {
            ((SQLASTOutputVisitor)v).print(this.toString());
         }

      }
   }

   public void accept0(DmASTVisitor visitor) {
      if (visitor.visit(this)) {
      }

      visitor.endVisit(this);
   }

   public List<SQLStatement> getStmtList() {
      return this.stmtList;
   }

   public void setStmtList(List<SQLStatement> stmtList) {
      this.stmtList = stmtList;
   }
}
