package com.alibaba.druid.sql.dialect.dm.ast.stmt;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExternalRecordFormat;
import com.alibaba.druid.sql.dialect.dm.ast.DMSQLObject;
import com.alibaba.druid.sql.dialect.dm.ast.DmSQLObjectImpl;
import com.alibaba.druid.sql.dialect.dm.ast.clause.DmStorageClause;
import com.alibaba.druid.sql.dialect.dm.visitor.DmASTVisitor;
import com.alibaba.druid.sql.dialect.oracle.ast.OracleSegmentAttributes;
import com.alibaba.druid.sql.dialect.oracle.ast.OracleSegmentAttributesImpl;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleLobStorageClause;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleXmlColumnProperties;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class DmCreateTableStatement extends SQLCreateTableStatement implements DmDDLStatement, OracleSegmentAttributes {
   private boolean inMemoryMetadata;
   private boolean cursorSpecificSegment;
   private Boolean parallel;
   private SQLExpr parallelValue;
   private DmStorageClause storage;
   private OracleLobStorageClause lobStorage;
   private Integer pctfree;
   private Integer pctused;
   private Integer initrans;
   private Integer maxtrans;
   private Integer pctincrease;
   private Integer compressLevel;
   private boolean compressForOltp;
   private Boolean cache;
   private DeferredSegmentCreation deferredSegmentCreation;
   private Boolean enableRowMovement;
   private List<SQLName> clusterColumns = new ArrayList();
   private SQLName cluster;
   private Organization organization;
   private SQLName of;
   private OIDIndex oidIndex;
   private boolean monitoring;
   private List<SQLName> including = new ArrayList();
   private OracleXmlColumnProperties xmlTypeColumnProperties;
   private Integer spacelimit;
   private Boolean unlimited;
   private SQLName filepath;
   private boolean datafile;
   protected ArrayList<PARMS> parmsList = new ArrayList();
   private SQLName directory;
   private SQLName location;

   public void simplify() {
      this.tablespace = null;
      this.storage = null;
      this.lobStorage = null;
      this.pctfree = null;
      this.pctused = null;
      this.initrans = null;
      this.maxtrans = null;
      this.pctincrease = null;
      this.logging = null;
      this.compress = null;
      this.compressLevel = null;
      this.compressForOltp = false;
      this.onCommitPreserveRows = false;
      this.onCommitDeleteRows = false;
      super.simplify();
   }

   public DmCreateTableStatement() {
      super(DbType.oracle);
   }

   public OracleLobStorageClause getLobStorage() {
      return this.lobStorage;
   }

   public void setLobStorage(OracleLobStorageClause lobStorage) {
      this.lobStorage = lobStorage;
   }

   public DeferredSegmentCreation getDeferredSegmentCreation() {
      return this.deferredSegmentCreation;
   }

   public void setDeferredSegmentCreation(DeferredSegmentCreation deferredSegmentCreation) {
      this.deferredSegmentCreation = deferredSegmentCreation;
   }

   public Boolean getCache() {
      return this.cache;
   }

   public void setCache(Boolean cache) {
      this.cache = cache;
   }

   public boolean isOnCommitDeleteRows() {
      return this.onCommitDeleteRows;
   }

   public void setOnCommitDeleteRows(boolean onCommitDeleteRows) {
      this.onCommitDeleteRows = onCommitDeleteRows;
   }

   public Integer getCompressLevel() {
      return this.compressLevel;
   }

   public void setCompressLevel(Integer compressLevel) {
      this.compressLevel = compressLevel;
   }

   public Integer getPctfree() {
      return this.pctfree;
   }

   public void setPctfree(Integer pctfree) {
      this.pctfree = pctfree;
   }

   public Integer getPctused() {
      return this.pctused;
   }

   public void setPctused(Integer pctused) {
      this.pctused = pctused;
   }

   public Integer getInitrans() {
      return this.initrans;
   }

   public void setInitrans(Integer initrans) {
      this.initrans = initrans;
   }

   public Integer getMaxtrans() {
      return this.maxtrans;
   }

   public void setMaxtrans(Integer maxtrans) {
      this.maxtrans = maxtrans;
   }

   public Integer getPctincrease() {
      return this.pctincrease;
   }

   public void setPctincrease(Integer pctincrease) {
      this.pctincrease = pctincrease;
   }

   public Boolean getParallel() {
      return this.parallel;
   }

   public void setParallel(Boolean parallel) {
      this.parallel = parallel;
   }

   public SQLExpr getParallelValue() {
      return this.parallelValue;
   }

   public void setParallelValue(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.parallelValue = x;
   }

   public boolean isCursorSpecificSegment() {
      return this.cursorSpecificSegment;
   }

   public void setCursorSpecificSegment(boolean cursorSpecificSegment) {
      this.cursorSpecificSegment = cursorSpecificSegment;
   }

   public boolean isInMemoryMetadata() {
      return this.inMemoryMetadata;
   }

   public void setInMemoryMetadata(boolean inMemoryMetadata) {
      this.inMemoryMetadata = inMemoryMetadata;
   }

   protected void accept0(SQLASTVisitor v) {
      if (v instanceof DmASTVisitor) {
         this.accept0((DmASTVisitor)v);
      } else {
         if (v instanceof SQLASTOutputVisitor) {
            ((SQLASTOutputVisitor)v).print(this.toString());
         }

      }
   }

   public DmStorageClause getStorage() {
      return this.storage;
   }

   public void setStorage(SQLObject storage) {
      if (storage != null) {
         storage.setParent(this);
      }

      this.storage = (DmStorageClause)storage;
   }

   public SQLName getOf() {
      return this.of;
   }

   public void setOf(SQLName of) {
      if (of != null) {
         of.setParent(this);
      }

      this.of = of;
   }

   public OIDIndex getOidIndex() {
      return this.oidIndex;
   }

   public void setOidIndex(OIDIndex oidIndex) {
      if (oidIndex != null) {
         oidIndex.setParent(this);
      }

      this.oidIndex = oidIndex;
   }

   public boolean isMonitoring() {
      return this.monitoring;
   }

   public void setMonitoring(boolean monitoring) {
      this.monitoring = monitoring;
   }

   public boolean isCompressForOltp() {
      return this.compressForOltp;
   }

   public void setCompressForOltp(boolean compressForOltp) {
      this.compressForOltp = compressForOltp;
   }

   public Boolean getEnableRowMovement() {
      return this.enableRowMovement;
   }

   public void setEnableRowMovement(Boolean enableRowMovement) {
      this.enableRowMovement = enableRowMovement;
   }

   public List<SQLName> getClusterColumns() {
      return this.clusterColumns;
   }

   public SQLName getCluster() {
      return this.cluster;
   }

   public void setCluster(SQLName x) {
      if (x != null) {
         x.setParent(this);
      }

      this.cluster = x;
   }

   public List<SQLName> getIncluding() {
      return this.including;
   }

   public Organization getOrganization() {
      return this.organization;
   }

   public void setOrganization(Organization organization) {
      if (organization != null) {
         organization.setParent(this);
      }

      this.organization = organization;
   }

   public SQLName getDirectory() {
      return this.directory;
   }

   public void setDirectory(SQLName directory) {
      this.directory = directory;
   }

   public SQLName getLocation() {
      return this.location;
   }

   public void setLocation(SQLName location) {
      this.location = location;
   }

   public void accept0(DmASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.tableSource);
         this.acceptChild(visitor, this.of);
         this.acceptChild(visitor, this.tableElementList);
         this.acceptChild(visitor, this.tablespace);
         this.acceptChild(visitor, this.select);
         this.acceptChild(visitor, this.storage);
         this.acceptChild(visitor, this.partitioning);
      }

      visitor.endVisit(this);
   }

   public OracleXmlColumnProperties getXmlTypeColumnProperties() {
      return this.xmlTypeColumnProperties;
   }

   public void setXmlTypeColumnProperties(OracleXmlColumnProperties x) {
      if (x != null) {
         x.setParent(this);
      }

      this.xmlTypeColumnProperties = x;
   }

   public Integer getSpacelimit() {
      return this.spacelimit;
   }

   public void setSpacelimit(Integer spacelimit) {
      this.spacelimit = spacelimit;
   }

   public Boolean getUnlimited() {
      return this.unlimited;
   }

   public void setUnlimited(Boolean unlimited) {
      this.unlimited = unlimited;
   }

   public SQLName getFilepath() {
      return this.filepath;
   }

   public void setFilepath(SQLName filepath) {
      this.filepath = filepath;
   }

   public boolean isDatafile() {
      return this.datafile;
   }

   public void setDatafile(boolean datafile) {
      this.datafile = datafile;
   }

   public ArrayList<PARMS> getParmsList() {
      return this.parmsList;
   }

   public void setParmsList(ArrayList<PARMS> parmsList) {
      this.parmsList = parmsList;
   }

   public static enum DeferredSegmentCreation {
      IMMEDIATE,
      DEFERRED;
   }

   public static class Organization extends OracleSegmentAttributesImpl implements OracleSegmentAttributes, DMSQLObject {
      public String type;
      private SQLName externalType;
      private SQLExpr externalDirectory;
      private SQLExternalRecordFormat externalDirectoryRecordFormat;
      private List<SQLExpr> externalDirectoryLocation = new ArrayList();
      private SQLExpr externalRejectLimit;

      protected void accept0(SQLASTVisitor v) {
         if (v instanceof DmASTVisitor) {
            this.accept0((DmASTVisitor)v);
         } else {
            if (v instanceof SQLASTOutputVisitor) {
               ((SQLASTOutputVisitor)v).print(this.toString());
            }

         }
      }

      public void accept0(DmASTVisitor visitor) {
         if (visitor.visit(this)) {
            this.acceptChild(visitor, this.tablespace);
            this.acceptChild(visitor, this.storage);
         }

         visitor.endVisit(this);
      }

      public String getType() {
         return this.type;
      }

      public void setType(String type) {
         this.type = type;
      }

      public SQLName getExternalType() {
         return this.externalType;
      }

      public void setExternalType(SQLName externalType) {
         this.externalType = externalType;
      }

      public SQLExpr getExternalDirectory() {
         return this.externalDirectory;
      }

      public void setExternalDirectory(SQLExpr externalDirectory) {
         this.externalDirectory = externalDirectory;
      }

      public SQLExternalRecordFormat getExternalDirectoryRecordFormat() {
         return this.externalDirectoryRecordFormat;
      }

      public void setExternalDirectoryRecordFormat(SQLExternalRecordFormat recordFormat) {
         if (recordFormat != null) {
            recordFormat.setParent(this);
         }

         this.externalDirectoryRecordFormat = recordFormat;
      }

      public SQLExpr getExternalRejectLimit() {
         return this.externalRejectLimit;
      }

      public void setExternalRejectLimit(SQLExpr externalRejectLimit) {
         if (externalRejectLimit != null) {
            externalRejectLimit.setParent(this);
         }

         this.externalRejectLimit = externalRejectLimit;
      }

      public List<SQLExpr> getExternalDirectoryLocation() {
         return this.externalDirectoryLocation;
      }
   }

   public static class OIDIndex extends OracleSegmentAttributesImpl implements DMSQLObject {
      private SQLName name;

      public void accept0(DmASTVisitor visitor) {
         if (visitor.visit(this)) {
            this.acceptChild(visitor, this.name);
            this.acceptChild(visitor, this.tablespace);
            this.acceptChild(visitor, this.storage);
         }

         visitor.endVisit(this);
      }

      protected void accept0(SQLASTVisitor v) {
         if (v instanceof DmASTVisitor) {
            this.accept0((DmASTVisitor)v);
         } else {
            if (v instanceof SQLASTOutputVisitor) {
               ((SQLASTOutputVisitor)v).print(this.toString());
            }

         }
      }

      public SQLName getName() {
         return this.name;
      }

      public void setName(SQLName name) {
         if (name != null) {
            name.setParent(this);
         }

         this.name = name;
      }
   }

   public static class PARMS extends DmSQLObjectImpl {
      protected Type type;
      protected SQLExpr expr;

      public void accept0(DmASTVisitor visitor) {
         if (visitor.visit(this)) {
         }

         visitor.endVisit(this);
      }

      public Type getType() {
         return this.type;
      }

      public void setType(Type type) {
         this.type = type;
      }

      public SQLExpr getExpr() {
         return this.expr;
      }

      public void setExpr(SQLExpr expr) {
         this.expr = expr;
      }
   }

   public static enum Type {
      FIELDS_DELIMITED_BY("FIELDS DELIMITED BY"),
      RECORDS_DELIMITED_BY("RECORDS DELIMITED BY"),
      ERRORS("ERRORS"),
      BADFILE("BADFILE"),
      LOG("LOG"),
      NULL_STR("NULL_STR"),
      SKIP("SKIP"),
      CHARACTER_CODE("CHARACTER_CODE");

      public final String name;

      private Type(String name) {
         this.name = name;
      }
   }
}
