package com.alibaba.druid.sql.dialect.dm.ast.stmt;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLHint;
import com.alibaba.druid.sql.ast.statement.SQLErrorLoggingClause;
import com.alibaba.druid.sql.ast.statement.SQLInsertInto;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.dialect.dm.ast.DMSQLObject;
import com.alibaba.druid.sql.dialect.dm.ast.DmSQLObjectImpl;
import com.alibaba.druid.sql.dialect.dm.ast.clause.DmReturningClause;
import com.alibaba.druid.sql.dialect.dm.visitor.DmASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class DmMultiInsertStatement extends DmStatementImpl {
   private SQLSelect subQuery;
   private Option option;
   private List<Entry> entries = new ArrayList();
   private List<SQLHint> hints = new ArrayList(1);

   public List<SQLHint> getHints() {
      return this.hints;
   }

   public void setHints(List<SQLHint> hints) {
      this.hints = hints;
   }

   public List<Entry> getEntries() {
      return this.entries;
   }

   public void addEntry(Entry entry) {
      if (entry != null) {
         entry.setParent(this);
      }

      this.entries.add(entry);
   }

   public Option getOption() {
      return this.option;
   }

   public void setOption(Option option) {
      this.option = option;
   }

   public SQLSelect getSubQuery() {
      return this.subQuery;
   }

   public void setSubQuery(SQLSelect subQuery) {
      this.subQuery = subQuery;
   }

   public void accept0(DmASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.entries);
         this.acceptChild(visitor, this.subQuery);
      }

      visitor.endVisit(this);
   }

   public static enum Option {
      ALL,
      FIRST;
   }

   public static class ConditionalInsertClause extends DmSQLObjectImpl implements Entry {
      private List<ConditionalInsertClauseItem> items = new ArrayList();
      private InsertIntoClause elseItem;

      public InsertIntoClause getElseItem() {
         return this.elseItem;
      }

      public void setElseItem(InsertIntoClause elseItem) {
         this.elseItem = elseItem;
      }

      public List<ConditionalInsertClauseItem> getItems() {
         return this.items;
      }

      public void addItem(ConditionalInsertClauseItem item) {
         if (item != null) {
            item.setParent(this);
         }

         this.items.add(item);
      }

      public void accept0(DmASTVisitor visitor) {
         if (visitor.visit(this)) {
            this.acceptChild(visitor, this.items);
            this.acceptChild(visitor, this.elseItem);
         }

         visitor.endVisit(this);
      }
   }

   public static class ConditionalInsertClauseItem extends DmSQLObjectImpl {
      private SQLExpr when;
      private InsertIntoClause then;

      public SQLExpr getWhen() {
         return this.when;
      }

      public void setWhen(SQLExpr when) {
         this.when = when;
      }

      public InsertIntoClause getThen() {
         return this.then;
      }

      public void setThen(InsertIntoClause then) {
         this.then = then;
      }

      public void accept0(DmASTVisitor visitor) {
         if (visitor.visit(this)) {
            this.acceptChild(visitor, this.when);
            this.acceptChild(visitor, this.then);
         }

         visitor.endVisit(this);
      }
   }

   public static class InsertIntoClause extends SQLInsertInto implements DMSQLObject, Entry {
      private DmReturningClause returning;
      private SQLErrorLoggingClause errorLogging;

      public InsertIntoClause() {
         this.dbType = DbType.oracle;
      }

      public DmReturningClause getReturning() {
         return this.returning;
      }

      public void setReturning(DmReturningClause returning) {
         this.returning = returning;
      }

      public SQLErrorLoggingClause getErrorLogging() {
         return this.errorLogging;
      }

      public void setErrorLogging(SQLErrorLoggingClause errorLogging) {
         this.errorLogging = errorLogging;
      }

      protected void accept0(SQLASTVisitor v) {
         if (v instanceof DmASTVisitor) {
            this.accept0((DmASTVisitor)v);
         } else {
            if (v instanceof SQLASTOutputVisitor) {
               ((SQLASTOutputVisitor)v).print(this.toString());
            }

         }
      }

      public void accept0(DmASTVisitor visitor) {
         if (visitor.visit(this)) {
            this.acceptChild(visitor, this.tableSource);
            this.acceptChild(visitor, this.columns);
            this.acceptChild(visitor, this.valuesList);
            this.acceptChild(visitor, this.query);
            this.acceptChild(visitor, this.returning);
            this.acceptChild(visitor, this.errorLogging);
         }

         visitor.endVisit(this);
      }

      public void cloneTo(InsertIntoClause x) {
         super.cloneTo(x);
         if (this.returning != null) {
            x.setReturning(this.returning.clone());
         }

         if (this.errorLogging != null) {
            x.setErrorLogging(this.errorLogging.clone());
         }

      }

      public InsertIntoClause clone() {
         InsertIntoClause x = new InsertIntoClause();
         this.cloneTo(x);
         return x;
      }
   }

   public interface Entry extends DMSQLObject {
   }
}
