package com.alibaba.druid.sql.dialect.dm.ast.stmt;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.dialect.dm.ast.clause.DmPartitionExtensionClause;
import com.alibaba.druid.sql.dialect.dm.ast.clause.DmSampleClause;
import com.alibaba.druid.sql.dialect.dm.visitor.DmASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class DmSelectTableReference extends SQLExprTableSource implements DmSelectTableSource {
   private boolean only = false;
   protected DmSelectPivotBase pivot;
   protected DmPartitionExtensionClause partition;
   protected DmSampleClause sampleClause;

   public DmSelectTableReference() {
   }

   public DmSelectTableReference(SQLExpr expr) {
      this.setExpr(expr);
   }

   public DmPartitionExtensionClause getPartition() {
      return this.partition;
   }

   public void setPartition(DmPartitionExtensionClause partition) {
      if (partition != null) {
         partition.setParent(this);
      }

      this.partition = partition;
   }

   public boolean isOnly() {
      return this.only;
   }

   public void setOnly(boolean only) {
      this.only = only;
   }

   public DmSampleClause getSampleClause() {
      return this.sampleClause;
   }

   public void setSampleClause(DmSampleClause sampleClause) {
      if (sampleClause != null) {
         sampleClause.setParent(this);
      }

      this.sampleClause = sampleClause;
   }

   public DmSelectPivotBase getPivot() {
      return this.pivot;
   }

   public void setPivot(DmSelectPivotBase pivot) {
      if (pivot != null) {
         pivot.setParent(this);
      }

      this.pivot = pivot;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof DmASTVisitor) {
         this.accept0((DmASTVisitor)visitor);
      } else {
         super.accept0(visitor);
      }

   }

   protected void accept0(DmASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.expr);
         this.acceptChild(visitor, this.partition);
         this.acceptChild(visitor, this.sampleClause);
         this.acceptChild(visitor, this.pivot);
      }

      visitor.endVisit(this);
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         if (!super.equals(o)) {
            return false;
         } else {
            DmSelectTableReference that = (DmSelectTableReference)o;
            if (this.only != that.only) {
               return false;
            } else {
               if (this.pivot != null) {
                  if (!this.pivot.equals(that.pivot)) {
                     return false;
                  }
               } else if (that.pivot != null) {
                  return false;
               }

               if (this.partition != null) {
                  if (!this.partition.equals(that.partition)) {
                     return false;
                  }
               } else if (that.partition != null) {
                  return false;
               }

               if (this.sampleClause != null) {
                  if (!this.sampleClause.equals(that.sampleClause)) {
                     return false;
                  }
               } else if (that.sampleClause != null) {
                  return false;
               }

               return this.flashback != null ? this.flashback.equals(that.flashback) : that.flashback == null;
            }
         }
      } else {
         return false;
      }
   }

   public int hashCode() {
      int result = super.hashCode();
      result = 31 * result + (this.only ? 1 : 0);
      result = 31 * result + (this.pivot != null ? this.pivot.hashCode() : 0);
      result = 31 * result + (this.partition != null ? this.partition.hashCode() : 0);
      result = 31 * result + (this.sampleClause != null ? this.sampleClause.hashCode() : 0);
      result = 31 * result + (this.flashback != null ? this.flashback.hashCode() : 0);
      return result;
   }

   public String toString() {
      return SQLUtils.toOracleString(this);
   }

   public DmSelectTableReference clone() {
      DmSelectTableReference x = new DmSelectTableReference();
      this.cloneTo(x);
      x.only = this.only;
      if (this.pivot != null) {
         x.setPivot(this.pivot.clone());
      }

      if (this.partition != null) {
         x.setPartition(this.partition.clone());
      }

      if (this.sampleClause != null) {
         x.setSampleClause(this.sampleClause.clone());
      }

      if (this.flashback != null) {
         this.setFlashback(this.flashback.clone());
      }

      return x;
   }
}
