package com.alibaba.druid.sql.dialect.greenplum.ast.stmt.alterTable;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.dialect.greenplum.ast.GPSQLObject;
import com.alibaba.druid.sql.dialect.greenplum.ast.GPSQLObjectImpl;
import com.alibaba.druid.sql.dialect.greenplum.visitor.GPASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class GPAlterTableDropConstraint extends GPSQLObjectImpl implements SQLAlterTableItem, GPSQLObject {
   private SQLExpr constraint;
   private boolean ifExists;
   private DorpType type;

   public SQLExpr getConstraint() {
      return this.constraint;
   }

   public void setConstraint(SQLExpr constraint) {
      this.constraint = constraint;
      constraint.setParent(this);
   }

   public boolean isIfExists() {
      return this.ifExists;
   }

   public void setIfExists(boolean ifExists) {
      this.ifExists = ifExists;
   }

   public DorpType getType() {
      return this.type;
   }

   public void setType(DorpType type) {
      this.type = type;
   }

   public void accept0(SQLASTVisitor visitor) {
      this.accept0((GPASTVisitor)visitor);
   }

   public void accept0(GPASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.constraint.accept(visitor);
      }

      visitor.endVisit(this);
   }

   public GPAlterTableDropConstraint clone() {
      GPAlterTableDropConstraint c = new GPAlterTableDropConstraint();
      c.setConstraint(this.constraint.clone());
      c.type = this.type;
      c.ifExists = this.ifExists;
      return c;
   }

   public static enum DorpType {
      restrict,
      cascade;
   }
}
