package com.alibaba.druid.sql.dialect.kingbase.ast.expression;

import com.alibaba.druid.sql.ast.SQLHint;
import com.alibaba.druid.sql.ast.statement.SQLTableSourceImpl;
import com.alibaba.druid.sql.dialect.kingbase.ast.statement.KingbaseUpdateStatement;
import com.alibaba.druid.sql.dialect.kingbase.visitor.KingbaseASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class KingbaseUpdateTableSource extends SQLTableSourceImpl {
   private KingbaseUpdateStatement update;

   public KingbaseUpdateTableSource(KingbaseUpdateStatement update) {
      this.update = update;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof KingbaseASTVisitor) {
         this.accept0((KingbaseASTVisitor)visitor);
      } else {
         throw new IllegalArgumentException("not support visitor type : " + visitor.getClass().getName());
      }
   }

   public void accept0(KingbaseASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.update);
      }

      visitor.endVisit(this);
   }

   public KingbaseUpdateStatement getUpdate() {
      return this.update;
   }

   public void setUpdate(KingbaseUpdateStatement update) {
      this.update = update;
   }

   public KingbaseUpdateTableSource clone() {
      KingbaseUpdateTableSource x = new KingbaseUpdateTableSource(this.update);
      x.setAlias(this.alias);
      if (this.flashback != null) {
         x.setFlashback(this.flashback.clone());
      }

      if (this.hints != null) {
         for(SQLHint e : this.hints) {
            SQLHint e2 = e.clone();
            e2.setParent(x);
            x.getHints().add(e2);
         }
      }

      return x;
   }
}
