package com.alibaba.druid.sql.dialect.mariadb.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.dialect.mariadb.visitor.MariadbASTVisitor;

public class MariadbShowTraceStatement extends MariadbStatementImpl implements MariadbShowStatement {
   private SQLOrderBy orderBy;
   private SQLExpr where;
   private SQLLimit limit;

   public SQLLimit getLimit() {
      return this.limit;
   }

   public void setLimit(SQLLimit limit) {
      this.limit = limit;
   }

   public SQLOrderBy getOrderBy() {
      return this.orderBy;
   }

   public void setOrderBy(SQLOrderBy orderBy) {
      this.orderBy = orderBy;
   }

   public SQLExpr getWhere() {
      return this.where;
   }

   public void setWhere(SQLExpr where) {
      this.where = where;
   }

   public void accept0(MariadbASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.where);
         this.acceptChild(visitor, this.orderBy);
         this.acceptChild(visitor, this.limit);
      }

      visitor.endVisit(this);
   }
}
