package com.alibaba.druid.sql.dialect.oracle.ast.expr;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.dialect.oracle.ast.OracleSQLObjectImpl;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import java.util.Collections;
import java.util.List;

public class OracleSysdateExpr extends OracleSQLObjectImpl implements SQLExpr {
   private String option;

   public String getOption() {
      return this.option;
   }

   public void setOption(String option) {
      this.option = option;
   }

   public void accept0(OracleASTVisitor visitor) {
      visitor.visit(this);
      visitor.endVisit(this);
   }

   public OracleSysdateExpr clone() {
      OracleSysdateExpr x = new OracleSysdateExpr();
      x.option = this.option;
      return x;
   }

   public List<SQLObject> getChildren() {
      return Collections.emptyList();
   }

   public String toString() {
      return SQLUtils.toOracleString(this);
   }
}
