package com.alibaba.druid.sql.dialect.oracle.ast.stmt;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.OracleSQLObjectImpl;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class OracleFileSpecification extends OracleSQLObjectImpl {
   private List<SQLExpr> fileNames = new ArrayList();
   private SQLExpr size;
   private boolean autoExtendOff = false;
   private SQLExpr autoExtendOn;

   public void accept0(OracleASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.fileNames);
         this.acceptChild(visitor, this.size);
         this.acceptChild(visitor, this.autoExtendOn);
      }

      visitor.endVisit(this);
   }

   public SQLExpr getAutoExtendOn() {
      return this.autoExtendOn;
   }

   public void setAutoExtendOn(SQLExpr autoExtendOn) {
      this.autoExtendOn = autoExtendOn;
   }

   public SQLExpr getSize() {
      return this.size;
   }

   public void setSize(SQLExpr size) {
      this.size = size;
   }

   public boolean isAutoExtendOff() {
      return this.autoExtendOff;
   }

   public void setAutoExtendOff(boolean autoExtendOff) {
      this.autoExtendOff = autoExtendOff;
   }

   public List<SQLExpr> getFileNames() {
      return this.fileNames;
   }

   public void setFileNames(List<SQLExpr> fileNames) {
      this.fileNames = fileNames;
   }
}
