package com.alibaba.druid.sql.dialect.sqlserver.ast.expr;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerObject;
import com.alibaba.druid.sql.dialect.sqlserver.visitor.SQLServerASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class SQLServerDateTimeExpr extends SQLExprImpl implements SQLServerObject, SQLLiteralExpr, SQLReplaceable {
   private SQLExpr inputdate;
   private SQLExpr value;

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (expr == this.value) {
         this.value = target;
         return true;
      } else {
         return false;
      }
   }

   protected void accept0(SQLASTVisitor v) {
      this.accept0((SQLServerASTVisitor)v);
   }

   public void accept0(SQLServerASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.inputdate);
         this.acceptChild(visitor, this.value);
      }

   }

   public SQLExpr getValue() {
      return this.value;
   }

   public void setValue(SQLExpr value) {
      this.value = value;
      this.value.setParent(this);
   }

   public SQLExpr getInputdate() {
      return this.inputdate;
   }

   public void setInputdate(SQLExpr inputdate) {
      this.inputdate = inputdate;
      this.inputdate.setParent(this);
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.inputdate == null ? 0 : this.inputdate.hashCode());
      result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
      return result;
   }

   public SQLServerDateTimeExpr clone() {
      SQLServerDateTimeExpr x = new SQLServerDateTimeExpr();
      x.inputdate = this.inputdate.clone();
      x.value = this.value.clone();
      return x;
   }

   public boolean equals(Object obj) {
      if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         SQLServerDateTimeExpr other = (SQLServerDateTimeExpr)obj;
         if (this.inputdate == null) {
            if (other.inputdate != null) {
               return false;
            }
         } else if (!this.inputdate.equals(other.inputdate)) {
            return false;
         }

         if (this.value == null) {
            if (other.value != null) {
               return false;
            }
         } else if (!this.value.equals(other.value)) {
            return false;
         }

         return true;
      }
   }
}
